/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.execution.types.ExecutorContext;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.InvocationRunner;
import es.bsc.compss.executor.external.ExecutionPlatformMirror;
import es.bsc.compss.executor.external.persistent.PersistentMirror;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.JavaInvoker;
import es.bsc.compss.invokers.JavaNestedInvoker;
import es.bsc.compss.invokers.OpenCLInvoker;
import es.bsc.compss.invokers.StorageInvoker;
import es.bsc.compss.invokers.binary.BinaryInvoker;
import es.bsc.compss.invokers.binary.COMPSsInvoker;
import es.bsc.compss.invokers.binary.ContainerInvoker;
import es.bsc.compss.invokers.binary.DecafInvoker;
import es.bsc.compss.invokers.binary.JuliaInvoker;
import es.bsc.compss.invokers.binary.MPIInvoker;
import es.bsc.compss.invokers.binary.MpmdMPIInvoker;
import es.bsc.compss.invokers.binary.OmpSsInvoker;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.external.PythonMPIInvoker;
import es.bsc.compss.invokers.external.persistent.CPersistentInvoker;
import es.bsc.compss.invokers.external.piped.CInvoker;
import es.bsc.compss.invokers.external.piped.PythonInvoker;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.ExecutorRequest;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationExecutionRequest;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.execution.exceptions.NonExistentDataException;
import es.bsc.compss.types.execution.exceptions.NonExistentElementException;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableResourcesException;
import es.bsc.compss.types.execution.exceptions.UnwritableValueException;
import es.bsc.compss.types.execution.exceptions.UnwritableValuesException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.JuliaDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MpmdMPIDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.compss.worker.TimeOutInvokerTask;
import es.bsc.compss.worker.TimeOutTask;
import es.bsc.wdc.affinity.ThreadAffinity;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Executor
implements Runnable,
InvocationRunner {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.Executor");
    private static final boolean WORKER_DEBUG = LOGGER.isDebugEnabled();
    private static final Logger TIMER_LOGGER = LogManager.getLogger((String)"es.bsc.compss.Timers");
    private static final String ERROR_OUT_FILES = "ERROR: One or more OUT files have not been created by task with Method Definition [";
    public static final boolean IS_TIMER_COMPSS_ENABLED;
    private static final int NANO_TO_MS = 1000000;
    private final InvocationContext context;
    protected final ExecutorContext platform;
    protected final int id;
    protected final String name;
    private boolean firstTimeAffinityCPU;
    private boolean firstTimeAffinityGPU;
    protected boolean isRegistered;
    protected PipePair cPipes;
    protected PipePair pyPipes;
    protected Invocation invocation;
    protected InvocationExecutionRequest.Listener invocationListener;
    protected InvocationResources resources;

    public Executor(InvocationContext context, ExecutorContext platform, int executorId, String executorName) {
        LOGGER.info("Executor " + executorName + " init");
        this.context = context;
        this.platform = platform;
        this.id = executorId;
        this.name = executorName;
        this.isRegistered = false;
        this.firstTimeAffinityCPU = true;
        this.firstTimeAffinityGPU = true;
    }

    public void start() {
        LOGGER.info("Executor started");
    }

    @Override
    public void run() {
        this.start();
        this.processRequests();
        this.finish();
    }

    public void finish() {
        if (Tracer.isActivated()) {
            this.emitAffinityEndEvents();
        }
        LOGGER.info("Executor " + this.name + " finished");
        Collection<ExecutionPlatformMirror<?>> mirrors = this.platform.getMirrors();
        for (ExecutionPlatformMirror<?> mirror : mirrors) {
            mirror.unregisterExecutor(this.name);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    private void processRequests() {
        ExecutorRequest execution = this.platform.newThread();
        while (true) {
            if (execution == null) {
                LOGGER.error("ERROR: Execution is null!!!!!");
            } else {
                try {
                    execution.run(this);
                }
                catch (ExecutorRequest.StopExecutorException se) {
                    LOGGER.debug("Stop request on Executor " + this.name);
                    break;
                }
            }
            execution = this.platform.getJob();
        }
    }

    public void processInvocation(Invocation inv, InvocationExecutionRequest.Listener listener) throws COMPSsException, Exception {
        this.invocation = inv;
        this.invocationListener = listener;
        boolean success = false;
        this.invocation.executionStarts();
        if (WORKER_DEBUG) {
            LOGGER.debug("Dequeuing job " + this.invocation.getJobId());
        }
        try {
            this.execute();
            success = true;
        }
        catch (COMPSsException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof COMPSsException) {
                throw (COMPSsException)rootCause;
            }
            throw e;
        }
        finally {
            if (WORKER_DEBUG) {
                LOGGER.debug("Job " + this.invocation.getJobId() + " finished (success: " + success + ")");
            }
            this.invocation.executionEnds();
            this.invocation = null;
            this.invocationListener = null;
        }
    }

    private void execute() throws Exception {
        if (this.invocation.getMethodImplementation().getMethodType() == MethodType.METHOD && this.invocation.getLang() != COMPSsConstants.Lang.JAVA && this.invocation.getLang() != COMPSsConstants.Lang.PYTHON && this.invocation.getLang() != COMPSsConstants.Lang.C) {
            String errMsg = "Incorrect language " + this.invocation.getLang() + " in job " + this.invocation.getJobId();
            LOGGER.error(errMsg);
            this.context.getThreadErrStream().println(errMsg);
            throw new JobExecutionException("Incorrect language " + this.invocation.getLang());
        }
        this.totalTimerAndTracingWrapperAndRun();
    }

    private void logExecutionException(Exception e) {
        LOGGER.error("ERROR: Executing task " + e.getMessage(), (Throwable)e);
        PrintStream out = this.context.getThreadOutStream();
        out.println("Exception executing task " + e.getMessage());
        PrintStream err = this.context.getThreadErrStream();
        e.printStackTrace(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void totalTimerAndTracingWrapperAndRun() throws Exception {
        if (Tracer.isActivated()) {
            this.emitingTaskStartEvents();
        }
        long timeTotalStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeTotalStart = System.nanoTime();
        }
        try {
            this.resourcesWrapperAndRun();
        }
        finally {
            if (Tracer.isActivated()) {
                this.emitTaskEndEvents();
            }
            if (IS_TIMER_COMPSS_ENABLED) {
                long timeTotalEnd = System.nanoTime();
                float timeTotalElapsed = (float)(timeTotalEnd - timeTotalStart) / 1000000.0f;
                int jobId = this.invocation.getJobId();
                TIMER_LOGGER.info("[TIMER] Total time for job " + jobId + ": " + timeTotalElapsed + " ms");
            }
        }
    }

    private void resourcesWrapperAndRun() throws Exception {
        int jobId = this.invocation.getJobId();
        if (IS_TIMER_COMPSS_ENABLED) {
            this.obtainExecutionResourcesWithTimer(jobId, this.invocation.getRequirements());
        } else {
            this.obtainExecutionResources(jobId, this.invocation.getRequirements());
        }
        try {
            this.sandBoxWrapperAndRun();
        }
        finally {
            if (IS_TIMER_COMPSS_ENABLED) {
                this.releaseResourcesWithTimer(jobId);
            } else {
                this.releaseResources(jobId);
            }
        }
    }

    private void sandBoxWrapperAndRun() throws Exception {
        ExecutionSandbox twd = null;
        try {
            twd = IS_TIMER_COMPSS_ENABLED ? this.createTaskSandboxWithTimer() : this.createTaskSandbox();
            this.filesWrapperAndRun(twd);
            if (IS_TIMER_COMPSS_ENABLED) {
                this.cleanTaskSandboxWithTimer(twd);
            } else {
                this.cleanTaskSandbox(twd);
            }
        }
        catch (COMPSsException e) {
            if (IS_TIMER_COMPSS_ENABLED) {
                this.cleanTaskSandboxWithTimer(twd);
            } else {
                this.cleanTaskSandbox(twd);
            }
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void filesWrapperAndRun(ExecutionSandbox twd) throws Exception {
        boolean alreadyFailed = false;
        boolean producesEmptyResultsOnFailure = this.invocation.producesEmptyResultsOnFailure();
        try {
            if (IS_TIMER_COMPSS_ENABLED) {
                this.stageInWithTimer(twd);
                this.redirectStreamsAndRunWithTimer(twd);
            } else {
                this.stageIn(twd);
                this.redirectStreamsAndRun(twd);
            }
            if (alreadyFailed) {
                if (!producesEmptyResultsOnFailure) return;
            }
        }
        catch (COMPSsException e) {
            try {
                this.logExecutionException((Exception)((Object)e));
                alreadyFailed = true;
                producesEmptyResultsOnFailure = true;
                throw e;
                catch (Exception e2) {
                    this.logExecutionException(e2);
                    alreadyFailed = true;
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (alreadyFailed) {
                    if (!producesEmptyResultsOnFailure) throw throwable;
                }
                try {
                    if (IS_TIMER_COMPSS_ENABLED) {
                        this.stageOutWithTimer(twd, !alreadyFailed, producesEmptyResultsOnFailure);
                        throw throwable;
                    }
                    this.stageOut(twd, !alreadyFailed, producesEmptyResultsOnFailure);
                    throw throwable;
                }
                catch (Exception ex) {
                    if (alreadyFailed) {
                        LOGGER.warn("Another exception after unbinding files: " + ex.getMessage(), (Throwable)ex);
                        PrintStream out = this.context.getThreadOutStream();
                        out.println("Another exception unbinding files: " + ex.getMessage());
                        PrintStream err = this.context.getThreadErrStream();
                        ex.printStackTrace(err);
                        throw throwable;
                    }
                    this.logExecutionException(ex);
                    throw ex;
                }
            }
        }
        try {
            if (IS_TIMER_COMPSS_ENABLED) {
                this.stageOutWithTimer(twd, !alreadyFailed, producesEmptyResultsOnFailure);
                return;
            }
            this.stageOut(twd, !alreadyFailed, producesEmptyResultsOnFailure);
            return;
        }
        catch (Exception ex) {
            if (alreadyFailed) {
                LOGGER.warn("Another exception after unbinding files: " + ex.getMessage(), (Throwable)ex);
                PrintStream out = this.context.getThreadOutStream();
                out.println("Another exception unbinding files: " + ex.getMessage());
                PrintStream err = this.context.getThreadErrStream();
                ex.printStackTrace(err);
                return;
            }
            this.logExecutionException(ex);
            throw ex;
        }
    }

    private void redirectStreamsAndRunWithTimer(ExecutionSandbox twd) throws Exception {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Executing task invocation for Job " + jobId);
        long timeExecTaskStart = 0L;
        timeExecTaskStart = System.nanoTime();
        this.redirectStreamsAndRun(twd);
        long timeExecTaskEnd = System.nanoTime();
        float timeExecTaskElapsed = (float)(timeExecTaskEnd - timeExecTaskStart) / 1000000.0f;
        TIMER_LOGGER.info("[TIMER] Execute job " + jobId + ": " + timeExecTaskElapsed + " ms");
    }

    private void redirectStreamsAndRun(ExecutionSandbox twd) throws Exception {
        String streamsPath = this.context.getStandardStreamsPath(this.invocation);
        this.context.registerOutputs(streamsPath);
        PrintStream out = this.context.getThreadOutStream();
        if (this.invocation.isDebugEnabled()) {
            out.println("[EXECUTOR] executeTask - Begin task execution");
        }
        try {
            this.runInvocation(twd);
        }
        catch (COMPSsException ce) {
            LOGGER.warn("[EXECUTOR] executeTask - COMPSs Exception received");
            out.println("[EXECUTOR] executeTask - COMPSs Exception received");
            throw ce;
        }
        catch (Exception jee) {
            LOGGER.error("[EXECUTOR] executeTask - Error in task execution");
            out.println("[EXECUTOR] executeTask - Error in task execution");
            PrintStream err = this.context.getThreadErrStream();
            err.println("[EXECUTOR] executeTask - Error in task execution");
            jee.printStackTrace(err);
            throw jee;
        }
        finally {
            if (this.invocation.isDebugEnabled()) {
                out.println("[EXECUTOR] executeTask - End task execution");
            }
            this.context.unregisterOutputs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInvocation(ExecutionSandbox twd) throws COMPSsException, JobExecutionException {
        Invoker invoker;
        TimerTask timerTask = null;
        switch (this.invocation.getMethodImplementation().getMethodType()) {
            case METHOD: 
            case MULTI_NODE: {
                invoker = this.selectNativeMethodInvoker(twd, this.resources);
                timerTask = new TimeOutTask(this.invocation.getTaskId());
                break;
            }
            case CONTAINER: {
                invoker = new ContainerInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case BINARY: {
                invoker = new BinaryInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case PYTHON_MPI: {
                invoker = new PythonMPIInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case MPI: {
                invoker = new MPIInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case MPMDMPI: {
                invoker = new MpmdMPIInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case COMPSs: {
                invoker = new COMPSsInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case DECAF: {
                invoker = new DecafInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case JULIA: {
                invoker = new JuliaInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case OMPSS: {
                invoker = new OmpSsInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            case OPENCL: {
                invoker = new OpenCLInvoker(this.context, this.invocation, twd, this.resources);
                break;
            }
            default: {
                throw new JobExecutionException("Undefined invoker. It could be cause by an incoherent task type");
            }
        }
        if (timerTask == null) {
            timerTask = new TimeOutInvokerTask(this.invocation.getTaskId(), invoker);
        }
        try {
            this.platform.registerRunningJob(this.invocation, invoker, timerTask);
            invoker.runInvocation(this);
        }
        finally {
            timerTask.cancel();
            this.platform.unregisterRunningJob(this.invocation.getJobId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invoker selectNativeMethodInvoker(ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        PrintStream out = this.context.getThreadOutStream();
        switch (this.invocation.getLang()) {
            case JAVA: {
                JavaInvoker javaInvoker = null;
                switch (this.context.getExecutionType()) {
                    case COMPSS: {
                        if (this.context.getRuntimeAPI() != null && this.context.getLoaderAPI() != null) {
                            out.println("Nested Support enabled on the Invocation Context!");
                            javaInvoker = new JavaNestedInvoker(this.context, this.invocation, sandbox, assignedResources);
                            break;
                        }
                        javaInvoker = new JavaInvoker(this.context, this.invocation, sandbox, assignedResources);
                        break;
                    }
                    case STORAGE: {
                        javaInvoker = new StorageInvoker(this.context, this.invocation, sandbox, assignedResources);
                    }
                }
                return javaInvoker;
            }
            case PYTHON: {
                if (this.pyPipes == null) {
                    PipedMirror mirror;
                    ExecutorContext executorContext = this.platform;
                    synchronized (executorContext) {
                        mirror = (PipedMirror)this.platform.getMirror(PythonInvoker.class);
                        if (mirror == null) {
                            mirror = PythonInvoker.getMirror(this.context, this.platform);
                            this.platform.registerMirror(PythonInvoker.class, mirror);
                        }
                    }
                    this.pyPipes = mirror.registerExecutor(this.id, this.name);
                }
                return new PythonInvoker(this.context, this.invocation, sandbox, assignedResources, this.pyPipes);
            }
            case C: {
                ExternalInvoker cInvoker = null;
                if (this.context.isPersistentCEnabled()) {
                    cInvoker = new CPersistentInvoker(this.context, this.invocation, sandbox, assignedResources);
                    if (!this.isRegistered) {
                        PersistentMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PersistentMirror)this.platform.getMirror(CPersistentInvoker.class);
                            if (mirror == null) {
                                mirror = CPersistentInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CPersistentInvoker.class, mirror);
                            }
                        }
                        mirror.registerExecutor(this.id, this.name);
                        this.isRegistered = true;
                    }
                } else {
                    if (this.cPipes == null) {
                        PipedMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PipedMirror)this.platform.getMirror(CInvoker.class);
                            if (mirror == null) {
                                mirror = (PipedMirror)CInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CInvoker.class, mirror);
                            }
                        }
                        this.cPipes = mirror.registerExecutor(this.id, this.name);
                    }
                    cInvoker = new CInvoker(this.context, this.invocation, sandbox, assignedResources, this.cPipes);
                }
                return cInvoker;
            }
        }
        throw new JobExecutionException("Unrecognised lang for a method type invocation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obtainExecutionResourcesWithTimer(int jobId, ResourceDescription requirements) throws UnsufficientAvailableResourcesException {
        long timeAssignResourcesStart = 0L;
        timeAssignResourcesStart = System.nanoTime();
        try {
            this.obtainExecutionResources(jobId, requirements);
        }
        finally {
            long timeAssignResourcesEnd = System.nanoTime();
            float timeAssignResourcesElapsed = (float)(timeAssignResourcesEnd - timeAssignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Assign resources for job " + jobId + ": " + timeAssignResourcesElapsed + " ms");
        }
    }

    private void obtainExecutionResources(int jobId, ResourceDescription requirements) throws UnsufficientAvailableResourcesException {
        LOGGER.debug("Assigning resources for Job " + jobId);
        try {
            this.resources = this.platform.acquireResources(jobId, requirements, this.resources);
            this.assignExecutionResources();
        }
        catch (Exception e) {
            this.logExecutionException(e);
            throw e;
        }
    }

    private void assignExecutionResources() {
        if (Tracer.isActivated()) {
            this.emitAffinityChangeEvents();
        }
        if (this.resources != null && this.resources.getAssignedCPUs() != null && this.resources.getAssignedCPUs().length > 0) {
            try {
                ThreadAffinity.setCurrentThreadAffinity((int[])this.resources.getAssignedCPUs());
            }
            catch (Exception e) {
                LOGGER.warn("Error setting affinity for Job " + this.invocation.getJobId(), (Throwable)e);
            }
        }
    }

    @Override
    public void stalledCodeExecution() {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Release binded resources for Job " + jobId);
        long timeUnassignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeUnassignResourcesStart = System.nanoTime();
        }
        this.platform.blockedRunner(this.invocation, this, this.resources);
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeUnassignResourcesEnd = System.nanoTime();
            float timeUnassignResourcesElapsed = (float)(timeUnassignResourcesEnd - timeUnassignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Unassign resources for job " + jobId + ": " + timeUnassignResourcesElapsed + " ms");
        }
    }

    @Override
    public void readyToContinueExecution(Semaphore sem) {
        long timeAssignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeAssignResourcesStart = System.nanoTime();
        }
        this.platform.unblockedRunner(this.invocation, this, this.resources, sem);
        this.assignExecutionResources();
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeAssignResourcesEnd = System.nanoTime();
            float timeAssignResourcesElapsed = (float)(timeAssignResourcesEnd - timeAssignResourcesStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Re-assign resources for job " + jobId + ": " + timeAssignResourcesElapsed + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResourcesWithTimer(int jobId) {
        long timeUnassignResourcesStart = 0L;
        timeUnassignResourcesStart = System.nanoTime();
        try {
            this.platform.releaseResources(jobId);
        }
        finally {
            long timeUnassignResourcesEnd = System.nanoTime();
            float timeUnassignResourcesElapsed = (float)(timeUnassignResourcesEnd - timeUnassignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Unassign resources for job " + jobId + ": " + timeUnassignResourcesElapsed + " ms");
        }
    }

    private void releaseResources(int jobId) {
        LOGGER.debug("Release binded resources for Job " + jobId);
        this.platform.releaseResources(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionSandbox createTaskSandboxWithTimer() throws Exception {
        long timeSandboxStart = 0L;
        timeSandboxStart = System.nanoTime();
        try {
            ExecutionSandbox executionSandbox = this.createTaskSandbox();
            return executionSandbox;
        }
        finally {
            long timeSandboxEnd = System.nanoTime();
            float timeSandboxElapsed = (float)(timeSandboxEnd - timeSandboxStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Create sandbox for job " + this.invocation.getJobId() + ": " + timeSandboxElapsed + " ms");
        }
    }

    private ExecutionSandbox createTaskSandbox() throws Exception {
        ExecutionSandbox taskWD;
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Creating task sandbox for Job " + jobId);
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.CREATING_TASK_SANDBOX);
        }
        AbstractMethodImplementation impl = this.invocation.getMethodImplementation();
        try {
            File workingDir;
            boolean isSpecific;
            String specificWD = "";
            switch (impl.getMethodType()) {
                case CONTAINER: {
                    ContainerDefinition contImpl = (ContainerDefinition)impl.getDefinition();
                    specificWD = contImpl.getWorkingDir();
                    break;
                }
                case BINARY: {
                    BinaryDefinition binaryImpl = (BinaryDefinition)impl.getDefinition();
                    specificWD = binaryImpl.getWorkingDir();
                    break;
                }
                case MPI: {
                    MPIDefinition mpiImpl = (MPIDefinition)impl.getDefinition();
                    specificWD = mpiImpl.getWorkingDir();
                    break;
                }
                case MPMDMPI: {
                    MpmdMPIDefinition mpmpdDef = (MpmdMPIDefinition)impl.getDefinition();
                    specificWD = mpmpdDef.getWorkingDir();
                    break;
                }
                case PYTHON_MPI: {
                    PythonMPIDefinition nativeMPIImpl = (PythonMPIDefinition)impl.getDefinition();
                    specificWD = nativeMPIImpl.getWorkingDir();
                    break;
                }
                case COMPSs: {
                    COMPSsDefinition compssImpl = (COMPSsDefinition)impl.getDefinition();
                    if (compssImpl.getWorkingDir().equals("[unassigned]")) break;
                    specificWD = compssImpl.getWorkingDir() + File.separator;
                    break;
                }
                case DECAF: {
                    DecafDefinition decafImpl = (DecafDefinition)impl.getDefinition();
                    specificWD = decafImpl.getWorkingDir();
                    break;
                }
                case JULIA: {
                    JuliaDefinition juliaImpl = (JuliaDefinition)impl.getDefinition();
                    specificWD = juliaImpl.getWorkingDir();
                    break;
                }
                case OMPSS: {
                    OmpSsDefinition ompssImpl = (OmpSsDefinition)impl.getDefinition();
                    specificWD = ompssImpl.getWorkingDir();
                    break;
                }
                case OPENCL: {
                    OpenCLDefinition openclImpl = (OpenCLDefinition)impl.getDefinition();
                    specificWD = openclImpl.getWorkingDir();
                    break;
                }
                default: {
                    specificWD = null;
                }
            }
            boolean bl = isSpecific = specificWD != null && !specificWD.isEmpty() && !specificWD.equals("[unassigned]");
            if (isSpecific) {
                workingDir = BinaryRunner.getUpdatedWorkingDir(this.invocation.getParams(), specificWD);
            } else {
                String completePath = this.context.getWorkingDir() + "sandBox" + File.separator + "job_" + jobId;
                workingDir = new File(completePath);
            }
            taskWD = new ExecutionSandbox(workingDir, isSpecific);
            taskWD.create();
        }
        catch (Exception e) {
            this.logExecutionException(e);
            throw e;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd((TraceEvent)TraceEvent.CREATING_TASK_SANDBOX);
            }
        }
        return taskWD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTaskSandboxWithTimer(ExecutionSandbox twd) {
        long timeCleanSandboxStart = 0L;
        timeCleanSandboxStart = System.nanoTime();
        try {
            this.cleanTaskSandbox(twd);
        }
        finally {
            long timeCleanSandboxEnd = System.nanoTime();
            float timeCleanSandboxElapsed = (float)(timeCleanSandboxEnd - timeCleanSandboxStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Clean sandbox for job " + jobId + ": " + timeCleanSandboxElapsed + " ms");
        }
    }

    private void cleanTaskSandbox(ExecutionSandbox twd) {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Cleaning task sandbox for Job " + jobId);
        if (twd != null) {
            try {
                if (Tracer.isActivated()) {
                    Tracer.emitEvent((TraceEvent)TraceEvent.REMOVING_TASK_SANDBOX);
                }
                twd.clean();
            }
            finally {
                if (Tracer.isActivated()) {
                    Tracer.emitEventEnd((TraceEvent)TraceEvent.REMOVING_TASK_SANDBOX);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stageInWithTimer(ExecutionSandbox sandbox) throws Exception {
        long timeBindOriginalFilesStart = 0L;
        timeBindOriginalFilesStart = System.nanoTime();
        try {
            this.stageIn(sandbox);
        }
        finally {
            long timeBindOriginalFilesEnd = System.nanoTime();
            float timeBindOriginalFilesElapsed = (float)(timeBindOriginalFilesEnd - timeBindOriginalFilesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Bind original files for job " + this.invocation.getJobId() + ": " + timeBindOriginalFilesElapsed + " ms");
        }
    }

    private void stageIn(ExecutionSandbox sandbox) throws Exception {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Binding renamed files to sandboxed original names for Job " + jobId);
        try {
            String renamedFilePath;
            for (InvocationParam param : this.invocation.getParams()) {
                if (!param.isKeepRename()) {
                    this.bindOriginalFilenameToRenames(param, sandbox);
                    continue;
                }
                renamedFilePath = (String)param.getValue();
                LOGGER.debug("Parameter keeps rename: " + renamedFilePath);
                param.setRenamedName(renamedFilePath);
                param.setOriginalName(renamedFilePath);
            }
            if (this.invocation.getTarget() != null) {
                LOGGER.debug("Invocation has non-null target");
                InvocationParam param = this.invocation.getTarget();
                if (!param.isKeepRename()) {
                    this.bindOriginalFilenameToRenames(param, sandbox);
                } else {
                    String renamedFilePath2 = (String)param.getValue();
                    LOGGER.debug("Parameter keeps rename: " + renamedFilePath2);
                    param.setRenamedName(renamedFilePath2);
                    param.setOriginalName(renamedFilePath2);
                }
            }
            for (InvocationParam param : this.invocation.getResults()) {
                if (!param.isKeepRename()) {
                    this.bindOriginalFilenameToRenames(param, sandbox);
                    continue;
                }
                renamedFilePath = (String)param.getValue();
                LOGGER.debug("Parameter keeps rename: " + renamedFilePath);
                param.setRenamedName(renamedFilePath);
                param.setOriginalName(renamedFilePath);
            }
        }
        catch (Exception e) {
            this.logExecutionException(e);
            throw e;
        }
    }

    private void bindOriginalFilenameToRenames(InvocationParam param, ExecutionSandbox sandbox) throws IOException {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.BIND_ORIG_NAME);
        }
        if (param.isCollective()) {
            InvocationParamCollection cp = (InvocationParamCollection)param;
            for (InvocationParam p : cp.getCollectionParameters()) {
                this.bindOriginalFilenameToRenames(p, sandbox);
            }
        } else if (param.getType() == DataType.FILE_T) {
            String renamedPath = (String)param.getValue();
            LOGGER.debug("Renamed File Path is " + renamedPath);
            param.setRenamedName(renamedPath);
            File renamedFile = new File(renamedPath);
            if (renamedFile.getName().equals(param.getOriginalName())) {
                param.setOriginalName(renamedPath);
            } else {
                String originalName = param.getOriginalName();
                String dataId = param.getDataMgmtId();
                String inSandboxPath = sandbox.addFile(dataId, renamedFile, originalName);
                if (inSandboxPath != null) {
                    LOGGER.debug("Setting Original Name to " + inSandboxPath);
                    param.setOriginalName(inSandboxPath);
                    param.setValue((Object)inSandboxPath);
                } else {
                    param.setRenamedName(param.getOriginalName());
                    param.setValue((Object)param.getOriginalName());
                }
            }
        }
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.BIND_ORIG_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stageOutWithTimer(ExecutionSandbox sandbox, boolean raiseExceptionIfNonExistent, boolean createifNonExistent) throws IOException, JobExecutionException {
        long timeUnbindOriginalFilesStart = 0L;
        timeUnbindOriginalFilesStart = System.nanoTime();
        try {
            this.stageOut(sandbox, raiseExceptionIfNonExistent, createifNonExistent);
        }
        finally {
            long timeUnbindOriginalFilesEnd = System.nanoTime();
            float timeUnbindOriginalFilesElapsed = (float)(timeUnbindOriginalFilesEnd - timeUnbindOriginalFilesStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Unbind original files for job " + jobId + ": " + timeUnbindOriginalFilesElapsed + " ms");
        }
    }

    private void stageOut(ExecutionSandbox sandbox, boolean raiseExceptionIfNonExistent, boolean createifNonExistent) throws JobExecutionException {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Removing renamed files to sandboxed original names for Job " + jobId);
        String message = null;
        boolean failure = false;
        for (InvocationParam param : this.invocation.getParams()) {
            try {
                this.stageOutParam(param, sandbox, raiseExceptionIfNonExistent, createifNonExistent);
            }
            catch (Exception e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        if (this.invocation.getTarget() != null) {
            try {
                this.stageOutParam(this.invocation.getTarget(), sandbox, raiseExceptionIfNonExistent, createifNonExistent);
            }
            catch (Exception e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        for (InvocationParam param : this.invocation.getResults()) {
            try {
                this.stageOutParam(param, sandbox, raiseExceptionIfNonExistent, createifNonExistent);
            }
            catch (Exception e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        if (failure) {
            throw new JobExecutionException(message);
        }
    }

    private void stageOutParam(InvocationParam param, ExecutionSandbox sandbox, boolean raiseExceptionIfNonExistent, boolean createifNonExistent) throws NonExistentDataException, UnwritableValueException {
        LinkedList<UnwritableValueException> unwrittableExc;
        LinkedList<NonExistentDataException> nonExistsExc;
        block12: {
            nonExistsExc = new LinkedList<NonExistentDataException>();
            unwrittableExc = new LinkedList<UnwritableValueException>();
            if (param.isCollective()) {
                InvocationParamCollection cp = (InvocationParamCollection)param;
                for (InvocationParam p : cp.getCollectionParameters()) {
                    try {
                        this.stageOutParam(p, sandbox, raiseExceptionIfNonExistent, createifNonExistent);
                    }
                    catch (NonExistentDataException nede) {
                        nonExistsExc.add(nede);
                    }
                    catch (UnwritableValueException uve) {
                        unwrittableExc.add(uve);
                    }
                }
            } else {
                this.unbindOriginalFilenameToRename(param, sandbox);
            }
            if (param.isWriteFinalValue()) {
                try {
                    if (!param.isForwardedResult()) {
                        this.context.storeParam(param, createifNonExistent);
                    }
                    this.invocationListener.onResultAvailable(param);
                }
                catch (NonExistentDataException nede) {
                    if (!raiseExceptionIfNonExistent) break block12;
                    throw nede;
                }
            }
        }
        if (raiseExceptionIfNonExistent && !nonExistsExc.isEmpty()) {
            throw new NonExistentElementException(param.getName(), nonExistsExc);
        }
        if (!unwrittableExc.isEmpty()) {
            throw new UnwritableValuesException(unwrittableExc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindOriginalFilenameToRename(InvocationParam param, ExecutionSandbox sandbox) {
        if (param.getType() == DataType.FILE_T && !param.isKeepRename()) {
            if (Tracer.isActivated()) {
                Tracer.emitEvent((TraceEvent)TraceEvent.UNBIND_ORIG_NAME);
            }
            try {
                String inSandboxPath = param.getOriginalName();
                String renamedFilePath = param.getRenamedName();
                LOGGER.debug("Treating file " + inSandboxPath);
                File internalFile = new File(inSandboxPath);
                File externalFile = new File(renamedFilePath);
                try {
                    if (!inSandboxPath.equals(renamedFilePath)) {
                        if (internalFile.exists()) {
                            sandbox.removeFile(inSandboxPath, renamedFilePath);
                        } else if (externalFile.exists()) {
                            LOGGER.debug("Repeated data for " + internalFile + ". Nothing to do");
                        } else {
                            String msg = "WARN: Output file " + inSandboxPath + " does not exist";
                            this.context.getThreadErrStream().println(msg);
                        }
                    }
                }
                catch (IOException e) {
                    this.context.getThreadErrStream().println(e.getMessage());
                }
                finally {
                    param.setValue((Object)renamedFilePath);
                    File inSandboxFile = new File(inSandboxPath);
                    String originalFileName = inSandboxFile.getName();
                    param.setOriginalName(originalFileName);
                }
            }
            finally {
                if (Tracer.isActivated()) {
                    Tracer.emitEventEnd((TraceEvent)TraceEvent.UNBIND_ORIG_NAME);
                }
            }
        }
    }

    private void emitingTaskStartEvents() {
        if (Tracer.isActivated() & Tracer.isTracingTaskDependencies() && this.invocation.getPredecessors() != null) {
            for (Integer i : this.invocation.getPredecessors()) {
                Tracer.emitCommEvent((boolean)false, (int)123, (int)1, (int)i, (long)0L);
            }
        }
        int numNodes = 1;
        if (this.invocation.getSlaveNodesNames() != null) {
            numNodes = this.invocation.getSlaveNodesNames().size() + 1;
        }
        int nCPUs = ((MethodResourceDescription)this.invocation.getRequirements()).getTotalCPUComputingUnits() * numNodes;
        Tracer.emitEvent((TraceEventType)TraceEventType.CPU_COUNTS, (long)nCPUs);
        int nGPUs = ((MethodResourceDescription)this.invocation.getRequirements()).getTotalGPUComputingUnits() * numNodes;
        Tracer.emitEvent((TraceEventType)TraceEventType.GPU_COUNTS, (long)nGPUs);
        int memory = (int)((MethodResourceDescription)this.invocation.getRequirements()).getMemorySize() * numNodes;
        if (memory < 0) {
            memory = 0;
        }
        Tracer.emitEvent((TraceEventType)TraceEventType.MEMORY, (long)memory);
        int diskBW = ((MethodResourceDescription)this.invocation.getRequirements()).getStorageBW() * numNodes;
        if (diskBW < 0) {
            diskBW = 0;
        }
        Tracer.emitEvent((TraceEventType)TraceEventType.DISK_BW, (long)diskBW);
        int taskType = this.invocation.getMethodImplementation().getMethodType().ordinal() + 1;
        Tracer.emitEvent((TraceEventType)TraceEventType.TASKTYPE, (long)taskType);
        Tracer.emitEvent((TraceEvent)TraceEvent.TASK_RUNNING);
    }

    private void emitTaskEndEvents() {
        if (Tracer.isActivated() & Tracer.isTracingTaskDependencies()) {
            for (int i = 0; i < this.invocation.getNumSuccessors(); ++i) {
                Tracer.emitCommEvent((boolean)true, (int)123, (int)1, (int)this.invocation.getTaskId(), (long)0L);
            }
        }
        Tracer.emitEventEnd((TraceEventType)TraceEventType.CPU_COUNTS);
        Tracer.emitEventEnd((TraceEventType)TraceEventType.GPU_COUNTS);
        Tracer.emitEventEnd((TraceEventType)TraceEventType.MEMORY);
        Tracer.emitEventEnd((TraceEventType)TraceEventType.DISK_BW);
        Tracer.emitEventEnd((TraceEventType)TraceEventType.TASKTYPE);
        Tracer.emitEventEnd((TraceEvent)TraceEvent.TASK_RUNNING);
    }

    private void emitAffinityChangeEvents() {
        if (this.resources != null) {
            int[] gpus;
            int[] cpus = this.resources.getAssignedCPUs();
            if (cpus != null && cpus.length > 0) {
                if (this.firstTimeAffinityCPU) {
                    this.firstTimeAffinityCPU = false;
                } else {
                    Tracer.emitEventEnd((TraceEventType)TraceEventType.TASKS_CPU_AFFINITY);
                }
                Tracer.emitEvent((TraceEventType)TraceEventType.TASKS_CPU_AFFINITY, (long)((long)cpus[0] + 1L));
            }
            if ((gpus = this.resources.getAssignedGPUs()) != null && gpus.length > 0) {
                if (this.firstTimeAffinityGPU) {
                    this.firstTimeAffinityGPU = false;
                } else {
                    Tracer.emitEventEnd((TraceEventType)TraceEventType.TASKS_GPU_AFFINITY);
                }
                Tracer.emitEvent((TraceEventType)TraceEventType.TASKS_GPU_AFFINITY, (long)((long)gpus[0] + 1L));
            }
        }
    }

    private void emitAffinityEndEvents() {
        if (!this.firstTimeAffinityCPU) {
            Tracer.emitEvent((TraceEventType)TraceEventType.TASKS_CPU_AFFINITY, (long)0L);
        }
        if (!this.firstTimeAffinityGPU) {
            Tracer.emitEvent((TraceEventType)TraceEventType.TASKS_GPU_AFFINITY, (long)0L);
        }
    }

    static {
        String isTimerCOMPSsEnabledProperty = System.getProperty("compss.timers");
        IS_TIMER_COMPSS_ENABLED = isTimerCOMPSsEnabledProperty == null || isTimerCOMPSsEnabledProperty.isEmpty() || isTimerCOMPSsEnabledProperty.equals("null") ? false : Boolean.valueOf(isTimerCOMPSsEnabledProperty);
    }
}

