/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import java.util.concurrent.Semaphore;

public class ExecutorShutdownListener {
    private int operation = 0;
    private int errors = 0;
    private boolean enabled = false;
    private final Semaphore sem;

    public ExecutorShutdownListener(Semaphore sem) {
        this.sem = sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        boolean failed;
        boolean finished;
        ExecutorShutdownListener executorShutdownListener = this;
        synchronized (executorShutdownListener) {
            this.enabled = true;
            finished = this.operation == 0;
            failed = this.errors > 0;
        }
        if (finished) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEnd() {
        boolean enabled;
        boolean failed;
        boolean finished;
        ExecutorShutdownListener executorShutdownListener = this;
        synchronized (executorShutdownListener) {
            --this.operation;
            finished = this.operation == 0;
            failed = this.errors > 0;
            enabled = this.enabled;
        }
        if (finished && enabled) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailure(Exception e) {
        boolean enabled;
        boolean finished;
        ExecutorShutdownListener executorShutdownListener = this;
        synchronized (executorShutdownListener) {
            ++this.errors;
            --this.operation;
            finished = this.operation == 0;
            enabled = this.enabled;
        }
        if (enabled && finished) {
            this.doFailures();
        }
    }

    private void doReady() {
        this.sem.release();
    }

    private void doFailures() {
        this.sem.release();
    }
}

