/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.awt.Point;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Time;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;

public class CommandLine {
    public static final String VERSION = "0.9.8";
    private final Interpreter interpreter;
    private boolean overwrittenOptionsAllowed = false;
    private boolean unmatchedArgumentsAllowed = false;
    private List<String> unmatchedArguments = new ArrayList<String>();
    private CommandLine parent;
    private boolean usageHelpRequested;
    private boolean versionHelpRequested;
    private List<String> versionLines = new ArrayList<String>();

    public CommandLine(Object command) {
        this.interpreter = new Interpreter(command);
    }

    public CommandLine addSubcommand(String name, Object command) {
        CommandLine commandLine = CommandLine.toCommandLine(command);
        commandLine.parent = this;
        this.interpreter.commands.put(name, commandLine);
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new LinkedHashMap<String, CommandLine>(this.interpreter.commands);
    }

    public CommandLine getParent() {
        return this.parent;
    }

    public Object getCommand() {
        return this.interpreter.command;
    }

    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.versionHelpRequested;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.overwrittenOptionsAllowed;
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean newValue) {
        this.overwrittenOptionsAllowed = newValue;
        for (CommandLine command : this.interpreter.commands.values()) {
            command.setOverwrittenOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.unmatchedArgumentsAllowed;
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean newValue) {
        this.unmatchedArgumentsAllowed = newValue;
        for (CommandLine command : this.interpreter.commands.values()) {
            command.setUnmatchedArgumentsAllowed(newValue);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        return this.unmatchedArguments;
    }

    public static <T> T populateCommand(T command, String ... args) {
        CommandLine cli = CommandLine.toCommandLine(command);
        cli.parse(args);
        return command;
    }

    public List<CommandLine> parse(String ... args) {
        return this.interpreter.parse(args);
    }

    public static void usage(Object command, PrintStream out) {
        CommandLine.toCommandLine(command).usage(out);
    }

    public static void usage(Object command, PrintStream out, Help.Ansi ansi) {
        CommandLine.toCommandLine(command).usage(out, ansi);
    }

    public static void usage(Object command, PrintStream out, Help.ColorScheme colorScheme) {
        CommandLine.toCommandLine(command).usage(out, colorScheme);
    }

    public void usage(PrintStream out) {
        this.usage(out, Help.Ansi.AUTO);
    }

    public void usage(PrintStream out, Help.Ansi ansi) {
        this.usage(out, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintStream out, Help.ColorScheme colorScheme) {
        Help help = new Help(this.interpreter.command, colorScheme).addAllSubcommands(this.getSubcommands());
        StringBuilder sb = new StringBuilder().append(help.headerHeading(new Object[0])).append(help.header(new Object[0])).append(help.synopsisHeading(new Object[0])).append(help.synopsis(help.synopsisHeadingLength())).append(help.descriptionHeading(new Object[0])).append(help.description(new Object[0])).append(help.parameterListHeading(new Object[0])).append(help.parameterList()).append(help.optionListHeading(new Object[0])).append(help.optionList()).append(help.commandListHeading(new Object[0])).append(help.commandList()).append(help.footerHeading(new Object[0])).append(help.footer(new Object[0]));
        out.print(sb);
    }

    public void printVersionHelp(PrintStream out) {
        this.printVersionHelp(out, Help.Ansi.AUTO);
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi) {
        for (String versionInfo : this.versionLines) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(versionInfo));
        }
    }

    public static <R extends Runnable> void run(R command, PrintStream out, String ... args) {
        CommandLine.run(command, out, Help.Ansi.AUTO, args);
    }

    public static <R extends Runnable> void run(R command, PrintStream out, Help.Ansi ansi, String ... args) {
        CommandLine cmd = new CommandLine(command);
        try {
            cmd.parse(args);
        }
        catch (Exception ex) {
            out.println(ex.getMessage());
            cmd.usage(out, ansi);
            return;
        }
        command.run();
    }

    public <K> CommandLine registerConverter(Class<K> cls, ITypeConverter<K> converter) {
        this.interpreter.converterRegistry.put(Assert.notNull(cls, "class"), Assert.notNull(converter, "converter"));
        for (CommandLine command : this.interpreter.commands.values()) {
            command.registerConverter(cls, converter);
        }
        return this;
    }

    public String getSeparator() {
        return this.interpreter.separator;
    }

    public void setSeparator(String separator) {
        this.interpreter.separator = Assert.notNull(separator, "separator");
    }

    private static boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static boolean empty(Help.Ansi.Text txt) {
        return txt == null || txt.plain.toString().trim().length() == 0;
    }

    private static String str(String[] arr, int i) {
        return arr == null || arr.length == 0 ? "" : arr[i];
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object obj) {
        return obj instanceof CommandLine ? (CommandLine)obj : new CommandLine(obj);
    }

    private static void init(Class<?> cls, List<Field> requiredFields, Map<String, Field> optionName2Field, Map<Character, Field> singleCharOption2Field, List<Field> positionalParametersFields) {
        Field[] declaredFields;
        for (Field field : declaredFields = cls.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(Option.class)) {
                Option option = field.getAnnotation(Option.class);
                if (option.required()) {
                    requiredFields.add(field);
                }
                for (String name : option.names()) {
                    char flag;
                    Field existing2;
                    Field existing = optionName2Field.put(name, field);
                    if (existing != null && existing != field) {
                        throw DuplicateOptionAnnotationsException.create(name, field, existing);
                    }
                    if (name.length() != 2 || !name.startsWith("-") || (existing2 = singleCharOption2Field.put(Character.valueOf(flag = name.charAt(1)), field)) == null || existing2 == field) continue;
                    throw DuplicateOptionAnnotationsException.create(name, field, existing2);
                }
            }
            if (!field.isAnnotationPresent(Parameters.class)) continue;
            if (field.isAnnotationPresent(Option.class)) {
                throw new ParameterException("A field can be either @Option or @Parameters, but '" + field.getName() + "' is both.");
            }
            positionalParametersFields.add(field);
            Range arity = Range.parameterArity(field);
            if (arity.min <= 0) continue;
            requiredFields.add(field);
        }
    }

    static void validatePositionalParameters(List<Field> positionalParametersFields) {
        int min = 0;
        for (Field field : positionalParametersFields) {
            Range index = Range.parameterIndex(field);
            if (index.min > min) {
                throw new ParameterIndexGapException("Missing field annotated with @Parameter(index=" + min + "). Nearest field '" + field.getName() + "' has index=" + index.min);
            }
            min = (min = Math.max(min, index.max)) == Integer.MAX_VALUE ? min : min + 1;
        }
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Collections.reverse(stack);
        return stack;
    }

    public static class MissingTypeConverterException
    extends ParameterException {
        private static final long serialVersionUID = -6050931703233083760L;

        public MissingTypeConverterException(String msg) {
            super(msg);
        }
    }

    public static class OverwrittenOptionException
    extends ParameterException {
        private static final long serialVersionUID = 1338029208271055776L;

        public OverwrittenOptionException(String msg) {
            super(msg);
        }
    }

    public static class UnmatchedArgumentException
    extends ParameterException {
        private static final long serialVersionUID = -8700426380701452440L;

        public UnmatchedArgumentException(String msg) {
            super(msg);
        }

        public UnmatchedArgumentException(Stack<String> args) {
            this("Unmatched argument" + (args.size() == 1 ? " " : "s ") + CommandLine.reverse(args));
        }
    }

    public static class ParameterIndexGapException
    extends ParameterException {
        private static final long serialVersionUID = -1520981133257618319L;

        public ParameterIndexGapException(String msg) {
            super(msg);
        }
    }

    public static class DuplicateOptionAnnotationsException
    extends ParameterException {
        private static final long serialVersionUID = -3355128012575075641L;

        public DuplicateOptionAnnotationsException(String msg) {
            super(msg);
        }

        private static DuplicateOptionAnnotationsException create(String name, Field field1, Field field2) {
            return new DuplicateOptionAnnotationsException("Option name '" + name + "' is used by both " + field1.getDeclaringClass().getName() + "." + field1.getName() + " and " + field2.getDeclaringClass().getName() + "." + field2.getName());
        }
    }

    public static class MissingParameterException
    extends ParameterException {
        private static final long serialVersionUID = 5075678535706338753L;

        public MissingParameterException(String msg) {
            super(msg);
        }

        private static MissingParameterException create(Collection<Field> missing) {
            if (missing.size() == 1) {
                return new MissingParameterException("Missing required option '" + missing.iterator().next().getName() + "'");
            }
            ArrayList<String> names = new ArrayList<String>(missing.size());
            for (Field field : missing) {
                names.add(field.getName());
            }
            return new MissingParameterException("Missing required options " + ((Object)names).toString());
        }
    }

    public static class ParameterException
    extends RuntimeException {
        private static final long serialVersionUID = 1477112829129763139L;

        public ParameterException(String msg) {
            super(msg);
        }

        public ParameterException(String msg, Exception ex) {
            super(msg, ex);
        }

        private static ParameterException create(Exception ex, String arg, int i, String[] args) {
            String next = args.length < i + 1 ? "" : " " + args[i + 1];
            String msg = ex.getClass().getSimpleName() + ": " + ex.getLocalizedMessage() + " while processing option[" + i + "] '" + arg + next + "': " + ex.toString();
            return new ParameterException(msg, ex);
        }
    }

    private static final class Assert {
        static <T> T notNull(T object, String description) {
            if (object == null) {
                throw new NullPointerException(description);
            }
            return object;
        }

        private Assert() {
        }
    }

    public static class Help {
        protected static final String DEFAULT_COMMAND_NAME = "<main class>";
        private static final int usageHelpWidth = 80;
        private static final int optionsColumnWidth = 29;
        private final Object command;
        private final Map<String, Help> commands = new LinkedHashMap<String, Help>();
        final ColorScheme colorScheme;
        public final List<Field> optionFields;
        public final List<Field> positionalParametersFields;
        public String separator;
        public String commandName = "<main class>";
        public String[] description = new String[0];
        public String[] customSynopsis = new String[0];
        public String[] header = new String[0];
        public String[] footer = new String[0];
        public IParamLabelRenderer parameterLabelRenderer;
        public Boolean abbreviateSynopsis;
        public Boolean sortOptions;
        public Boolean showDefaultValues;
        public Character requiredOptionMarker;
        public String headerHeading;
        public String synopsisHeading;
        public String descriptionHeading;
        public String parameterListHeading;
        public String optionListHeading;
        public String commandListHeading;
        public String footerHeading;

        public Help(Object command) {
            this(command, Ansi.AUTO);
        }

        public Help(Object command, Ansi ansi) {
            this(command, Help.defaultColorScheme(ansi));
        }

        public Help(Object command, ColorScheme colorScheme) {
            this.command = Assert.notNull(command, "command");
            this.colorScheme = Assert.notNull(colorScheme, "colorScheme").applySystemProperties();
            ArrayList<Field> options = new ArrayList<Field>();
            ArrayList<Field> operands = new ArrayList<Field>();
            for (Class<?> cls = command.getClass(); cls != null; cls = cls.getSuperclass()) {
                for (Field field : cls.getDeclaredFields()) {
                    Option option;
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Option.class) && !(option = field.getAnnotation(Option.class)).hidden()) {
                        options.add(field);
                    }
                    if (!field.isAnnotationPresent(Parameters.class)) continue;
                    operands.add(field);
                }
                if (!cls.isAnnotationPresent(Command.class)) continue;
                Command cmd = cls.getAnnotation(Command.class);
                if (DEFAULT_COMMAND_NAME.equals(this.commandName)) {
                    this.commandName = cmd.name();
                }
                this.separator = this.separator == null ? cmd.separator() : this.separator;
                this.abbreviateSynopsis = this.abbreviateSynopsis == null ? cmd.abbreviateSynopsis() : this.abbreviateSynopsis.booleanValue();
                this.sortOptions = this.sortOptions == null ? cmd.sortOptions() : this.sortOptions.booleanValue();
                this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? cmd.requiredOptionMarker() : this.requiredOptionMarker.charValue());
                this.showDefaultValues = this.showDefaultValues == null ? cmd.showDefaultValues() : this.showDefaultValues.booleanValue();
                this.customSynopsis = CommandLine.empty(this.customSynopsis) ? cmd.customSynopsis() : this.customSynopsis;
                this.description = CommandLine.empty(this.description) ? cmd.description() : this.description;
                this.header = CommandLine.empty(this.header) ? cmd.header() : this.header;
                this.footer = CommandLine.empty(this.footer) ? cmd.footer() : this.footer;
                this.headerHeading = CommandLine.empty(this.headerHeading) ? cmd.headerHeading() : this.headerHeading;
                this.synopsisHeading = CommandLine.empty(this.synopsisHeading) || "Usage: ".equals(this.synopsisHeading) ? cmd.synopsisHeading() : this.synopsisHeading;
                this.descriptionHeading = CommandLine.empty(this.descriptionHeading) ? cmd.descriptionHeading() : this.descriptionHeading;
                this.parameterListHeading = CommandLine.empty(this.parameterListHeading) ? cmd.parameterListHeading() : this.parameterListHeading;
                this.optionListHeading = CommandLine.empty(this.optionListHeading) ? cmd.optionListHeading() : this.optionListHeading;
                this.commandListHeading = CommandLine.empty(this.commandListHeading) || "Commands:%n".equals(this.commandListHeading) ? cmd.commandListHeading() : this.commandListHeading;
                this.footerHeading = CommandLine.empty(this.footerHeading) ? cmd.footerHeading() : this.footerHeading;
            }
            this.sortOptions = this.sortOptions == null ? true : this.sortOptions;
            this.abbreviateSynopsis = this.abbreviateSynopsis == null ? false : this.abbreviateSynopsis;
            this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? (char)' ' : this.requiredOptionMarker.charValue());
            this.showDefaultValues = this.showDefaultValues == null ? false : this.showDefaultValues;
            this.synopsisHeading = this.synopsisHeading == null ? "Usage: " : this.synopsisHeading;
            this.commandListHeading = this.commandListHeading == null ? "Commands:%n" : this.commandListHeading;
            this.separator = this.separator == null ? "=" : this.separator;
            this.parameterLabelRenderer = new DefaultParamLabelRenderer(this.separator);
            Collections.sort(operands, new PositionalParametersSorter());
            this.positionalParametersFields = Collections.unmodifiableList(operands);
            this.optionFields = Collections.unmodifiableList(options);
        }

        public Help addAllSubcommands(Map<String, CommandLine> commands) {
            if (commands != null) {
                for (Map.Entry<String, CommandLine> entry : commands.entrySet()) {
                    this.addSubcommand(entry.getKey(), entry.getValue().getCommand());
                }
            }
            return this;
        }

        public Help addSubcommand(String commandName, Object command) {
            this.commands.put(commandName, new Help(command));
            return this;
        }

        public String synopsis() {
            return this.synopsis(0);
        }

        public String synopsis(int synopsisHeadingLength) {
            if (!CommandLine.empty(this.customSynopsis)) {
                return this.customSynopsis(new Object[0]);
            }
            return this.abbreviateSynopsis != false ? this.abbreviatedSynopsis() : this.detailedSynopsis(synopsisHeadingLength, Help.createShortOptionArityAndNameComparator(), true);
        }

        public String abbreviatedSynopsis() {
            StringBuilder sb = new StringBuilder();
            if (!this.optionFields.isEmpty()) {
                sb.append(" [OPTIONS]");
            }
            for (Field positionalParam : this.positionalParametersFields) {
                if (positionalParam.getAnnotation(Parameters.class).hidden()) continue;
                sb.append(' ').append(this.parameterLabelRenderer.renderParameterLabel(positionalParam, this.ansi(), this.colorScheme.parameterStyles));
            }
            return this.colorScheme.commandText(this.commandName).toString() + sb.toString() + System.getProperty("line.separator");
        }

        public String detailedSynopsis(Comparator<Field> optionSort, boolean clusterBooleanOptions) {
            return this.detailedSynopsis(0, optionSort, clusterBooleanOptions);
        }

        public String detailedSynopsis(int synopsisHeadingLength, Comparator<Field> optionSort, boolean clusterBooleanOptions) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text optionText = ansi.new Ansi.Text(0);
            ArrayList<Field> fields = new ArrayList<Field>(this.optionFields);
            if (optionSort != null) {
                Collections.sort(fields, optionSort);
            }
            if (clusterBooleanOptions) {
                ArrayList<Field> booleanOptions = new ArrayList<Field>();
                StringBuilder clusteredRequired = new StringBuilder("-");
                StringBuilder clusteredOptional = new StringBuilder("-");
                for (Field field : fields) {
                    Option option;
                    String shortestName;
                    if (field.getType() != Boolean.TYPE && field.getType() != Boolean.class || (shortestName = ShortestFirst.sort((option = field.getAnnotation(Option.class)).names())[0]).length() != 2 || !shortestName.startsWith("-")) continue;
                    booleanOptions.add(field);
                    if (option.required()) {
                        clusteredRequired.append(shortestName.substring(1));
                        continue;
                    }
                    clusteredOptional.append(shortestName.substring(1));
                }
                fields.removeAll(booleanOptions);
                if (clusteredRequired.length() > 1) {
                    optionText = optionText.append(" ").append(this.colorScheme.optionText(clusteredRequired.toString()));
                }
                if (clusteredOptional.length() > 1) {
                    optionText = optionText.append(" [").append(this.colorScheme.optionText(clusteredOptional.toString())).append("]");
                }
            }
            for (Field field : fields) {
                Option option = field.getAnnotation(Option.class);
                if (option.hidden()) continue;
                optionText = optionText.append(option.required() ? " " : " [");
                String optionNames = ShortestFirst.sort(option.names())[0];
                optionText = optionText.append(this.colorScheme.optionText(optionNames));
                Ansi.Text optionParamText = this.parameterLabelRenderer.renderParameterLabel(field, this.colorScheme.ansi(), this.colorScheme.optionParamStyles);
                optionText = optionText.append(optionParamText);
                if (option.required()) continue;
                optionText = optionText.append("]");
            }
            for (Field positionalParam : this.positionalParametersFields) {
                if (positionalParam.getAnnotation(Parameters.class).hidden()) continue;
                optionText = optionText.append(" ");
                Ansi.Text label = this.parameterLabelRenderer.renderParameterLabel(positionalParam, this.colorScheme.ansi(), this.colorScheme.parameterStyles);
                optionText = optionText.append(label);
            }
            int firstColumnLength = this.commandName.length() + synopsisHeadingLength;
            TextTable textTable = new TextTable(this.ansi(), firstColumnLength, 80 - firstColumnLength);
            textTable.indentWrappedLines = 1;
            Ansi ansi2 = Ansi.OFF;
            ((Object)((Object)ansi2)).getClass();
            Ansi.Text PADDING = ansi2.new Ansi.Text(Help.spaces(synopsisHeadingLength));
            textTable.addRowValues(PADDING.append(this.colorScheme.commandText(this.commandName)), optionText);
            return textTable.toString().substring(synopsisHeadingLength);
        }

        public int synopsisHeadingLength() {
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            String[] lines = ansi.new Ansi.Text(this.synopsisHeading).toString().split("\\r?\\n|\\r|%n", -1);
            return lines[lines.length - 1].length();
        }

        public String optionList() {
            Comparator<Field> sortOrder = this.sortOptions == null || this.sortOptions != false ? Help.createShortOptionNameComparator() : null;
            return this.optionList(this.createDefaultLayout(), sortOrder, this.createDefaultParamLabelRenderer());
        }

        public String optionList(Layout layout, Comparator<Field> optionSort, IParamLabelRenderer valueLabelRenderer) {
            ArrayList<Field> fields = new ArrayList<Field>(this.optionFields);
            if (optionSort != null) {
                Collections.sort(fields, optionSort);
            }
            layout.addOptions(fields, valueLabelRenderer);
            return layout.toString();
        }

        public String parameterList() {
            return this.parameterList(this.createDefaultLayout(), Help.createMinimalParamLabelRenderer());
        }

        public String parameterList(Layout layout, IParamLabelRenderer paramLabelRenderer) {
            layout.addPositionalParameters(this.positionalParametersFields, paramLabelRenderer);
            return layout.toString();
        }

        public static StringBuilder join(Ansi ansi, String[] values, StringBuilder sb, Object ... params) {
            if (values != null) {
                TextTable table = new TextTable(ansi, 80);
                table.indentWrappedLines = 0;
                for (String summaryLine : values) {
                    Ansi.Text[] textArray = new Ansi.Text[1];
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    textArray[0] = ansi2.new Ansi.Text(String.format(summaryLine, params));
                    table.addRowValues(textArray);
                }
                table.toString(sb);
            }
            return sb;
        }

        public String customSynopsis(Object ... params) {
            return Help.join(this.ansi(), this.customSynopsis, new StringBuilder(), params).toString();
        }

        public String description(Object ... params) {
            return Help.join(this.ansi(), this.description, new StringBuilder(), params).toString();
        }

        public String header(Object ... params) {
            return Help.join(this.ansi(), this.header, new StringBuilder(), params).toString();
        }

        public String footer(Object ... params) {
            return Help.join(this.ansi(), this.footer, new StringBuilder(), params).toString();
        }

        public String headerHeading(Object ... params) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            return ansi.new Ansi.Text(this.format(this.headerHeading, params)).toString();
        }

        public String synopsisHeading(Object ... params) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            return ansi.new Ansi.Text(this.format(this.synopsisHeading, params)).toString();
        }

        public String descriptionHeading(Object ... params) {
            String string;
            if (CommandLine.empty(this.descriptionHeading)) {
                string = "";
            } else {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                string = ansi.new Ansi.Text(this.format(this.descriptionHeading, params)).toString();
            }
            return string;
        }

        public String parameterListHeading(Object ... params) {
            String string;
            if (this.positionalParametersFields.isEmpty()) {
                string = "";
            } else {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                string = ansi.new Ansi.Text(this.format(this.parameterListHeading, params)).toString();
            }
            return string;
        }

        public String optionListHeading(Object ... params) {
            String string;
            if (this.optionFields.isEmpty()) {
                string = "";
            } else {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                string = ansi.new Ansi.Text(this.format(this.optionListHeading, params)).toString();
            }
            return string;
        }

        public String commandListHeading(Object ... params) {
            String string;
            if (this.commands.isEmpty()) {
                string = "";
            } else {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                string = ansi.new Ansi.Text(this.format(this.commandListHeading, params)).toString();
            }
            return string;
        }

        public String footerHeading(Object ... params) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            return ansi.new Ansi.Text(this.format(this.footerHeading, params)).toString();
        }

        private String format(String formatString, Object[] params) {
            return formatString == null ? "" : String.format(formatString, params);
        }

        public String commandList() {
            if (this.commands.isEmpty()) {
                return "";
            }
            int commandLength = Help.maxLength(this.commands.keySet());
            TextTable textTable = new TextTable(this.ansi(), new Column(commandLength + 2, 2, Column.Overflow.SPAN), new Column(80 - (commandLength + 2), 2, Column.Overflow.WRAP));
            for (Map.Entry<String, Help> entry : this.commands.entrySet()) {
                Help command = entry.getValue();
                String header = command.header != null && command.header.length > 0 ? command.header[0] : (command.description != null && command.description.length > 0 ? command.description[0] : "");
                Ansi.Text[] textArray = new Ansi.Text[2];
                textArray[0] = this.colorScheme.commandText(entry.getKey());
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[1] = ansi.new Ansi.Text(header);
                textTable.addRowValues(textArray);
            }
            return textTable.toString();
        }

        private static int maxLength(Collection<String> any) {
            ArrayList<String> strings = new ArrayList<String>(any);
            Collections.sort(strings, Collections.reverseOrder(Help.shortestFirst()));
            return ((String)strings.get(0)).length();
        }

        private static String join(String[] names, int offset, int length, String separator) {
            if (names == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (int i = offset; i < offset + length; ++i) {
                result.append(i > offset ? separator : "").append(names[i]);
            }
            return result.toString();
        }

        private static String spaces(int length) {
            char[] buff = new char[length];
            Arrays.fill(buff, ' ');
            return new String(buff);
        }

        public Layout createDefaultLayout() {
            return new Layout(this.colorScheme, new TextTable(this.colorScheme.ansi()), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
        }

        public IOptionRenderer createDefaultOptionRenderer() {
            DefaultOptionRenderer result = new DefaultOptionRenderer();
            result.requiredMarker = String.valueOf(this.requiredOptionMarker);
            if (this.showDefaultValues != null && this.showDefaultValues.booleanValue()) {
                result.command = this.command;
            }
            return result;
        }

        public static IOptionRenderer createMinimalOptionRenderer() {
            return new MinimalOptionRenderer();
        }

        public IParameterRenderer createDefaultParameterRenderer() {
            DefaultParameterRenderer result = new DefaultParameterRenderer();
            result.requiredMarker = String.valueOf(this.requiredOptionMarker);
            return result;
        }

        public static IParameterRenderer createMinimalParameterRenderer() {
            return new MinimalParameterRenderer();
        }

        public static IParamLabelRenderer createMinimalParamLabelRenderer() {
            return new IParamLabelRenderer(){

                @Override
                public Ansi.Text renderParameterLabel(Field field, Ansi ansi, List<Ansi.IStyle> styles) {
                    String paramLabel = null;
                    Parameters parameters = field.getAnnotation(Parameters.class);
                    paramLabel = parameters != null ? parameters.paramLabel() : (field.isAnnotationPresent(Option.class) ? field.getAnnotation(Option.class).paramLabel() : null);
                    String text = paramLabel == null || paramLabel.length() == 0 ? field.getName() : paramLabel;
                    return ansi.apply(text, styles);
                }

                @Override
                public String separator() {
                    return "";
                }
            };
        }

        public IParamLabelRenderer createDefaultParamLabelRenderer() {
            return new DefaultParamLabelRenderer(this.separator);
        }

        public static Comparator<Field> createShortOptionNameComparator() {
            return new SortByShortestOptionNameAlphabetically();
        }

        public static Comparator<Field> createShortOptionArityAndNameComparator() {
            return new SortByOptionArityAndNameAlphabetically();
        }

        public static Comparator<String> shortestFirst() {
            return new ShortestFirst();
        }

        public Ansi ansi() {
            return this.colorScheme.ansi;
        }

        public static ColorScheme defaultColorScheme(Ansi ansi) {
            return new ColorScheme(ansi).commands(Ansi.Style.bold).options(Ansi.Style.fg_yellow).parameters(Ansi.Style.fg_yellow).optionParams(Ansi.Style.italic);
        }

        public static enum Ansi {
            AUTO,
            ON,
            OFF;

            static Text EMPTY_TEXT;
            static final boolean isWindows;
            static final boolean isXterm;
            static final boolean ISATTY;

            static final boolean calcTTY() {
                if (isWindows && isXterm) {
                    return true;
                }
                try {
                    return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
                }
                catch (Throwable reflectionFailed) {
                    return true;
                }
            }

            private static boolean ansiPossible() {
                return ISATTY && (!isWindows || isXterm);
            }

            public boolean enabled() {
                if (this == ON) {
                    return true;
                }
                if (this == OFF) {
                    return false;
                }
                return System.getProperty("picocli.ansi") == null ? Ansi.ansiPossible() : Boolean.getBoolean("picocli.ansi");
            }

            public Text apply(String plainText, List<IStyle> styles) {
                if (plainText.length() == 0) {
                    return new Text(0);
                }
                Text result = new Text(plainText.length());
                Object[] all = styles.toArray(new IStyle[styles.size()]);
                result.indexToStyle.put(result.plain.length(), Style.on((IStyle[])all));
                result.plain.append(plainText);
                result.length = result.plain.length();
                Ansi.reverse(all);
                result.indexToStyle.put(result.plain.length(), Style.off((IStyle[])all) + Style.reset.off());
                return result;
            }

            private static void reverse(Object[] all) {
                for (int i = 0; i < all.length / 2; ++i) {
                    Object temp = all[i];
                    all[i] = all[all.length - i - 1];
                    all[all.length - i - 1] = temp;
                }
            }

            static {
                Ansi ansi = OFF;
                ((Object)((Object)ansi)).getClass();
                EMPTY_TEXT = ansi.new Text(0);
                isWindows = System.getProperty("os.name").startsWith("Windows");
                isXterm = System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
                ISATTY = Ansi.calcTTY();
            }

            public class Text
            implements Cloneable {
                private final int maxLength;
                private int from;
                private int length;
                private StringBuilder plain = new StringBuilder();
                private SortedMap<Integer, String> indexToStyle = new TreeMap<Integer, String>();

                public Text(int maxLength) {
                    this.maxLength = maxLength;
                }

                public Text(String input) {
                    this.maxLength = -1;
                    this.plain.setLength(0);
                    int i = 0;
                    while (true) {
                        int j;
                        if ((j = input.indexOf("@|", i)) == -1) {
                            if (i == 0) {
                                this.plain.append(input);
                                this.length = this.plain.length();
                                return;
                            }
                            this.plain.append(input.substring(i, input.length()));
                            this.length = this.plain.length();
                            return;
                        }
                        this.plain.append(input.substring(i, j));
                        int k = input.indexOf("|@", j);
                        if (k == -1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        String spec = input.substring(j += 2, k);
                        String[] items = spec.split(" ", 2);
                        if (items.length == 1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        Object[] styles = Style.parse(items[0]);
                        this.putStyle(this.plain.length(), Style.on((IStyle[])styles));
                        this.plain.append(items[1]);
                        Ansi.reverse(styles);
                        this.putStyle(this.plain.length(), Style.off((IStyle[])styles));
                        this.putStyle(this.plain.length(), Style.reset.off());
                        i = k + 2;
                    }
                }

                private void putStyle(int index, String style) {
                    String existing = this.indexToStyle.put(index, style);
                    if (existing != null) {
                        this.indexToStyle.put(index, existing + style);
                    }
                }

                public Object clone() {
                    try {
                        return super.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new IllegalStateException(e);
                    }
                }

                public Text substring(int start) {
                    return this.substring(start, this.length);
                }

                public Text substring(int start, int end) {
                    Text result = (Text)this.clone();
                    result.from = this.from + start;
                    result.length = end - start;
                    return result;
                }

                public Text append(String string) {
                    return this.append(new Text(string));
                }

                public Text append(Text other) {
                    Text result = (Text)this.clone();
                    result.plain = new StringBuilder(this.plain.toString().substring(this.from, this.from + this.length));
                    result.from = 0;
                    result.indexToStyle = new TreeMap<Integer, String>();
                    for (Integer index : this.indexToStyle.keySet()) {
                        result.indexToStyle.put(index - this.from, (String)this.indexToStyle.get(index));
                    }
                    result.plain.append(other.plain.toString().substring(other.from, other.from + other.length));
                    for (Integer otherIndex : other.indexToStyle.keySet()) {
                        int index = result.length + otherIndex - other.from;
                        String replaced = (String)result.indexToStyle.put(index, (String)other.indexToStyle.get(otherIndex));
                        if (replaced == null) continue;
                        result.indexToStyle.put(index, replaced + (String)other.indexToStyle.get(otherIndex));
                    }
                    result.length = result.plain.length();
                    return result;
                }

                public void getStyledChars(int from, int length, Text destination, int offset) {
                    if (destination.length < offset) {
                        for (int i = destination.length; i < offset; ++i) {
                            destination.plain.append(' ');
                        }
                        destination.length = offset;
                    }
                    for (Integer index : this.indexToStyle.keySet()) {
                        destination.indexToStyle.put(index - from + destination.length, (String)this.indexToStyle.get(index));
                    }
                    destination.plain.append(this.plain.toString().substring(from, from + length));
                    destination.length = destination.plain.length();
                }

                public String plainString() {
                    return this.plain.toString().substring(this.from, this.from + this.length);
                }

                public boolean equals(Object obj) {
                    return this.toString().equals(String.valueOf(obj));
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                public String toString() {
                    if (!Ansi.this.enabled()) {
                        return this.plain.toString().substring(this.from, this.from + this.length);
                    }
                    if (this.length == 0) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder(this.plain.length() + 20 * this.indexToStyle.size());
                    Integer startStyle = null;
                    Integer endStyle = -1;
                    for (Integer index : this.indexToStyle.keySet()) {
                        if (index <= this.from) {
                            startStyle = startStyle == null ? index : null;
                            Integer n = endStyle = endStyle == null ? index : null;
                        }
                        if (index < this.from) continue;
                        break;
                    }
                    if (startStyle != null) {
                        sb.append((String)this.indexToStyle.get(startStyle));
                        endStyle = startStyle;
                    }
                    int end = Math.min(this.from + this.length, this.plain.length());
                    for (int i = this.from; i < end; ++i) {
                        String style = (String)this.indexToStyle.get(i);
                        if (style != null) {
                            if (endStyle != null && endStyle != i) {
                                sb.append(style);
                                startStyle = startStyle == null ? Integer.valueOf(i) : null;
                            }
                            endStyle = i;
                        }
                        sb.append(this.plain.charAt(i));
                    }
                    if (startStyle != null) {
                        SortedMap<Integer, String> tailMap = this.indexToStyle.tailMap(startStyle + 1);
                        if (!tailMap.isEmpty()) {
                            sb.append((String)this.indexToStyle.get(tailMap.firstKey()));
                        } else {
                            sb.append(Style.reset.off());
                        }
                    }
                    return sb.toString();
                }
            }

            static class Palette256Color
            implements IStyle {
                private final int fgbg;
                private final int color;

                Palette256Color(boolean foreground, String color) {
                    this.fgbg = foreground ? 38 : 48;
                    String[] rgb = color.split(";");
                    this.color = rgb.length == 3 ? 16 + 36 * Integer.decode(rgb[0]) + 6 * Integer.decode(rgb[1]) + Integer.decode(rgb[2]) : Integer.decode(color);
                }

                @Override
                public String on() {
                    return String.format("\u001b[%d;5;%dm", this.fgbg, this.color);
                }

                @Override
                public String off() {
                    return "\u001b[" + (this.fgbg + 1) + "m";
                }
            }

            public static enum Style implements IStyle
            {
                reset(0, 0),
                bold(1, 21),
                faint(2, 22),
                italic(3, 23),
                underline(4, 24),
                blink(5, 25),
                reverse(7, 27),
                fg_black(30, 39),
                fg_red(31, 39),
                fg_green(32, 39),
                fg_yellow(33, 39),
                fg_blue(34, 39),
                fg_magenta(35, 39),
                fg_cyan(36, 39),
                fg_white(37, 39),
                bg_black(40, 49),
                bg_red(41, 49),
                bg_green(42, 49),
                bg_yellow(43, 49),
                bg_blue(44, 49),
                bg_magenta(45, 49),
                bg_cyan(46, 49),
                bg_white(47, 49);

                private final int startCode;
                private final int endCode;

                private Style(int startCode, int endCode) {
                    this.startCode = startCode;
                    this.endCode = endCode;
                }

                @Override
                public String on() {
                    return "\u001b[" + this.startCode + "m";
                }

                @Override
                public String off() {
                    return "\u001b[" + this.endCode + "m";
                }

                public static String on(IStyle ... styles) {
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : styles) {
                        result.append(style.on());
                    }
                    return result.toString();
                }

                public static String off(IStyle ... styles) {
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : styles) {
                        result.append(style.off());
                    }
                    return result.toString();
                }

                public static IStyle fg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("fg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(true, str);
                        }
                    }
                }

                public static IStyle bg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("bg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(false, str);
                        }
                    }
                }

                public static IStyle[] parse(String commaSeparatedCodes) {
                    String[] codes = commaSeparatedCodes.split(",");
                    IStyle[] styles = new IStyle[codes.length];
                    for (int i = 0; i < codes.length; ++i) {
                        int end;
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("fg(")) {
                            end = codes[i].indexOf(41);
                            styles[i] = Style.fg(codes[i].substring(3, end < 0 ? codes[i].length() : end));
                            continue;
                        }
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("bg(")) {
                            end = codes[i].indexOf(41);
                            styles[i] = Style.bg(codes[i].substring(3, end < 0 ? codes[i].length() : end));
                            continue;
                        }
                        styles[i] = Style.fg(codes[i]);
                    }
                    return styles;
                }
            }

            public static interface IStyle {
                public static final String CSI = "\u001b[";

                public String on();

                public String off();
            }
        }

        public static class ColorScheme {
            public final List<Ansi.IStyle> commandStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> parameterStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionParamStyles = new ArrayList<Ansi.IStyle>();
            private final Ansi ansi;

            public ColorScheme() {
                this(Ansi.AUTO);
            }

            public ColorScheme(Ansi ansi) {
                this.ansi = Assert.notNull(ansi, "ansi");
            }

            public ColorScheme commands(Ansi.IStyle ... styles) {
                return this.addAll(this.commandStyles, styles);
            }

            public ColorScheme options(Ansi.IStyle ... styles) {
                return this.addAll(this.optionStyles, styles);
            }

            public ColorScheme parameters(Ansi.IStyle ... styles) {
                return this.addAll(this.parameterStyles, styles);
            }

            public ColorScheme optionParams(Ansi.IStyle ... styles) {
                return this.addAll(this.optionParamStyles, styles);
            }

            public Ansi.Text commandText(String command) {
                return this.ansi().apply(command, this.commandStyles);
            }

            public Ansi.Text optionText(String option) {
                return this.ansi().apply(option, this.optionStyles);
            }

            public Ansi.Text parameterText(String parameter) {
                return this.ansi().apply(parameter, this.parameterStyles);
            }

            public Ansi.Text optionParamText(String optionParam) {
                return this.ansi().apply(optionParam, this.optionParamStyles);
            }

            public ColorScheme applySystemProperties() {
                this.replace(this.commandStyles, System.getProperty("picocli.color.commands"));
                this.replace(this.optionStyles, System.getProperty("picocli.color.options"));
                this.replace(this.parameterStyles, System.getProperty("picocli.color.parameters"));
                this.replace(this.optionParamStyles, System.getProperty("picocli.color.optionParams"));
                return this;
            }

            private void replace(List<Ansi.IStyle> styles, String property) {
                if (property != null) {
                    styles.clear();
                    this.addAll(styles, Ansi.Style.parse(property));
                }
            }

            private ColorScheme addAll(List<Ansi.IStyle> styles, Ansi.IStyle ... add) {
                styles.addAll(Arrays.asList(add));
                return this;
            }

            public Ansi ansi() {
                return this.ansi;
            }
        }

        public static class Column {
            public final int width;
            public final int indent;
            public final Overflow overflow;

            public Column(int width, int indent, Overflow overflow) {
                this.width = width;
                this.indent = indent;
                this.overflow = Assert.notNull(overflow, "overflow");
            }

            public static enum Overflow {
                TRUNCATE,
                SPAN,
                WRAP;

            }
        }

        public static class TextTable {
            public final Column[] columns;
            protected final List<Ansi.Text> columnValues = new ArrayList<Ansi.Text>();
            public int indentWrappedLines = 2;
            private final Ansi ansi;

            public TextTable(Ansi ansi) {
                this(ansi, new Column(2, 0, Column.Overflow.TRUNCATE), new Column(2, 0, Column.Overflow.TRUNCATE), new Column(1, 0, Column.Overflow.TRUNCATE), new Column(24, 1, Column.Overflow.SPAN), new Column(51, 1, Column.Overflow.WRAP));
            }

            public TextTable(Ansi ansi, int ... columnWidths) {
                this.ansi = Assert.notNull(ansi, "ansi");
                this.columns = new Column[columnWidths.length];
                for (int i = 0; i < columnWidths.length; ++i) {
                    this.columns[i] = new Column(columnWidths[i], 0, i == columnWidths.length - 1 ? Column.Overflow.SPAN : Column.Overflow.WRAP);
                }
            }

            public TextTable(Ansi ansi, Column ... columns) {
                this.ansi = Assert.notNull(ansi, "ansi");
                this.columns = Assert.notNull(columns, "columns");
                if (columns.length == 0) {
                    throw new IllegalArgumentException("At least one column is required");
                }
            }

            public Ansi.Text cellAt(int row, int col) {
                return this.columnValues.get(col + row * this.columns.length);
            }

            public int rowCount() {
                return this.columnValues.size() / this.columns.length;
            }

            public void addEmptyRow() {
                for (int i = 0; i < this.columns.length; ++i) {
                    Ansi ansi = this.ansi;
                    ((Object)((Object)ansi)).getClass();
                    this.columnValues.add(ansi.new Ansi.Text(this.columns[i].width));
                }
            }

            public void addRowValues(String ... values) {
                Ansi.Text[] array = new Ansi.Text[values.length];
                for (int i = 0; i < array.length; ++i) {
                    Ansi.Text text;
                    if (values[i] == null) {
                        text = Ansi.EMPTY_TEXT;
                    } else {
                        Ansi ansi = this.ansi;
                        ((Object)((Object)ansi)).getClass();
                        text = ansi.new Ansi.Text(values[i]);
                    }
                    array[i] = text;
                }
                this.addRowValues(array);
            }

            public void addRowValues(Ansi.Text ... values) {
                if (values.length > this.columns.length) {
                    throw new IllegalArgumentException(values.length + " values don't fit in " + this.columns.length + " columns");
                }
                this.addEmptyRow();
                for (int col = 0; col < values.length; ++col) {
                    int row = this.rowCount() - 1;
                    Point cell = this.putValue(row, col, values[col]);
                    if (cell.y == row && cell.x == col || col == values.length - 1) continue;
                    this.addEmptyRow();
                }
            }

            public Point putValue(int row, int col, Ansi.Text value) {
                if (row > this.rowCount() - 1) {
                    throw new IllegalArgumentException("Cannot write to row " + row + ": rowCount=" + this.rowCount());
                }
                if (value == null || value.plain.length() == 0) {
                    return new Point(col, row);
                }
                Column column = this.columns[col];
                int indent = column.indent;
                switch (column.overflow) {
                    case TRUNCATE: {
                        TextTable.copy(value, this.cellAt(row, col), indent);
                        return new Point(col, row);
                    }
                    case SPAN: {
                        int startColumn = col;
                        do {
                            boolean lastColumn = col == this.columns.length - 1;
                            int charsWritten = lastColumn ? this.copy(BreakIterator.getLineInstance(), value, this.cellAt(row, col), indent) : TextTable.copy(value, this.cellAt(row, col), indent);
                            value = value.substring(charsWritten);
                            indent = 0;
                            if (value.length > 0) {
                                ++col;
                            }
                            if (value.length <= 0 || col < this.columns.length) continue;
                            this.addEmptyRow();
                            ++row;
                            col = startColumn;
                            indent = column.indent + this.indentWrappedLines;
                        } while (value.length > 0);
                        return new Point(col, row);
                    }
                    case WRAP: {
                        BreakIterator lineBreakIterator = BreakIterator.getLineInstance();
                        do {
                            int charsWritten = this.copy(lineBreakIterator, value, this.cellAt(row, col), indent);
                            value = value.substring(charsWritten);
                            indent = column.indent + this.indentWrappedLines;
                            if (value.length <= 0) continue;
                            ++row;
                            this.addEmptyRow();
                        } while (value.length > 0);
                        return new Point(col, row);
                    }
                }
                throw new IllegalStateException(column.overflow.toString());
            }

            private static int length(Ansi.Text str) {
                return str.length;
            }

            private char[] spaces(int length) {
                char[] result = new char[length];
                Arrays.fill(result, ' ');
                return result;
            }

            private int copy(BreakIterator line, Ansi.Text text, Ansi.Text columnValue, int offset) {
                line.setText(text.plainString().replace("-", "\u00ff"));
                int done = 0;
                int start = line.first();
                int end = line.next();
                while (end != -1) {
                    Ansi.Text word = text.substring(start, end);
                    if (columnValue.maxLength < offset + done + TextTable.length(word)) break;
                    done += TextTable.copy(word, columnValue, offset + done);
                    start = end;
                    end = line.next();
                }
                if (done == 0 && TextTable.length(text) > columnValue.maxLength) {
                    done = TextTable.copy(text, columnValue, offset);
                }
                return done;
            }

            private static int copy(Ansi.Text value, Ansi.Text destination, int offset) {
                int length = Math.min(value.length, destination.maxLength - offset);
                value.getStyledChars(value.from, length, destination, offset);
                return length;
            }

            public StringBuilder toString(StringBuilder text) {
                int columnCount = this.columns.length;
                StringBuilder row = new StringBuilder(80);
                for (int i = 0; i < this.columnValues.size(); ++i) {
                    int lastChar;
                    Ansi.Text column = this.columnValues.get(i);
                    row.append(column.toString());
                    row.append(new String(this.spaces(this.columns[i % columnCount].width - column.length)));
                    if (i % columnCount != columnCount - 1) continue;
                    for (lastChar = row.length() - 1; lastChar >= 0 && row.charAt(lastChar) == ' '; --lastChar) {
                    }
                    row.setLength(lastChar + 1);
                    text.append(row.toString()).append(System.getProperty("line.separator"));
                    row.setLength(0);
                }
                return text;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }
        }

        static class SortByOptionArityAndNameAlphabetically
        extends SortByShortestOptionNameAlphabetically {
            SortByOptionArityAndNameAlphabetically() {
            }

            @Override
            public int compare(Field f1, Field f2) {
                Option o1 = f1.getAnnotation(Option.class);
                Option o2 = f2.getAnnotation(Option.class);
                Range arity1 = Range.optionArity(f1);
                Range arity2 = Range.optionArity(f2);
                int result = arity1.max - arity2.max;
                if (result == 0) {
                    result = arity1.min - arity2.min;
                }
                return result == 0 ? super.compare(f1, f2) : result;
            }
        }

        static class SortByShortestOptionNameAlphabetically
        implements Comparator<Field> {
            SortByShortestOptionNameAlphabetically() {
            }

            @Override
            public int compare(Field f1, Field f2) {
                Option o1 = f1.getAnnotation(Option.class);
                Option o2 = f2.getAnnotation(Option.class);
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String[] names1 = ShortestFirst.sort(o1.names());
                String[] names2 = ShortestFirst.sort(o2.names());
                int result = names1[0].toUpperCase().compareTo(names2[0].toUpperCase());
                int n = result = result == 0 ? -names1[0].compareTo(names2[0]) : result;
                return o1.help() == o2.help() ? result : (o2.help() ? -1 : 1);
            }
        }

        static class ShortestFirst
        implements Comparator<String> {
            ShortestFirst() {
            }

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }

            public static String[] sort(String[] names) {
                Arrays.sort(names, new ShortestFirst());
                return names;
            }
        }

        public static class Layout {
            protected final ColorScheme colorScheme;
            protected final TextTable table;
            protected IOptionRenderer optionRenderer;
            protected IParameterRenderer parameterRenderer;

            public Layout(ColorScheme colorScheme) {
                this(colorScheme, new TextTable(colorScheme.ansi()));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable) {
                this(colorScheme, textTable, new DefaultOptionRenderer(), new DefaultParameterRenderer());
            }

            public Layout(ColorScheme colorScheme, TextTable textTable, IOptionRenderer optionRenderer, IParameterRenderer parameterRenderer) {
                this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
                this.table = Assert.notNull(textTable, "textTable");
                this.optionRenderer = Assert.notNull(optionRenderer, "optionRenderer");
                this.parameterRenderer = Assert.notNull(parameterRenderer, "parameterRenderer");
            }

            public void layout(Field field, Ansi.Text[][] cellValues) {
                for (Ansi.Text[] oneRow : cellValues) {
                    this.table.addRowValues(oneRow);
                }
            }

            public void addOptions(List<Field> fields, IParamLabelRenderer paramLabelRenderer) {
                for (Field field : fields) {
                    Option option = field.getAnnotation(Option.class);
                    if (option.hidden()) continue;
                    this.addOption(field, paramLabelRenderer);
                }
            }

            public void addOption(Field field, IParamLabelRenderer paramLabelRenderer) {
                Option option = field.getAnnotation(Option.class);
                Ansi.Text[][] values = this.optionRenderer.render(option, field, paramLabelRenderer, this.colorScheme);
                this.layout(field, values);
            }

            public void addPositionalParameters(List<Field> fields, IParamLabelRenderer paramLabelRenderer) {
                for (Field field : fields) {
                    Parameters parameters = field.getAnnotation(Parameters.class);
                    if (parameters.hidden()) continue;
                    this.addPositionalParameter(field, paramLabelRenderer);
                }
            }

            public void addPositionalParameter(Field field, IParamLabelRenderer paramLabelRenderer) {
                Parameters option = field.getAnnotation(Parameters.class);
                Ansi.Text[][] values = this.parameterRenderer.render(option, field, paramLabelRenderer, this.colorScheme);
                this.layout(field, values);
            }

            public String toString() {
                return this.table.toString();
            }
        }

        static class DefaultParamLabelRenderer
        implements IParamLabelRenderer {
            public final String separator;

            public DefaultParamLabelRenderer(String separator) {
                this.separator = Assert.notNull(separator, "separator");
            }

            @Override
            public String separator() {
                return this.separator;
            }

            @Override
            public Ansi.Text renderParameterLabel(Field field, Ansi ansi, List<Ansi.IStyle> styles) {
                String sep;
                boolean isOptionParameter = field.isAnnotationPresent(Option.class);
                Range arity = isOptionParameter ? Range.optionArity(field) : Range.parameterArity(field);
                Ansi ansi2 = ansi;
                ((Object)((Object)ansi2)).getClass();
                Ansi.Text result = ansi2.new Ansi.Text("");
                String string = sep = isOptionParameter ? this.separator : "";
                if (arity.min > 0) {
                    for (int i = 0; i < arity.min; ++i) {
                        result = result.append(sep).append(ansi.apply(this.renderParameterName(field), styles));
                        sep = " ";
                    }
                }
                if (arity.max > arity.min) {
                    int i;
                    sep = result.length == 0 ? (isOptionParameter ? this.separator : "") : " ";
                    int max = arity.isVariable ? 1 : arity.max - arity.min;
                    for (i = 0; i < max; ++i) {
                        result = sep.trim().length() == 0 ? result.append(sep + "[").append(ansi.apply(this.renderParameterName(field), styles)) : result.append("[" + sep).append(ansi.apply(this.renderParameterName(field), styles));
                        sep = " ";
                    }
                    if (arity.isVariable) {
                        result = result.append("...");
                    }
                    for (i = 0; i < max; ++i) {
                        result = result.append("]");
                    }
                }
                return result;
            }

            private String renderParameterName(Field field) {
                String result = null;
                if (field.isAnnotationPresent(Option.class)) {
                    result = field.getAnnotation(Option.class).paramLabel();
                } else if (field.isAnnotationPresent(Parameters.class)) {
                    result = field.getAnnotation(Parameters.class).paramLabel();
                }
                if (result != null && result.trim().length() > 0) {
                    return result.trim();
                }
                return "<" + field.getName() + ">";
            }
        }

        public static interface IParamLabelRenderer {
            public Ansi.Text renderParameterLabel(Field var1, Ansi var2, List<Ansi.IStyle> var3);

            public String separator();
        }

        static class DefaultParameterRenderer
        implements IParameterRenderer {
            public String requiredMarker = " ";

            DefaultParameterRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Parameters params, Field field, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                Ansi.Text label = paramLabelRenderer.renderParameterLabel(field, scheme.ansi(), scheme.parameterStyles);
                Ansi.Text requiredParameter = scheme.parameterText(Range.parameterArity((Field)field).min > 0 ? this.requiredMarker : "");
                int COLUMN_COUNT = 5;
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                Ansi.Text[][] result = new Ansi.Text[Math.max(1, params.description().length)][5];
                Ansi.Text[] textArray = new Ansi.Text[5];
                textArray[0] = requiredParameter;
                textArray[1] = EMPTY;
                textArray[2] = EMPTY;
                textArray[3] = label;
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[4] = ansi.new Ansi.Text(CommandLine.str(params.description(), 0));
                result[0] = textArray;
                for (int i = 1; i < params.description().length; ++i) {
                    Ansi.Text[] textArray2 = new Ansi.Text[5];
                    textArray2[0] = EMPTY;
                    textArray2[1] = EMPTY;
                    textArray2[2] = EMPTY;
                    textArray2[3] = EMPTY;
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    textArray2[4] = ansi2.new Ansi.Text(params.description()[i]);
                    result[i] = textArray2;
                }
                return result;
            }
        }

        public static interface IParameterRenderer {
            public Ansi.Text[][] render(Parameters var1, Field var2, IParamLabelRenderer var3, ColorScheme var4);
        }

        static class MinimalParameterRenderer
        implements IParameterRenderer {
            MinimalParameterRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Parameters param, Field field, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = parameterLabelRenderer.renderParameterLabel(field, scheme.ansi(), scheme.parameterStyles);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(param.description().length == 0 ? "" : param.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class MinimalOptionRenderer
        implements IOptionRenderer {
            MinimalOptionRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Option option, Field field, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text optionText = scheme.optionText(option.names()[0]);
                Ansi.Text paramLabelText = parameterLabelRenderer.renderParameterLabel(field, scheme.ansi(), scheme.optionParamStyles);
                optionText = optionText.append(paramLabelText);
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = optionText;
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(option.description().length == 0 ? "" : option.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class DefaultOptionRenderer
        implements IOptionRenderer {
            public String requiredMarker = " ";
            public Object command;

            DefaultOptionRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Option option, Field field, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                String sep;
                String[] names = ShortestFirst.sort(option.names());
                int shortOptionCount = names[0].length() == 2 ? 1 : 0;
                String shortOption = shortOptionCount > 0 ? names[0] : "";
                Ansi.Text paramLabelText = paramLabelRenderer.renderParameterLabel(field, scheme.ansi(), scheme.optionParamStyles);
                String longOption = Help.join(names, shortOptionCount, names.length - shortOptionCount, ", ");
                String string = sep = shortOptionCount > 0 && names.length > 1 ? "," : "";
                if (paramLabelText.length > 0 && longOption.length() == 0) {
                    sep = paramLabelRenderer.separator();
                    paramLabelText = paramLabelText.substring(sep.length());
                }
                Ansi.Text longOptionText = scheme.optionText(longOption);
                longOptionText = longOptionText.append(paramLabelText);
                String requiredOption = option.required() ? this.requiredMarker : "";
                boolean showDefault = this.command != null && !option.help() && !CommandLine.isBoolean(field.getType());
                Object defaultValue = null;
                try {
                    defaultValue = field.get(this.command);
                    if (defaultValue != null && field.getType().isArray()) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < Array.getLength(defaultValue); ++i) {
                            sb.append(i > 0 ? ", " : "").append(Array.get(defaultValue, i));
                        }
                        defaultValue = sb.insert(0, "[").append("]").toString();
                    }
                }
                catch (Exception ex) {
                    showDefault = false;
                }
                int descriptionCount = Math.max(1, option.description().length);
                int ROW_COUNT = showDefault ? descriptionCount + 1 : descriptionCount;
                int COLUMN_COUNT = 5;
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                Ansi.Text[][] result = new Ansi.Text[ROW_COUNT][5];
                Ansi.Text[] textArray = new Ansi.Text[5];
                textArray[0] = scheme.optionText(requiredOption);
                textArray[1] = scheme.optionText(shortOption);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[2] = ansi.new Ansi.Text(sep);
                textArray[3] = longOptionText;
                Ansi ansi2 = scheme.ansi();
                ((Object)((Object)ansi2)).getClass();
                textArray[4] = ansi2.new Ansi.Text(CommandLine.str(option.description(), 0));
                result[0] = textArray;
                for (int i = 1; i < option.description().length; ++i) {
                    Ansi.Text[] textArray2 = new Ansi.Text[5];
                    textArray2[0] = EMPTY;
                    textArray2[1] = EMPTY;
                    textArray2[2] = EMPTY;
                    textArray2[3] = EMPTY;
                    Ansi ansi3 = scheme.ansi();
                    ((Object)((Object)ansi3)).getClass();
                    textArray2[4] = ansi3.new Ansi.Text(option.description()[i]);
                    result[i] = textArray2;
                }
                if (showDefault) {
                    Arrays.fill(result[result.length - 1], EMPTY);
                    int row = CommandLine.empty(result[ROW_COUNT - 2][4]) ? ROW_COUNT - 2 : ROW_COUNT - 1;
                    Ansi.Text[] textArray3 = result[row];
                    Ansi ansi4 = scheme.ansi();
                    ((Object)((Object)ansi4)).getClass();
                    textArray3[4] = ansi4.new Ansi.Text("  Default: " + defaultValue);
                }
                return result;
            }
        }

        public static interface IOptionRenderer {
            public Ansi.Text[][] render(Option var1, Field var2, IParamLabelRenderer var3, ColorScheme var4);
        }
    }

    private static class BuiltIn {
        private BuiltIn() {
        }

        static class UUIDConverter
        implements ITypeConverter<UUID> {
            UUIDConverter() {
            }

            @Override
            public UUID convert(String s) throws Exception {
                return UUID.fromString(s);
            }
        }

        static class PatternConverter
        implements ITypeConverter<Pattern> {
            PatternConverter() {
            }

            @Override
            public Pattern convert(String s) {
                return Pattern.compile(s);
            }
        }

        static class InetAddressConverter
        implements ITypeConverter<InetAddress> {
            InetAddressConverter() {
            }

            @Override
            public InetAddress convert(String s) throws Exception {
                return InetAddress.getByName(s);
            }
        }

        static class CharsetConverter
        implements ITypeConverter<Charset> {
            CharsetConverter() {
            }

            @Override
            public Charset convert(String s) {
                return Charset.forName(s);
            }
        }

        static class BigIntegerConverter
        implements ITypeConverter<BigInteger> {
            BigIntegerConverter() {
            }

            @Override
            public BigInteger convert(String value) {
                return new BigInteger(value);
            }
        }

        static class BigDecimalConverter
        implements ITypeConverter<BigDecimal> {
            BigDecimalConverter() {
            }

            @Override
            public BigDecimal convert(String value) {
                return new BigDecimal(value);
            }
        }

        static class ISO8601TimeConverter
        implements ITypeConverter<Time> {
            ISO8601TimeConverter() {
            }

            @Override
            public Time convert(String value) {
                try {
                    if (value.length() <= 5) {
                        return new Time(new SimpleDateFormat("HH:mm").parse(value).getTime());
                    }
                    if (value.length() <= 8) {
                        return new Time(new SimpleDateFormat("HH:mm:ss").parse(value).getTime());
                    }
                    if (value.length() <= 12) {
                        try {
                            return new Time(new SimpleDateFormat("HH:mm:ss.SSS").parse(value).getTime());
                        }
                        catch (ParseException e2) {
                            return new Time(new SimpleDateFormat("HH:mm:ss,SSS").parse(value).getTime());
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                throw new ParameterException("'" + value + "' is not a HH:mm[:ss[.SSS]] time");
            }
        }

        static class ISO8601DateConverter
        implements ITypeConverter<Date> {
            ISO8601DateConverter() {
            }

            @Override
            public Date convert(String value) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                catch (ParseException e) {
                    throw new ParameterException("'" + value + "' is not a yyyy-MM-dd date");
                }
            }
        }

        static class URIConverter
        implements ITypeConverter<URI> {
            URIConverter() {
            }

            @Override
            public URI convert(String value) throws URISyntaxException {
                return new URI(value);
            }
        }

        static class URLConverter
        implements ITypeConverter<URL> {
            URLConverter() {
            }

            @Override
            public URL convert(String value) throws MalformedURLException {
                return new URL(value);
            }
        }

        static class FileConverter
        implements ITypeConverter<File> {
            FileConverter() {
            }

            @Override
            public File convert(String value) {
                return new File(value);
            }
        }

        static class DoubleConverter
        implements ITypeConverter<Double> {
            DoubleConverter() {
            }

            @Override
            public Double convert(String value) {
                return Double.valueOf(value);
            }
        }

        static class FloatConverter
        implements ITypeConverter<Float> {
            FloatConverter() {
            }

            @Override
            public Float convert(String value) {
                return Float.valueOf(value);
            }
        }

        static class LongConverter
        implements ITypeConverter<Long> {
            LongConverter() {
            }

            @Override
            public Long convert(String value) {
                return Long.valueOf(value);
            }
        }

        static class IntegerConverter
        implements ITypeConverter<Integer> {
            IntegerConverter() {
            }

            @Override
            public Integer convert(String value) {
                return Integer.valueOf(value);
            }
        }

        static class ShortConverter
        implements ITypeConverter<Short> {
            ShortConverter() {
            }

            @Override
            public Short convert(String value) {
                return Short.valueOf(value);
            }
        }

        static class CharacterConverter
        implements ITypeConverter<Character> {
            CharacterConverter() {
            }

            @Override
            public Character convert(String value) {
                if (value.length() > 1) {
                    throw new ParameterException("'" + value + "' is not a single character");
                }
                return Character.valueOf(value.charAt(0));
            }
        }

        static class BooleanConverter
        implements ITypeConverter<Boolean> {
            BooleanConverter() {
            }

            @Override
            public Boolean convert(String value) {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return Boolean.parseBoolean(value);
                }
                throw new ParameterException("'" + value + "' is not a boolean");
            }
        }

        static class ByteConverter
        implements ITypeConverter<Byte> {
            ByteConverter() {
            }

            @Override
            public Byte convert(String value) {
                return Byte.valueOf(value);
            }
        }

        static class CharSequenceConverter
        implements ITypeConverter<CharSequence> {
            CharSequenceConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        static class StringBuilderConverter
        implements ITypeConverter<StringBuilder> {
            StringBuilderConverter() {
            }

            @Override
            public StringBuilder convert(String value) {
                return new StringBuilder(value);
            }
        }

        static class StringConverter
        implements ITypeConverter<String> {
            StringConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        static class PathConverter
        implements ITypeConverter<Path> {
            PathConverter() {
            }

            @Override
            public Path convert(String value) {
                return Paths.get(value, new String[0]);
            }
        }
    }

    private static class PositionalParametersSorter
    implements Comparator<Field> {
        private PositionalParametersSorter() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            int result = Range.parameterIndex(o1).compareTo(Range.parameterIndex(o2));
            return result == 0 ? Range.parameterArity(o1).compareTo(Range.parameterArity(o2)) : result;
        }
    }

    private class Interpreter {
        private final Map<String, CommandLine> commands = new LinkedHashMap<String, CommandLine>();
        private final Map<Class<?>, ITypeConverter<?>> converterRegistry = new HashMap();
        private final Map<String, Field> optionName2Field = new HashMap<String, Field>();
        private final Map<Character, Field> singleCharOption2Field = new HashMap<Character, Field>();
        private final List<Field> requiredFields = new ArrayList<Field>();
        private final List<Field> positionalParametersFields = new ArrayList<Field>();
        private final Object command;
        private boolean isHelpRequested;
        private String separator = "=";

        Interpreter(Object command) {
            this.converterRegistry.put(Path.class, new BuiltIn.PathConverter());
            this.converterRegistry.put(String.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(StringBuilder.class, new BuiltIn.StringBuilderConverter());
            this.converterRegistry.put(CharSequence.class, new BuiltIn.CharSequenceConverter());
            this.converterRegistry.put(Byte.class, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Byte.TYPE, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Boolean.class, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Boolean.TYPE, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Character.class, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Character.TYPE, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Short.class, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Short.TYPE, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Integer.class, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Integer.TYPE, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Long.class, new BuiltIn.LongConverter());
            this.converterRegistry.put(Long.TYPE, new BuiltIn.LongConverter());
            this.converterRegistry.put(Float.class, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Float.TYPE, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Double.class, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(Double.TYPE, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(File.class, new BuiltIn.FileConverter());
            this.converterRegistry.put(URI.class, new BuiltIn.URIConverter());
            this.converterRegistry.put(URL.class, new BuiltIn.URLConverter());
            this.converterRegistry.put(Date.class, new BuiltIn.ISO8601DateConverter());
            this.converterRegistry.put(Time.class, new BuiltIn.ISO8601TimeConverter());
            this.converterRegistry.put(BigDecimal.class, new BuiltIn.BigDecimalConverter());
            this.converterRegistry.put(BigInteger.class, new BuiltIn.BigIntegerConverter());
            this.converterRegistry.put(Charset.class, new BuiltIn.CharsetConverter());
            this.converterRegistry.put(InetAddress.class, new BuiltIn.InetAddressConverter());
            this.converterRegistry.put(Pattern.class, new BuiltIn.PatternConverter());
            this.converterRegistry.put(UUID.class, new BuiltIn.UUIDConverter());
            this.command = Assert.notNull(command, "command");
            String declaredSeparator = null;
            boolean hasCommandAnnotation = false;
            for (Class<?> cls = command.getClass(); cls != null; cls = cls.getSuperclass()) {
                CommandLine.init(cls, this.requiredFields, this.optionName2Field, this.singleCharOption2Field, this.positionalParametersFields);
                if (!cls.isAnnotationPresent(Command.class)) continue;
                hasCommandAnnotation = true;
                Command cmd = cls.getAnnotation(Command.class);
                declaredSeparator = declaredSeparator == null ? cmd.separator() : declaredSeparator;
                CommandLine.this.versionLines.addAll(Arrays.asList(cmd.version()));
                for (Class<?> sub : cmd.subcommands()) {
                    Command subCommand = sub.getAnnotation(Command.class);
                    if (subCommand == null || "<main class>".equals(subCommand.name())) {
                        throw new IllegalArgumentException("Subcommand " + sub.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                    }
                    try {
                        Constructor<?> constructor = sub.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        CommandLine commandLine2 = CommandLine.toCommandLine(constructor.newInstance(new Object[0]));
                        commandLine2.parent = CommandLine.this;
                        this.commands.put(subCommand.name(), commandLine2);
                    }
                    catch (IllegalArgumentException ex) {
                        throw ex;
                    }
                    catch (NoSuchMethodException ex) {
                        throw new IllegalArgumentException("Cannot instantiate subcommand " + sub.getName() + ": the class has no constructor", ex);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Could not instantiate and add subcommand " + sub.getName() + ": " + ex, ex);
                    }
                }
            }
            this.separator = declaredSeparator != null ? declaredSeparator : this.separator;
            Collections.sort(this.positionalParametersFields, new PositionalParametersSorter());
            CommandLine.validatePositionalParameters(this.positionalParametersFields);
            if (this.positionalParametersFields.isEmpty() && this.optionName2Field.isEmpty() && !hasCommandAnnotation) {
                throw new IllegalArgumentException(command + " (" + command.getClass() + ") is not a command: it has no @Command, @Option or @Parameters annotations");
            }
        }

        List<CommandLine> parse(String ... args) {
            Assert.notNull(args, "argument array");
            Stack<String> arguments = new Stack<String>();
            for (int i = args.length - 1; i >= 0; --i) {
                arguments.push(args[i]);
            }
            ArrayList<CommandLine> result = new ArrayList<CommandLine>();
            this.parse(result, arguments, args);
            return result;
        }

        private void parse(List<CommandLine> parsedCommands, Stack<String> argumentStack, String[] originalArgs) {
            this.isHelpRequested = false;
            CommandLine.this.versionHelpRequested = false;
            CommandLine.this.usageHelpRequested = false;
            parsedCommands.add(CommandLine.this);
            ArrayList<Field> required = new ArrayList<Field>(this.requiredFields);
            HashSet<Field> initialized = new HashSet<Field>();
            Collections.sort(required, new PositionalParametersSorter());
            try {
                this.processArguments(parsedCommands, argumentStack, required, initialized, originalArgs);
            }
            catch (ParameterException ex) {
                throw ex;
            }
            catch (Exception ex) {
                int offendingArgIndex = originalArgs.length - argumentStack.size();
                String arg = offendingArgIndex >= 0 && offendingArgIndex < originalArgs.length ? originalArgs[offendingArgIndex] : "?";
                throw ParameterException.create(ex, arg, argumentStack.size(), originalArgs);
            }
            if (!this.isAnyHelpRequested() && !required.isEmpty()) {
                if (((Field)required.get(0)).isAnnotationPresent(Option.class)) {
                    throw MissingParameterException.create(required);
                }
                try {
                    this.processPositionalParameters0(required, true, new Stack<String>());
                }
                catch (ParameterException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Internal error: " + ex, ex);
                }
            }
        }

        private void processArguments(List<CommandLine> parsedCommands, Stack<String> args, Collection<Field> required, Set<Field> initialized, String[] originalArgs) throws Exception {
            while (!args.isEmpty()) {
                String key;
                String arg = args.pop();
                if ("--".equals(arg)) {
                    this.processPositionalParameters(required, args);
                    return;
                }
                if (this.commands.containsKey(arg)) {
                    if (!this.isHelpRequested && !required.isEmpty()) {
                        throw MissingParameterException.create(required);
                    }
                    this.commands.get(arg).interpreter.parse(parsedCommands, args, originalArgs);
                    return;
                }
                boolean paramAttachedToOption = false;
                int separatorIndex = arg.indexOf(this.separator);
                if (separatorIndex > 0 && this.optionName2Field.containsKey(key = arg.substring(0, separatorIndex)) && !this.optionName2Field.containsKey(arg)) {
                    paramAttachedToOption = true;
                    String optionParam = arg.substring(separatorIndex + this.separator.length());
                    args.push(optionParam);
                    arg = key;
                }
                if (this.optionName2Field.containsKey(arg)) {
                    this.processStandaloneOption(required, initialized, arg, args, paramAttachedToOption);
                    continue;
                }
                if (arg.length() > 2 && arg.startsWith("-")) {
                    this.processClusteredShortOptions(required, initialized, arg, args);
                    continue;
                }
                args.push(arg);
                this.processPositionalParameters(required, args);
                return;
            }
        }

        private void processPositionalParameters(Collection<Field> required, Stack<String> args) throws Exception {
            this.processPositionalParameters0(required, false, args);
            if (!args.empty()) {
                this.handleUnmatchedArguments(args);
                return;
            }
        }

        private void handleUnmatchedArguments(Stack<String> args) {
            if (!CommandLine.this.isUnmatchedArgumentsAllowed()) {
                throw new UnmatchedArgumentException(args);
            }
            while (!args.isEmpty()) {
                CommandLine.this.unmatchedArguments.add(args.pop());
            }
        }

        private void processPositionalParameters0(Collection<Field> required, boolean validateOnly, Stack<String> args) throws Exception {
            int max = -1;
            for (Field positionalParam : this.positionalParametersFields) {
                int i;
                Range indexRange = Range.parameterIndex(positionalParam);
                max = Math.max(max, indexRange.max);
                Stack argsCopy = CommandLine.reverse((Stack)args.clone());
                if (!indexRange.isVariable) {
                    for (i = argsCopy.size() - 1; i > indexRange.max; --i) {
                        argsCopy.removeElementAt(i);
                    }
                }
                Collections.reverse(argsCopy);
                for (i = 0; i < indexRange.min && !argsCopy.isEmpty(); ++i) {
                    argsCopy.pop();
                }
                Range arity = Range.parameterArity(positionalParam);
                this.assertNoMissingParameters(positionalParam, arity.min, argsCopy);
                if (validateOnly) continue;
                this.applyOption(positionalParam, Parameters.class, arity, false, argsCopy, null);
                required.remove(positionalParam);
            }
            if (!validateOnly && !this.positionalParametersFields.isEmpty()) {
                int processedArgCount = Math.min(args.size(), max < Integer.MAX_VALUE ? max + 1 : Integer.MAX_VALUE);
                for (int i = 0; i < processedArgCount; ++i) {
                    args.pop();
                }
            }
        }

        private void processStandaloneOption(Collection<Field> required, Set<Field> initialized, String arg, Stack<String> args, boolean paramAttachedToKey) throws Exception {
            Field field = this.optionName2Field.get(arg);
            required.remove(field);
            Range arity = Range.optionArity(field);
            if (paramAttachedToKey) {
                arity = arity.min(Math.max(1, arity.min));
            }
            this.applyOption(field, Option.class, arity, paramAttachedToKey, args, initialized);
        }

        private void processClusteredShortOptions(Collection<Field> required, Set<Field> initialized, String arg, Stack<String> args) throws Exception {
            String prefix = arg.substring(0, 1);
            String cluster = arg.substring(1);
            boolean paramAttachedToOption = true;
            while (cluster.length() > 0 && this.singleCharOption2Field.containsKey(Character.valueOf(cluster.charAt(0)))) {
                Field field = this.singleCharOption2Field.get(Character.valueOf(cluster.charAt(0)));
                required.remove(field);
                cluster = cluster.length() > 0 ? cluster.substring(1) : "";
                paramAttachedToOption = cluster.length() > 0;
                Range arity = Range.optionArity(field);
                if (cluster.startsWith(this.separator)) {
                    cluster = cluster.substring(this.separator.length());
                    arity = arity.min(Math.max(1, arity.min));
                }
                args.push(cluster);
                int consumed = this.applyOption(field, Option.class, arity, paramAttachedToOption, args, initialized);
                if (consumed > 0) {
                    return;
                }
                cluster = args.pop();
            }
            if (cluster.length() == 0) {
                return;
            }
            if (arg.endsWith(cluster)) {
                args.push(paramAttachedToOption ? prefix + cluster : cluster);
                this.handleUnmatchedArguments(args);
            }
            args.push(cluster);
            this.processPositionalParameters(required, args);
        }

        private int applyOption(Field field, Class<?> annotation2, Range arity, boolean valueAttachedToOption, Stack<String> args, Set<Field> initialized) throws Exception {
            this.updateHelpRequested(field);
            if (!args.isEmpty() && args.peek().length() == 0 && !valueAttachedToOption) {
                args.pop();
            }
            int length = args.size();
            this.assertNoMissingParameters(field, arity.min, args);
            Class<?> cls = field.getType();
            if (cls.isArray()) {
                return this.applyValuesToArrayField(field, annotation2, arity, args, cls);
            }
            if (Collection.class.isAssignableFrom(cls)) {
                return this.applyValuesToCollectionField(field, annotation2, arity, args, cls);
            }
            return this.applyValueToSingleValuedField(field, arity, args, cls, initialized);
        }

        private int applyValueToSingleValuedField(Field field, Range arity, Stack<String> args, Class<?> cls, Set<Field> initialized) throws Exception {
            boolean noMoreValues = args.isEmpty();
            String value = args.isEmpty() ? null : this.trim(args.pop());
            int result = arity.min;
            if ((cls == Boolean.class || cls == Boolean.TYPE) && arity.min <= 0) {
                if (arity.max > 0 && ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
                    result = 1;
                } else {
                    Boolean currentValue;
                    if (value != null) {
                        args.push(value);
                    }
                    value = String.valueOf((currentValue = (Boolean)field.get(this.command)) == null ? true : currentValue == false);
                }
            }
            if (noMoreValues && value == null) {
                return 0;
            }
            if (initialized != null) {
                if (initialized.contains(field) && !CommandLine.this.isOverwrittenOptionsAllowed()) {
                    throw new OverwrittenOptionException(this.optionDescription("", field, 0) + " should be specified only once");
                }
                initialized.add(field);
            }
            ITypeConverter<?> converter = this.getTypeConverter(cls);
            Object objValue = this.tryConvert(field, -1, converter, value, cls);
            field.set(this.command, objValue);
            return result;
        }

        private int applyValuesToArrayField(Field field, Class<?> annotation2, Range arity, Stack<String> args, Class<?> cls) throws Exception {
            Class<?> type = cls.getComponentType();
            ITypeConverter<?> converter = this.getTypeConverter(type);
            List<Object> converted = this.consumeArguments(field, annotation2, arity, args, converter, cls);
            Object existing = field.get(this.command);
            int length = existing == null ? 0 : Array.getLength(existing);
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                newValues.add(Array.get(existing, i));
            }
            for (Object obj : converted) {
                if (obj instanceof Collection) {
                    newValues.addAll((Collection)obj);
                    continue;
                }
                newValues.add(obj);
            }
            Object array = Array.newInstance(type, newValues.size());
            field.set(this.command, array);
            for (int i = 0; i < newValues.size(); ++i) {
                Array.set(array, i, newValues.get(i));
            }
            return converted.size();
        }

        private int applyValuesToCollectionField(Field field, Class<?> annotation2, Range arity, Stack<String> args, Class<?> cls) throws Exception {
            Collection<Object> collection = (Collection<Object>)field.get(this.command);
            Class<?> type = this.getTypeAttribute(field);
            ITypeConverter<?> converter = this.getTypeConverter(type);
            List<Object> converted = this.consumeArguments(field, annotation2, arity, args, converter, type);
            if (collection == null) {
                collection = this.createCollection(cls);
                field.set(this.command, collection);
            }
            for (Object element : converted) {
                if (element instanceof Collection) {
                    collection.addAll((Collection)element);
                    continue;
                }
                collection.add(element);
            }
            return converted.size();
        }

        private List<Object> consumeArguments(Field field, Class<?> annotation2, Range arity, Stack<String> args, ITypeConverter<?> converter, Class<?> type) throws Exception {
            ArrayList<Object> result = new ArrayList<Object>();
            int index = 0;
            int i = 0;
            while (result.size() < arity.min) {
                index = this.consumeOneArgument(field, arity, args, converter, type, result, index);
                ++i;
            }
            while (result.size() < arity.max && !args.isEmpty()) {
                if (annotation2 != Parameters.class && (this.commands.containsKey(args.peek()) || this.isOption(args.peek()))) {
                    return result;
                }
                index = this.consumeOneArgument(field, arity, args, converter, type, result, index);
            }
            return result;
        }

        private int consumeOneArgument(Field field, Range arity, Stack<String> args, ITypeConverter<?> converter, Class<?> type, List<Object> result, int index) throws Exception {
            int j;
            String[] values = this.split(this.trim(args.pop()), field);
            int max = Math.min(arity.max - result.size(), values.length);
            for (j = 0; j < max; ++j) {
                result.add(this.tryConvert(field, index, converter, values[j], type));
            }
            for (j = values.length - 1; j >= max; --j) {
                args.push(values[j]);
            }
            return ++index;
        }

        private String[] split(String value, Field field) {
            if (field.isAnnotationPresent(Option.class)) {
                String[] stringArray;
                String regex = field.getAnnotation(Option.class).split();
                if (regex.length() == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = value;
                } else {
                    stringArray = value.split(regex);
                }
                return stringArray;
            }
            if (field.isAnnotationPresent(Parameters.class)) {
                String[] stringArray;
                String regex = field.getAnnotation(Parameters.class).split();
                if (regex.length() == 0) {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = value;
                } else {
                    stringArray = value.split(regex);
                }
                return stringArray;
            }
            return new String[]{value};
        }

        private boolean isOption(String arg) {
            if ("--".equals(arg)) {
                return true;
            }
            if (this.optionName2Field.containsKey(arg)) {
                return true;
            }
            int separatorIndex = arg.indexOf(this.separator);
            if (separatorIndex > 0 && this.optionName2Field.containsKey(arg.substring(0, separatorIndex))) {
                return true;
            }
            return arg.length() > 2 && arg.startsWith("-") && this.singleCharOption2Field.containsKey(Character.valueOf(arg.charAt(1)));
        }

        private Object tryConvert(Field field, int index, ITypeConverter<?> converter, String value, Class<?> type) throws Exception {
            try {
                return converter.convert(value);
            }
            catch (ParameterException ex) {
                throw new ParameterException(ex.getMessage() + this.optionDescription(" for ", field, index));
            }
            catch (Exception other) {
                String desc = this.optionDescription(" for ", field, index) + ": " + other;
                throw new ParameterException("Could not convert '" + value + "' to " + type.getSimpleName() + desc, other);
            }
        }

        private String optionDescription(String prefix, Field field, int index) {
            Help.IParamLabelRenderer labelRenderer = Help.createMinimalParamLabelRenderer();
            String desc = "";
            if (field.isAnnotationPresent(Option.class)) {
                desc = prefix + "option '" + field.getAnnotation(Option.class).names()[0] + "'";
                if (index >= 0) {
                    Range arity = Range.optionArity(field);
                    if (arity.max > 1) {
                        desc = desc + " at index " + index;
                    }
                    desc = desc + " (" + labelRenderer.renderParameterLabel(field, Help.Ansi.OFF, Collections.emptyList()) + ")";
                }
            } else if (field.isAnnotationPresent(Parameters.class)) {
                Range indexRange = Range.parameterIndex(field);
                Help.Ansi.Text label = labelRenderer.renderParameterLabel(field, Help.Ansi.OFF, Collections.emptyList());
                desc = prefix + "positional parameter at index " + indexRange + " (" + label + ")";
            }
            return desc;
        }

        private Class<?> getTypeAttribute(Field field) {
            if (field.isAnnotationPresent(Parameters.class)) {
                return field.getAnnotation(Parameters.class).type();
            }
            if (field.isAnnotationPresent(Option.class)) {
                return field.getAnnotation(Option.class).type();
            }
            throw new IllegalStateException(field + " has neither @Parameters nor @Option annotation");
        }

        private boolean isAnyHelpRequested() {
            return this.isHelpRequested || CommandLine.this.versionHelpRequested || CommandLine.this.usageHelpRequested;
        }

        private void updateHelpRequested(Field field) {
            if (field.isAnnotationPresent(Option.class)) {
                this.isHelpRequested |= field.getAnnotation(Option.class).help();
                CommandLine.this.versionHelpRequested = (byte)(CommandLine.this.versionHelpRequested | (field.getAnnotation(Option.class).versionHelp() ? 1 : 0));
                CommandLine.this.usageHelpRequested = (byte)(CommandLine.this.usageHelpRequested | (field.getAnnotation(Option.class).usageHelp() ? 1 : 0));
            }
        }

        private Collection<Object> createCollection(Class<?> collectionClass) throws Exception {
            if (collectionClass.isInterface()) {
                if (List.class.isAssignableFrom(collectionClass)) {
                    return new ArrayList<Object>();
                }
                if (SortedSet.class.isAssignableFrom(collectionClass)) {
                    return new TreeSet<Object>();
                }
                if (Set.class.isAssignableFrom(collectionClass)) {
                    return new HashSet<Object>();
                }
                if (Queue.class.isAssignableFrom(collectionClass)) {
                    return new LinkedList<Object>();
                }
                return new ArrayList<Object>();
            }
            return (Collection)collectionClass.newInstance();
        }

        private ITypeConverter<?> getTypeConverter(final Class<?> type) {
            ITypeConverter<?> result = this.converterRegistry.get(type);
            if (result != null) {
                return result;
            }
            if (type.isEnum()) {
                return new ITypeConverter<Object>(){

                    @Override
                    public Object convert(String value) throws Exception {
                        return Enum.valueOf(type, value);
                    }
                };
            }
            throw new MissingTypeConverterException("No TypeConverter registered for " + type.getName());
        }

        private void assertNoMissingParameters(Field field, int arity, Stack<String> args) {
            if (arity > args.size()) {
                int actualSize = 0;
                Stack copy = (Stack)args.clone();
                while (!copy.isEmpty()) {
                    if ((actualSize += this.split((String)copy.pop(), field).length) < arity) continue;
                    return;
                }
                if (arity == 1) {
                    if (field.isAnnotationPresent(Option.class)) {
                        throw new MissingParameterException("Missing required parameter for " + this.optionDescription("", field, 0));
                    }
                    Range indexRange = Range.parameterIndex(field);
                    Help.IParamLabelRenderer labelRenderer = Help.createMinimalParamLabelRenderer();
                    String sep = "";
                    String names = "";
                    int count = 0;
                    for (int i = indexRange.min; i < this.positionalParametersFields.size(); ++i) {
                        if (Range.parameterArity((Field)this.positionalParametersFields.get((int)i)).min <= 0) continue;
                        names = names + sep + labelRenderer.renderParameterLabel(this.positionalParametersFields.get(i), Help.Ansi.OFF, Collections.emptyList());
                        sep = ", ";
                        ++count;
                    }
                    String msg = "Missing required parameter";
                    Range paramArity = Range.parameterArity(field);
                    msg = paramArity.isVariable ? msg + "s at positions " + indexRange + ": " : msg + (count > 1 ? "s: " : ": ");
                    throw new MissingParameterException(msg + names);
                }
                throw new MissingParameterException(this.optionDescription("", field, 0) + " requires at least " + arity + " values, but only " + args.size() + " were specified.");
            }
        }

        private String trim(String value) {
            return this.unquote(value);
        }

        private String unquote(String value) {
            return value == null ? null : (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value);
        }
    }

    public static class Range
    implements Comparable<Range> {
        public final int min;
        public final int max;
        public final boolean isVariable;
        private final boolean isUnspecified;
        private final String originalValue;

        public Range(int min, int max, boolean variable, boolean unspecified, String originalValue) {
            this.min = min;
            this.max = max;
            this.isVariable = variable;
            this.isUnspecified = unspecified;
            this.originalValue = originalValue;
        }

        public static Range optionArity(Field field) {
            return field.isAnnotationPresent(Option.class) ? Range.adjustForType(Range.valueOf(field.getAnnotation(Option.class).arity()), field) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterArity(Field field) {
            return field.isAnnotationPresent(Parameters.class) ? Range.adjustForType(Range.valueOf(field.getAnnotation(Parameters.class).arity()), field) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterIndex(Field field) {
            return field.isAnnotationPresent(Parameters.class) ? Range.valueOf(field.getAnnotation(Parameters.class).index()) : new Range(0, 0, false, true, "0");
        }

        static Range adjustForType(Range result, Field field) {
            return result.isUnspecified ? Range.defaultArity(field.getType()) : result;
        }

        public static Range defaultArity(Class<?> type) {
            if (CommandLine.isBoolean(type)) {
                return Range.valueOf("0");
            }
            if (type.isArray() || Collection.class.isAssignableFrom(type)) {
                return Range.valueOf("0..*");
            }
            return Range.valueOf("1");
        }

        public static Range valueOf(String range) {
            boolean unspecified = (range = range.trim()).length() == 0 || range.startsWith("..");
            int min = -1;
            int max = -1;
            boolean variable = false;
            int dots = -1;
            dots = range.indexOf("..");
            if (dots >= 0) {
                min = Range.parseInt(range.substring(0, dots), 0);
                max = Range.parseInt(range.substring(dots + 2), Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
            } else {
                max = Range.parseInt(range, Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
                min = variable ? 0 : max;
            }
            Range result = new Range(min, max, variable, unspecified, range);
            return result;
        }

        private static int parseInt(String str, int defaultValue) {
            try {
                return Integer.parseInt(str);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        public Range min(int newMin) {
            return new Range(newMin, Math.max(newMin, this.max), this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range max(int newMax) {
            return new Range(Math.min(this.min, newMax), newMax, this.isVariable, this.isUnspecified, this.originalValue);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range other = (Range)object;
            return other.max == this.max && other.min == this.min && other.isVariable == this.isVariable;
        }

        public int hashCode() {
            return ((629 + this.max) * 37 + this.min) * 37 + (this.isVariable ? 1 : 0);
        }

        public String toString() {
            return this.min == this.max ? String.valueOf(this.min) : this.min + ".." + (this.isVariable ? "*" : Integer.valueOf(this.max));
        }

        @Override
        public int compareTo(Range other) {
            int result = this.min - other.min;
            return result == 0 ? this.max - other.max : result;
        }
    }

    public static interface ITypeConverter<K> {
        public K convert(String var1) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Command {
        public String name() default "<main class>";

        public Class<?>[] subcommands() default {};

        public String separator() default "=";

        public String[] version() default {};

        public String headerHeading() default "";

        public String[] header() default {};

        public String synopsisHeading() default "Usage: ";

        public boolean abbreviateSynopsis() default false;

        public String[] customSynopsis() default {};

        public String descriptionHeading() default "";

        public String[] description() default {};

        public String parameterListHeading() default "";

        public String optionListHeading() default "";

        public boolean sortOptions() default true;

        public char requiredOptionMarker() default 32;

        public boolean showDefaultValues() default false;

        public String commandListHeading() default "Commands:%n";

        public String footerHeading() default "";

        public String[] footer() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameters {
        public String index() default "*";

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?> type() default String.class;

        public String split() default "";

        public boolean hidden() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String[] names();

        public boolean required() default false;

        public boolean help() default false;

        public boolean usageHelp() default false;

        public boolean versionHelp() default false;

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?> type() default String.class;

        public String split() default "";

        public boolean hidden() default false;
    }
}

