/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master.utils;

import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.exceptions.NonInstantiableException;
import java.io.IOException;
import java.util.HashSet;

public class SSHManager {
    private static final HashSet<COMPSsWorker> WORKERS = new HashSet();

    private SSHManager() {
        throw new NonInstantiableException("SSHManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWorker(COMPSsWorker worker) {
        HashSet<COMPSsWorker> hashSet = WORKERS;
        synchronized (hashSet) {
            WORKERS.add(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWorker(COMPSsWorker worker) {
        HashSet<COMPSsWorker> hashSet = WORKERS;
        synchronized (hashSet) {
            WORKERS.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void announceCreation(COMPSsWorker worker) throws IOException {
        Process[] p;
        int i = 0;
        HashSet<COMPSsWorker> hashSet = WORKERS;
        synchronized (hashSet) {
            p = new Process[WORKERS.size() * 2];
            for (COMPSsWorker remote : WORKERS) {
                String[] cmd = new String[]{"ssh", remote.getUser() + "@" + remote.getName(), "ssh-keyscan -t rsa,dsa " + worker.getName() + " >> /home/" + remote.getUser() + "/.ssh/known_hosts"};
                p[i] = Runtime.getRuntime().exec(cmd);
                cmd = new String[]{"ssh", remote.getUser() + "@" + remote.getName(), "ssh-keyscan -t rsa,dsa " + remote.getName() + " >> /home/" + worker.getUser() + "/.ssh/known_hosts"};
                p[++i] = Runtime.getRuntime().exec(cmd);
                ++i;
            }
        }
        for (i = 0; i < p.length; ++i) {
            try {
                p[i].waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            p[i].getErrorStream().close();
            p[i].getOutputStream().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void announceDestruction(COMPSsWorker worker) throws IOException {
        Process[] p;
        int i = 1;
        HashSet<COMPSsWorker> hashSet = WORKERS;
        synchronized (hashSet) {
            p = new Process[WORKERS.size()];
            for (COMPSsWorker remote : WORKERS) {
                String user = remote.getUser();
                String[] cmd = new String[]{"ssh", user + "@" + remote.getName(), "mv /home/" + user + "/.ssh/known_hosts known " + "&& grep -vw " + worker.getName() + " known > /home/" + user + "/.ssh/known_hosts" + "&& rm known"};
                p[i] = Runtime.getRuntime().exec(cmd);
                ++i;
            }
        }
        for (i = 1; i < p.length; ++i) {
            try {
                p[i].waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            p[i].getErrorStream().close();
            p[i].getOutputStream().close();
        }
    }

    public static void removeKey(COMPSsWorker worker) throws IOException {
        String user = System.getProperty("user.name");
        String[] cmd = new String[]{"mv /home/" + user + "/.ssh/known_hosts known " + "&& grep -vw " + worker.getName() + " known > /home/" + user + "/.ssh/known_hosts" + "&& rm known"};
        Process p = Runtime.getRuntime().exec(cmd);
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        p.getErrorStream().close();
        p.getOutputStream().close();
    }
}

