/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine.util;

import ibis.util.ThreadPool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamForwarder
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StreamForwarder.class);
    private final InputStream in;
    private final OutputStream out;
    private boolean finished = false;
    private String name;

    public StreamForwarder(InputStream in, OutputStream out) {
        this(in, out, "");
    }

    public StreamForwarder(InputStream in, OutputStream out, String name) {
        this.in = new BufferedInputStream(in);
        this.out = out;
        this.name = name;
        if (logger.isDebugEnabled()) {
            logger.debug(name + ": in = " + in);
        }
        ThreadPool.createNew(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buffer = new byte[4096];
        try {
            while (true) {
                int read;
                if (logger.isDebugEnabled()) {
                    logger.debug(this.name + ": reading from " + this.in);
                }
                if ((read = this.in.read(buffer)) == -1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.name + ": StreamForwarder got EOF");
                    }
                    if (this.out == null) return;
                    this.out.flush();
                    return;
                }
                if (logger.isTraceEnabled()) {
                    for (int i = 0; i < read; ++i) {
                        logger.trace(this.name + ": read byte: " + buffer[i] + " (" + (char)buffer[i] + ")");
                    }
                }
                if (this.out != null) {
                    this.out.write(buffer, 0, read);
                    this.out.flush();
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace(this.name + " forwarded: " + new String(buffer, 0, read));
                    continue;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info(this.name + ": forwarding impossible, outputstream closed");
                continue;
                break;
            }
        }
        catch (IOException e) {
            if (logger.isInfoEnabled()) {
                logger.info(this.name + ": caught exception: " + e);
            }
            if (!logger.isDebugEnabled()) return;
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.debug(this.name + ": stacktrace: \n" + writer.toString());
            return;
        }
        finally {
            StreamForwarder streamForwarder = this;
            synchronized (streamForwarder) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized void waitUntilFinished() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {}
        }
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

