/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.monitoring;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.gridlab.gat.monitoring.MetricDefinition;

public class Metric
implements Serializable {
    private MetricDefinition definition;
    private Hashtable<String, Object> metricParameters;
    private long frequency;

    public Metric(MetricDefinition definition, Map<String, Object> metricParameters) {
        this.definition = definition;
        this.metricParameters = metricParameters == null ? new Hashtable() : new Hashtable<String, Object>(metricParameters);
    }

    public Metric(MetricDefinition definition, Map<String, Object> metricParameters, long frequency) {
        this.definition = definition;
        this.frequency = frequency;
        this.metricParameters = metricParameters == null ? new Hashtable() : new Hashtable<String, Object>(metricParameters);
    }

    public boolean equals(Object object) {
        Metric metric = null;
        if (!(object instanceof Metric)) {
            return false;
        }
        metric = (Metric)object;
        return this.definition.equals(metric.definition) && this.metricParameters.equals(metric.metricParameters);
    }

    public Map<String, Object> getMetricParameters() {
        return this.metricParameters;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public Object getMetricParameterByName(String name) {
        return this.metricParameters.get(name);
    }

    public MetricDefinition getDefinition() {
        return this.definition;
    }

    public String toString() {
        return "Metric(def = " + this.definition + ", params = " + this.metricParameters + ", freq = " + this.frequency + ")";
    }
}

