/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.security.ssh;

import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.InvalidUsernameOrPasswordException;
import org.gridlab.gat.URI;
import org.gridlab.gat.security.CertificateSecurityContext;
import org.gridlab.gat.security.CredentialSecurityContext;
import org.gridlab.gat.security.PasswordSecurityContext;
import org.gridlab.gat.security.SecurityContext;
import org.gridlab.gat.security.cpi.SecurityContextCreator;
import org.gridlab.gat.security.cpi.SecurityContextUtils;
import org.gridlab.gat.security.ssh.SshSecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshContextCreator
implements SecurityContextCreator {
    protected static Logger logger = LoggerFactory.getLogger(SshSecurityUtils.class);

    SshContextCreator() {
    }

    @Override
    public SecurityContext createDefaultSecurityContext(GATContext gatContext, URI location) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        Map<String, String> credentials = SshSecurityUtils.getDefaultUserInfo(gatContext, location);
        CredentialSecurityContext c = new CredentialSecurityContext();
        c.putDataObject("ssh", credentials);
        return c;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object createUserData(GATContext gatContext, URI location, SecurityContext inContext) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        if (inContext instanceof CredentialSecurityContext) {
            return inContext.getDataObject("ssh");
        }
        if (!(inContext instanceof CertificateSecurityContext)) {
            if (!(inContext instanceof PasswordSecurityContext)) return null;
            PasswordSecurityContext c = (PasswordSecurityContext)inContext;
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", SecurityContextUtils.getUser(gatContext, inContext, location));
            credentials.put("password", "" + c.getPassword());
            return credentials;
        }
        CertificateSecurityContext c = (CertificateSecurityContext)inContext;
        if (c.getKeyfile() == null) {
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", SecurityContextUtils.getUser(gatContext, inContext, location));
            credentials.put("password", c.getPassword());
            credentials.put("privatekeyslot", "" + c.getPrivateKeySlot());
            return credentials;
        }
        if (c.getKeyfile().isCompatible("file") && c.getKeyfile().refersToLocalHost()) {
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", SecurityContextUtils.getUser(gatContext, inContext, location));
            credentials.put("privatekeyfile", "" + c.getKeyfile().getPath());
            credentials.put("privatekeyslot", "" + c.getPrivateKeySlot());
            return credentials;
        }
        if (!logger.isDebugEnabled()) return null;
        logger.debug("WARNING: URI for key file does not refer to local host, skipping this security context");
        return null;
    }
}

