/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.security;

import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class SecurityContext
implements Cloneable {
    protected String username;
    protected String password = null;
    protected HashMap<String, Object> dataObjects = new HashMap();
    protected HashMap<String, String> notes = new HashMap();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected SecurityContext(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public synchronized Object getDataObject(String key) {
        return this.dataObjects.get(key);
    }

    public synchronized void putDataObject(String key, Object data) {
        this.dataObjects.put(key, data);
    }

    public synchronized void removeDataObject(String key) {
        this.dataObjects.remove(key);
    }

    public final void addNote(String key, String value) {
        this.notes.put(key, value);
    }

    public final boolean containsNoteKey(String key) {
        return this.notes.containsKey(key);
    }

    public final String getNoteValue(String key) {
        return this.notes.get(key);
    }

    public boolean isValidFor(String adaptorName, String host, int port) {
        int i;
        if (this.notes.size() == 0) {
            return true;
        }
        boolean allowed = false;
        String adaptorList = this.notes.get("adaptors");
        if (adaptorList != null) {
            StringTokenizer tokens = new StringTokenizer(adaptorList, ",");
            int count = tokens.countTokens();
            for (i = 0; i < count; ++i) {
                String allowedAdaptor = tokens.nextToken();
                if (!allowedAdaptor.equalsIgnoreCase(adaptorName)) continue;
                allowed = true;
                break;
            }
        } else {
            allowed = true;
        }
        if (!allowed) {
            return false;
        }
        allowed = false;
        String hostList = this.notes.get("hosts");
        if (hostList != null) {
            StringTokenizer tokens = new StringTokenizer(hostList, ",");
            for (i = 0; i < tokens.countTokens(); ++i) {
                int allowedPort = -1;
                String allowedHost = tokens.nextToken();
                int pos = allowedHost.indexOf(":");
                if (pos > 0) {
                    allowedPort = Integer.parseInt(allowedHost.substring(pos + 1));
                    allowedHost = allowedHost.substring(0, pos);
                }
                if (!allowedHost.equalsIgnoreCase(host)) continue;
                if (allowedPort < 0 || allowedPort == port) {
                    allowed = true;
                }
                break;
            }
        } else {
            allowed = true;
        }
        if (!allowed) {
            // empty if block
        }
        return allowed;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

