/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.monitoring.cpi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.monitoring.Monitorable;
import org.gridlab.gat.monitoring.cpi.MetricListenerNode;
import org.gridlab.gat.monitoring.cpi.MetricNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitorableCpi
implements Monitorable {
    protected static Logger logger = LoggerFactory.getLogger(MonitorableCpi.class);
    private Vector<MetricListenerNode> metricListeners = new Vector();
    private Vector<MetricNode> metricTable = new Vector();

    public static Map<String, Boolean> getSupportedCapabilities() {
        HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>();
        capabilities.put("addMetricListener", true);
        capabilities.put("removeMetricListener", true);
        capabilities.put("getMetricDefinitions", true);
        capabilities.put("getMeasurement", true);
        capabilities.put("getMetricDefinitionByName", true);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = new Preferences();
        return preferences;
    }

    @Override
    public synchronized void addMetricListener(MetricListener metricListener, Metric metric) throws GATInvocationException {
        boolean found = false;
        for (int i = 0; i < this.metricTable.size(); ++i) {
            MetricNode n = this.metricTable.get(i);
            if (!n.definition.equals(metric.getDefinition())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new GATInvocationException();
        }
        this.metricListeners.add(new MetricListenerNode(metricListener, metric));
    }

    public void registerMetric(String methodName, MetricDefinition definition) {
        this.metricTable.add(new MetricNode(methodName, definition));
    }

    @Override
    public synchronized void removeMetricListener(MetricListener metricListener, Metric metric) throws GATInvocationException {
        if (!this.metricListeners.remove(new MetricListenerNode(metricListener, metric))) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public List<MetricDefinition> getMetricDefinitions() throws GATInvocationException {
        Vector<MetricDefinition> res = new Vector<MetricDefinition>();
        for (int i = 0; i < this.metricTable.size(); ++i) {
            res.add(this.metricTable.get((int)i).definition);
        }
        return res;
    }

    @Override
    public MetricEvent getMeasurement(Metric metric) throws GATInvocationException {
        if (metric.getDefinition().getMeasurementType() != 2) {
            throw new GATInvocationException("internal adaptor error: GATEngine.getMeasurement can only handle discrete metrics");
        }
        for (int i = 0; i < this.metricTable.size(); ++i) {
            MetricNode n = this.metricTable.get(i);
            if (!n.definition.equals(metric.getDefinition())) continue;
            if (n.lastValue == null) {
                throw new GATInvocationException("No data available for this metric");
            }
            return n.lastValue;
        }
        throw new GATInvocationException("No data available for this metric");
    }

    @Override
    public MetricDefinition getMetricDefinitionByName(String name) throws GATInvocationException {
        for (int i = 0; i < this.metricTable.size(); ++i) {
            MetricNode n = this.metricTable.get(i);
            if (!name.equals(n.definition.getMetricName())) continue;
            return n.definition;
        }
        throw new GATInvocationException("the metric name is incorrect: " + name);
    }

    public void fireMetric(MetricEvent v) {
        int i;
        MetricListenerNode[] listenerNodes = this.metricListeners.toArray(new MetricListenerNode[this.metricListeners.size()]);
        for (i = 0; i < listenerNodes.length; ++i) {
            if (!listenerNodes[i].metric.equals(v.getMetric())) continue;
            try {
                listenerNodes[i].metricListener.processMetricEvent(v);
                continue;
            }
            catch (Throwable t) {
                logger.warn("WARNING, user callback threw exception", t);
            }
        }
        for (i = 0; i < this.metricTable.size(); ++i) {
            MetricNode n = this.metricTable.get(i);
            if (!n.definition.equals(v.getMetric().getDefinition())) continue;
            n.setLastValue(v);
            return;
        }
        throw new Error("Internal error: event fired for non-registered metric");
    }
}

