/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.data.BindingDataManager;
import es.bsc.compss.exceptions.CopyException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.gat.master.GATAdaptor;
import es.bsc.compss.gat.master.exceptions.GATCopyException;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.copy.ImmediateCopy;
import es.bsc.compss.types.data.transferable.WorkersDebugInfoCopyTransferable;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInterface;

public class GATCopy
extends ImmediateCopy {
    private static final String ERR_NO_TGT_URI = "No valid target URIs";
    private static final String ERR_NO_SRC_URI = "No valid source URIs";
    private static final String DBG_PREFIX = "[GAT_COPY] ";
    private final Transferable reason;
    boolean isBindingObject = false;

    public GATCopy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, EventListener listener) {
        super(srcData, prefSrc, prefTgt, tgtData, reason, listener);
        MultiURI uri;
        String path;
        this.reason = reason;
        if (srcData.isBindingData() || reason != null && reason.getType().equals((Object)DataType.BINDING_OBJECT_T) || prefSrc != null && prefSrc.getType().equals((Object)LocationType.BINDING) || prefTgt != null && prefTgt.getType().equals((Object)LocationType.BINDING)) {
            this.isBindingObject = true;
        }
        Iterator iterator = prefTgt.getURIs().iterator();
        while (iterator.hasNext() && !(path = (uri = (MultiURI)iterator.next()).getPath()).startsWith(File.separator)) {
            Resource host = uri.getHost();
            try {
                if (this.isBindingObject) {
                    this.tgtLoc = DataLocation.createLocation((Resource)host, (SimpleURI)host.getCompleteRemotePath(DataType.BINDING_OBJECT_T, path));
                    continue;
                }
                this.tgtLoc = DataLocation.createLocation((Resource)host, (SimpleURI)host.getCompleteRemotePath(DataType.FILE_T, path));
            }
            catch (Exception e) {
                ErrorManager.error((String)("ERROR: Invalid location URI " + path), (Exception)e);
            }
        }
        LOGGER.debug("[GAT_COPY] GAT Specific Copy created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void specificCopy() throws CopyException {
        LOGGER.debug("[GAT_COPY] Performing GAT Specific Copy for " + this.getName());
        List targetURIs = this.tgtLoc.getURIs();
        LinkedList<URI> selectedTargetURIs = new LinkedList<URI>();
        for (MultiURI uri : targetURIs) {
            try {
                URI internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                if (internalURI == null) continue;
                selectedTargetURIs.add(internalURI);
            }
            catch (UnstartedNodeException une) {
                throw new GATCopyException((Exception)((Object)une));
            }
        }
        if (selectedTargetURIs.isEmpty()) {
            LOGGER.error("[GAT_COPY] No valid target URIs");
            throw new GATCopyException(ERR_NO_TGT_URI);
        }
        LOGGER.debug("[GAT_COPY] Selected target URIs");
        LinkedList<URI> selectedSourceURIs = new LinkedList<URI>();
        LogicalData une = this.srcData;
        synchronized (une) {
            URI internalURI;
            List sourceURIs;
            if (this.srcLoc != null) {
                LOGGER.debug("[GAT_COPY] SrcLoc: " + this.srcLoc);
                sourceURIs = this.srcLoc.getURIs();
                for (MultiURI uri : sourceURIs) {
                    try {
                        internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                        if (internalURI == null) continue;
                        selectedSourceURIs.add(internalURI);
                    }
                    catch (UnstartedNodeException une2) {
                        LOGGER.error("[GAT_COPY] Exception selecting source URI");
                        throw new GATCopyException((Exception)((Object)une2));
                    }
                }
            }
            LOGGER.debug("[GAT_COPY] SrcData: " + this.srcData);
            sourceURIs = this.srcData.getURIs();
            for (MultiURI uri : sourceURIs) {
                try {
                    internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                    if (internalURI == null) continue;
                    selectedSourceURIs.add(internalURI);
                }
                catch (UnstartedNodeException une3) {
                    LOGGER.error("[GAT_COPY] Exception selecting source URI for " + this.getName());
                    throw new GATCopyException((Exception)((Object)une3));
                }
            }
            if (selectedSourceURIs.isEmpty()) {
                if (this.srcData.isInMemory()) {
                    LOGGER.debug("[GAT_COPY] Data for " + this.getName() + " is in memory");
                    try {
                        this.srcData.writeToStorage();
                        sourceURIs = this.srcData.getURIs();
                        for (MultiURI uri : sourceURIs) {
                            internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                            if (internalURI == null) continue;
                            selectedSourceURIs.add(internalURI);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.fatal("[GAT_COPY] Exception writing object to file.", (Throwable)e);
                        throw new GATCopyException(ERR_NO_SRC_URI);
                    }
                } else {
                    LOGGER.error("[GAT_COPY] No valid source URIs");
                    throw new GATCopyException(ERR_NO_SRC_URI);
                }
            }
        }
        GATInvocationException exception = new GATInvocationException("default logical file");
        for (URI src : selectedSourceURIs) {
            for (URI tgt : selectedTargetURIs) {
                block32: {
                    try {
                        int result;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[GAT_COPY] Converting URIs From: " + src + " to " + tgt + " to GAT format");
                        }
                        String srcPath = src.getPath();
                        int boType = 0;
                        int boElements = 0;
                        if (this.isBindingObject && srcPath.contains("#")) {
                            BindingObject bo = BindingObject.generate((String)srcPath);
                            srcPath = bo.getId();
                            boType = bo.getType();
                            boElements = bo.getElements();
                        }
                        URI gatSrc = new URI(ProtocolType.ANY_URI.getSchema() + src.getHost() + "/" + srcPath);
                        String tgtPath = tgt.getPath();
                        if (this.isBindingObject && tgtPath.contains("#")) {
                            BindingObject bo = BindingObject.generate((String)tgtPath);
                            tgtPath = bo.getId();
                            boType = bo.getType();
                            boElements = bo.getElements();
                        }
                        URI gatTgt = new URI(ProtocolType.ANY_URI.getSchema() + tgt.getHost() + "/" + tgtPath);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[GAT_COPY] Copying file From: " + gatSrc + " to " + gatTgt);
                        }
                        this.doCopy(gatSrc, gatTgt);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[GAT_COPY] File " + gatTgt + " copied.");
                        }
                        if (!this.isBindingObject || !tgt.getHost().equals(Comm.getAppHost().getName())) break block32;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[GAT_COPY] Loading Binding object from " + tgtPath + " with id: " + this.getName() + " type: " + boType + " elements: " + boElements);
                        }
                        if ((result = BindingDataManager.loadFromFile((String)this.getName(), (String)tgtPath, (int)boType, (int)boElements)) != 0) {
                            LOGGER.error("Error loading object to cache from file " + tgtPath);
                            throw new Exception("Error loading object to cache from file " + tgtPath);
                        }
                    }
                    catch (Exception e) {
                        exception.add("default logical file", e);
                        LOGGER.warn("[GAT_COPY] Error copying file", (Throwable)e);
                        continue;
                    }
                }
                return;
            }
        }
        if (!(this.reason instanceof WorkersDebugInfoCopyTransferable)) {
            ErrorManager.error((String)("File '" + this.srcData.getName() + "' could not be copied because it does not exist."), (Exception)exception);
        }
        throw new GATCopyException(exception);
    }

    private void doCopy(URI src, URI dest) throws GATCopyException {
        FileInterface f = null;
        LOGGER.debug("RawPath: " + src.getRawPath());
        LOGGER.debug("isLocal: " + src.isLocal());
        if (src.isLocal() && !new File(src.getRawPath()).exists()) {
            String errorMessage = null;
            if (this.reason instanceof WorkersDebugInfoCopyTransferable) {
                errorMessage = "Workers Debug Information not supported in GAT Adaptor";
                LOGGER.warn(errorMessage);
            } else {
                errorMessage = "File '" + src.toString() + "' could not be copied to '" + dest.toString() + "' because it does not exist.";
                ErrorManager.warn((String)errorMessage);
                LOGGER.warn(errorMessage);
            }
            throw new GATCopyException(errorMessage);
        }
        try {
            f = GAT.createFile(GATAdaptor.getTransferContext(), src).getFileInterface();
            f.copy(dest);
        }
        catch (GATInvocationException | GATObjectCreationException e) {
            throw new GATCopyException(e);
        }
    }
}

