/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master;

import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.comm.Dispatcher;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.gat.master.GATJob;
import es.bsc.compss.gat.master.GATWorkerNode;
import es.bsc.compss.gat.master.configuration.GATConfiguration;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import es.bsc.conn.types.StarterCommand;
import java.io.File;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.URI;

public class GATAdaptor
implements CommAdaptor {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final String THREAD_POOL_ERR = "Error starting pool of threads";
    protected static final String POOL_ERR = "Error deleting pool of threads";
    public static final String ID = GATAdaptor.class.getCanonicalName();
    protected static final String POOL_NAME = "FTM";
    private static final int GAT_POOL_SIZE = 5;
    protected static final String SAFE_POOL_NAME = "SAFE_FTM";
    protected static final int SAFE_POOL_SIZE = 1;
    private static RequestQueue<DataOperation> copyQueue;
    private static RequestQueue<DataOperation> safeQueue;
    protected static ThreadPool pool;
    protected static ThreadPool safePool;
    private static String masterUser;
    private static GATContext transferContext;

    public void init() {
        copyQueue = new RequestQueue();
        safeQueue = new RequestQueue();
        if (DEBUG) {
            LOGGER.debug("Initializing GAT");
        }
        pool = new ThreadPool(5, POOL_NAME, (RequestDispatcher)new Dispatcher(copyQueue));
        try {
            pool.startThreads();
        }
        catch (Exception e) {
            ErrorManager.error((String)THREAD_POOL_ERR, (Exception)e);
        }
        safePool = new ThreadPool(1, SAFE_POOL_NAME, (RequestDispatcher)new Dispatcher(safeQueue));
        try {
            safePool.startThreads();
        }
        catch (Exception e) {
            ErrorManager.error((String)THREAD_POOL_ERR, (Exception)e);
        }
        if (DEBUG) {
            LOGGER.debug("Initializing GAT Tranfer Context");
        }
        transferContext = new GATContext();
        String adaptor = System.getProperty("gat.file.adaptor");
        transferContext.addPreference("File.adaptor.name", adaptor + ", srcToLocalToDestCopy, local");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration constructConfiguration(Map<String, Object> projectProperties, Map<String, Object> resourcesProperties) throws ConstructConfigurationException {
        String resourcesBrokerAdaptor;
        String brokerAdaptorName = System.getProperty("gat.broker.adaptor");
        String projectBrokerAdaptor = projectProperties != null ? (String)projectProperties.get("BrokerAdaptor") : null;
        String string = resourcesBrokerAdaptor = resourcesProperties != null ? (String)resourcesProperties.get("BrokerAdaptor") : null;
        if (projectBrokerAdaptor != null) {
            if (resourcesBrokerAdaptor != null) {
                if (!projectBrokerAdaptor.equals(resourcesBrokerAdaptor)) throw new ConstructConfigurationException("GATAdaptor: BrokerAdaptor defined in resources.xml and project.xml donesn't match");
                brokerAdaptorName = projectBrokerAdaptor;
                return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
            } else {
                brokerAdaptorName = projectBrokerAdaptor;
            }
            return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
        } else if (resourcesBrokerAdaptor != null) {
            brokerAdaptorName = resourcesBrokerAdaptor;
            return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
        } else {
            LOGGER.debug("GAT Broker Adaptor not specified. Setting default value " + brokerAdaptorName);
        }
        return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
    }

    public GATWorkerNode initWorker(Configuration config, NodeMonitor monitor) {
        GATConfiguration gatCfg = (GATConfiguration)config;
        LOGGER.debug("Init GAT Worker Node named " + gatCfg.getHost());
        GATWorkerNode node = new GATWorkerNode((GATConfiguration)config, monitor);
        return node;
    }

    public static void addTransferContextPreferences(String name, String value) {
        transferContext.addPreference(name, value);
    }

    public LinkedList<DataOperation> getPending() {
        LinkedList<DataOperation> l = new LinkedList<DataOperation>();
        for (DataOperation c : copyQueue.getQueue()) {
            l.add(c);
        }
        for (DataOperation c : safeQueue.getQueue()) {
            l.add(c);
        }
        return l;
    }

    public void stop() {
        try {
            pool.stopThreads();
            safePool.stopThreads();
        }
        catch (Exception e) {
            LOGGER.error(POOL_ERR, (Throwable)e);
        }
        GAT.end();
    }

    public void stopSubmittedJobs() {
        GATJob.stopAll();
    }

    public void completeMasterURI(MultiURI uri) {
        String scheme = uri.getProtocol().getSchema();
        String user = masterUser + "@";
        String host = uri.getHost().getName();
        String path = uri.getPath();
        if (!path.contains(File.separator)) {
            return;
        }
        String s = scheme + user + host + File.separator + path;
        try {
            uri.setInternalURI(ID, (Object)new URI(s));
        }
        catch (URISyntaxException e) {
            LOGGER.error("Exception", (Throwable)e);
        }
    }

    public static void enqueueCopy(Copy c) {
        copyQueue.enqueue((Object)c);
    }

    public static GATContext getTransferContext() {
        return transferContext;
    }

    public StarterCommand getStarterCommand(String workerName, int workerPort, String masterName, String workingDir, String installDir, String appDir, String classpathFromFile, String pythonpathFromFile, String libPathFromFile, int totalCPU, int totalGPU, int totalFPGA, int limitOfTasks, String hostId) {
        return null;
    }

    static {
        masterUser = System.getProperty("user.name");
    }
}

