/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master.utils;

import es.bsc.compss.gat.master.GATWorkerNode;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridlab.gat.GAT;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class GATScriptExecutor {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.FileTransferManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String THREAD_POOL_START_ERR = "Error starting pool of threads";
    private static final String THREAD_POOL_STOP_ERR = "Error stopping pool of threads";
    private static final String CLEAN_JOB_ERR = "Error running clean job";
    private static final String POOL_NAME = "Cleaner";
    private static final int POOL_SIZE = 5;
    private final GATWorkerNode node;
    private final RequestQueue<Job> jobQueue;
    private final RequestQueue<SoftwareDescription> sdQueue;
    private final ThreadPool pool;
    private int jobCount;

    public GATScriptExecutor(GATWorkerNode node) {
        this.node = node;
        this.jobQueue = new RequestQueue();
        this.sdQueue = new RequestQueue();
        this.pool = new ThreadPool(5, POOL_NAME, (RequestDispatcher)new ScriptDispatcher(this.sdQueue, this.jobQueue, node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeScript(List<URI> scripts, List<String> params, String stdOutFileName) {
        String line2;
        Throwable throwable;
        BufferedReader br2;
        Throwable throwable2;
        RequestQueue<Job> cleanParam;
        try {
            this.pool.startThreads();
        }
        catch (Exception e) {
            LOGGER.error(THREAD_POOL_START_ERR, (Throwable)e);
            return false;
        }
        RequestQueue<Job> e = this.jobQueue;
        synchronized (e) {
            this.jobCount = scripts.size();
        }
        for (int i = 0; i < scripts.size(); ++i) {
            URI script = scripts.get(i);
            cleanParam = params.get(i);
            if (script == null) continue;
            if (DEBUG) {
                LOGGER.debug("Clean call: " + script + " " + cleanParam);
            }
            try {
                String user;
                if (!this.node.isUserNeeded() && script.getUserInfo() != null) {
                    script.setUserInfo(null);
                }
                user = (user = script.getUserInfo()) == null ? "" : user + "@";
                SoftwareDescription sd = new SoftwareDescription();
                sd.addAttribute("uri", ProtocolType.ANY_URI.getSchema() + user + script.getHost());
                sd.setExecutable(script.getPath());
                sd.setArguments(cleanParam.split(" "));
                sd.addAttribute("job_number", i);
                sd.addAttribute("sandbox.root", File.separator + "tmp" + File.separator);
                sd.addAttribute("sandbox.useroot", "true");
                sd.addAttribute("sandbox.delete", "false");
                if (DEBUG) {
                    try {
                        org.gridlab.gat.io.File outFile = GAT.createFile(this.node.getContext(), ProtocolType.ANY_URI.getSchema() + File.separator + System.getProperty("compss.appLogDir") + File.separator + stdOutFileName + ".out");
                        sd.setStdout(outFile);
                        org.gridlab.gat.io.File errFile = GAT.createFile(this.node.getContext(), ProtocolType.ANY_URI.getSchema() + File.separator + System.getProperty("compss.appLogDir") + File.separator + stdOutFileName + ".err");
                        sd.setStderr(errFile);
                    }
                    catch (Exception e2) {
                        LOGGER.error(CLEAN_JOB_ERR, (Throwable)e2);
                    }
                }
                this.sdQueue.enqueue((Object)sd);
                continue;
            }
            catch (Exception e3) {
                LOGGER.error(CLEAN_JOB_ERR, (Throwable)e3);
                return false;
            }
        }
        Long timeout = System.currentTimeMillis() + 60000L;
        while (this.jobCount > 0 && System.currentTimeMillis() < timeout) {
            Job job = (Job)this.jobQueue.dequeue();
            if (job == null) {
                cleanParam = this.jobQueue;
                synchronized (cleanParam) {
                    --this.jobCount;
                    continue;
                }
            }
            if (job.getState() == Job.JobState.STOPPED) {
                cleanParam = this.jobQueue;
                synchronized (cleanParam) {
                    --this.jobCount;
                    continue;
                }
            }
            if (job.getState() == Job.JobState.SUBMISSION_ERROR) {
                LOGGER.error("Error running clean job: " + job);
                cleanParam = this.jobQueue;
                synchronized (cleanParam) {
                    --this.jobCount;
                    continue;
                }
            }
            this.jobQueue.enqueue((Object)job);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e4) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            this.pool.stopThreads();
        }
        catch (Exception e5) {
            LOGGER.error(THREAD_POOL_STOP_ERR, (Throwable)e5);
            return false;
        }
        if (DEBUG) {
            String stdOutFilePath = System.getProperty("compss.appLogDir") + File.separator + stdOutFileName + ".out";
            try {
                throwable2 = null;
                try (FileReader cleanOut = new FileReader(stdOutFilePath);){
                    br2 = new BufferedReader(cleanOut);
                    throwable = null;
                    try {
                        line2 = br2.readLine();
                        while (line2 != null) {
                            LOGGER.debug(line2);
                            line2 = br2.readLine();
                        }
                    }
                    catch (Throwable line2) {
                        throwable = line2;
                        throw line2;
                    }
                    finally {
                        if (br2 != null) {
                            if (throwable != null) {
                                try {
                                    br2.close();
                                }
                                catch (Throwable line2) {
                                    throwable.addSuppressed(line2);
                                }
                            } else {
                                br2.close();
                            }
                        }
                    }
                }
                catch (Throwable br2) {
                    throwable2 = br2;
                    throw br2;
                }
            }
            catch (IOException ioe) {
                LOGGER.error("Error moving std out file", (Throwable)ioe);
            }
            if (!new File(stdOutFilePath).delete()) {
                LOGGER.error("Error deleting out file " + stdOutFilePath);
            }
        }
        if (DEBUG) {
            String stdErrFilePath = System.getProperty("compss.appLogDir") + File.separator + stdOutFileName + ".err";
            try {
                throwable2 = null;
                try (FileReader cleanErr = new FileReader(stdErrFilePath);){
                    br2 = new BufferedReader(cleanErr);
                    throwable = null;
                    try {
                        line2 = br2.readLine();
                        while (line2 != null) {
                            LOGGER.error(line2);
                            line2 = br2.readLine();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (br2 != null) {
                            if (throwable != null) {
                                try {
                                    br2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                br2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            catch (IOException ioe) {
                LOGGER.error("Error moving std err file", (Throwable)ioe);
            }
            if (!new File(stdErrFilePath).delete()) {
                LOGGER.error("Error deleting err file " + stdErrFilePath);
            }
        }
        return true;
    }

    private class ScriptDispatcher
    extends RequestDispatcher<SoftwareDescription> {
        private RequestQueue<Job> jobQueue;
        private GATWorkerNode node;

        public ScriptDispatcher(RequestQueue<SoftwareDescription> sdQueue, RequestQueue<Job> jobQueue, GATWorkerNode node) {
            super(sdQueue);
            this.jobQueue = jobQueue;
            this.node = node;
        }

        public void processRequests() {
            SoftwareDescription sd;
            while ((sd = (SoftwareDescription)this.queue.dequeue()) != null) {
                try {
                    URI brokerURI = new URI((String)sd.getObjectAttribute("uri"));
                    ResourceBroker broker = GAT.createResourceBroker(this.node.getContext(), brokerURI);
                    Job job = broker.submitJob(new JobDescription(sd));
                    this.jobQueue.enqueue((Object)job);
                }
                catch (Exception e) {
                    LOGGER.error("Error submitting clean job", (Throwable)e);
                    this.jobQueue.enqueue((Object)null);
                }
            }
        }
    }
}

