/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

public class Queue {
    QueueNode head;
    QueueNode tail;
    int size;

    public synchronized void enqueue(Object o) {
        QueueNode node = new QueueNode();
        node.data = o;
        if (this.tail == null) {
            this.head = node;
        } else {
            this.tail.next = node;
        }
        this.tail = node;
        ++this.size;
        this.notify();
    }

    public synchronized Object dequeue() {
        return this.dequeue(0L);
    }

    public synchronized Object dequeue(long deadline) {
        while (this.head == null) {
            if (deadline == -1L) {
                return null;
            }
            if (deadline == 0L) {
                try {
                    this.wait();
                }
                catch (Exception e) {}
                continue;
            }
            long time = System.currentTimeMillis();
            if (time >= deadline) {
                return null;
            }
            try {
                this.wait(deadline - time);
            }
            catch (Exception e) {}
        }
        QueueNode result = this.head;
        this.head = result.next;
        if (this.head == null) {
            this.tail = null;
        }
        --this.size;
        return result.data;
    }

    public synchronized int size() {
        return this.size;
    }

    static class QueueNode {
        QueueNode next;
        Object data;

        QueueNode() {
        }
    }
}

