/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.cpi.FileCpi;
import org.gridlab.gat.resources.cpi.StagedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreStagedFile
extends StagedFile {
    protected static Logger logger = LoggerFactory.getLogger(PreStagedFile.class);
    private boolean isExecutable;
    private boolean isStdIn;
    private String exe;

    public PreStagedFile() {
    }

    public PreStagedFile(GATContext context, File src, File dest, String authority, String sandbox, boolean isStdIn, String exe) throws GATInvocationException {
        super(context, src, dest, authority, sandbox);
        this.isStdIn = isStdIn;
        this.exe = exe;
        this.resolve();
    }

    public String getExe() {
        return this.exe;
    }

    public void setExe(String exe) {
        this.exe = exe;
    }

    public boolean isExecutable() {
        return this.isExecutable;
    }

    public void setExecutable(boolean isExecutable) {
        this.isExecutable = isExecutable;
    }

    public boolean isStdIn() {
        return this.isStdIn;
    }

    public void setStdIn(boolean isStdIn) {
        this.isStdIn = isStdIn;
    }

    private void resolve() throws GATInvocationException {
        this.setResolvedSrc(this.origSrc);
        if (this.origDest != null) {
            this.inSandbox = !this.origDest.isAbsolute();
            this.setResolvedDest(this.resolve(this.origDest, false));
        } else {
            this.inSandbox = true;
            this.setResolvedDest(this.resolve(this.origSrc, true));
        }
        if (this.inSandbox) {
            if (this.exe == null) {
                this.isExecutable = false;
                return;
            }
            if (this.exe.startsWith("/")) {
                this.isExecutable = false;
                return;
            }
            if (this.getResolvedSrc().isFile() && this.relativeURI.getPath().equals(this.exe)) {
                this.isExecutable = true;
            }
        } else if (this.getResolvedSrc().isFile() && this.getResolvedDest().getPath().equals(this.exe)) {
            this.isExecutable = true;
        }
    }

    protected void prestage() throws GATInvocationException {
        File resolvedDest = this.getResolvedDest();
        File resolvedSrc = this.getResolvedSrc();
        if (logger.isInfoEnabled()) {
            logger.info("prestage:\n  copy " + resolvedSrc.toGATURI() + " to " + resolvedDest.toGATURI());
        }
        if (this.origDest != null) {
            resolvedDest.getParentFile().mkdirs();
        }
        resolvedSrc.copy(resolvedDest.toGATURI());
    }

    protected void delete() throws GATInvocationException {
        if (this.inSandbox) {
            return;
        }
        if (this.getResolvedDest().isDirectory()) {
            if (logger.isInfoEnabled()) {
                logger.info("DELETE_DIR:" + this.getResolvedDest());
            }
            FileCpi.recursiveDeleteDirectory(this.gatContext, this.getResolvedDest().getFileInterface());
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("DELETE_FILE:" + this.getResolvedDest());
            }
            this.getResolvedDest().delete();
        }
    }

    protected void wipe() throws GATInvocationException {
        if (logger.isInfoEnabled()) {
            logger.info("WIPE_FILE:" + this.getResolvedDest());
        }
        this.wipe(this.getResolvedDest());
    }

    public String toString() {
        return "PreStaged: " + this.getResolvedSrc().toGATURI() + " -> " + this.getResolvedDest().toGATURI() + (this.isStdIn ? " (STDIN)" : "") + (this.isExecutable ? " (EXE)" : "") + (this.inSandbox ? " (IN SANDBOX)" : " (OUTSIDE SANDBOX)");
    }
}

