/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.gat.master.GATWorkerNode;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.exceptions.LangNotDefinedException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.job.JobImpl;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.HardwareResourceDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class GATJob
extends JobImpl<GATWorkerNode>
implements MetricListener {
    private static final String WORKER_SCRIPT_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "gat" + File.separator;
    private static final String WORKER_SCRIPT_NAME = "worker.sh";
    private static final boolean IS_STORAGE_ENABLED = System.getProperty("compss.storage.conf") != null && !System.getProperty("compss.storage.conf").equals("") && !System.getProperty("compss.storage.conf").equals("null");
    private static final String STORAGE_CONF = IS_STORAGE_ENABLED ? System.getProperty("compss.storage.conf") : "null";
    private static final String PYTHON_INTERPRETER = System.getProperty("compss.python.interpreter") != null ? System.getProperty("compss.python.interpreter") : "python3";
    private static final String PYTHON_VERSION = System.getProperty("compss.python.version") != null ? System.getProperty("compss.python.version") : "3";
    private static final String PYTHON_VIRTUAL_ENVIRONMENT = System.getProperty("compss.python.virtualenvironment") != null ? System.getProperty("compss.python.virtualenvironment") : "null";
    private static final String PYTHON_PROPAGATE_VIRTUAL_ENVIRONMENT = System.getProperty("compss.python.propagate_virtualenvironment") != null ? System.getProperty("compss.python.propagate_virtualenvironment") : "true";
    private static final String PYTHON_CUSTOM_EXTRAE_FILE = System.getProperty("compss.extrae.file.python") != null ? System.getProperty("compss.extrae.file.python") : "null";
    private static final String JOBS_DIR = System.getProperty("compss.log.dir") + "jobs" + java.io.File.separator;
    private static final String JOB_STATUS = "job.status";
    private static final String RES_ATTR = "machine.node";
    private static final String CALLBACK_PROCESSING_ERR = "Error processing callback for job";
    private static final String TERM_ERR = "Error terminating";
    private static final List<GATJob> RUNNING_JOBS = new LinkedList<GATJob>();
    private Map<String, ResourceBroker> brokers = new TreeMap<String, ResourceBroker>();
    private Job gatJob;
    private final GATContext context;
    private final boolean usingGlobus;
    private final boolean userNeeded;
    private final List<String> slaveWorkersNodeNames;

    public GATJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, JobListener listener, GATContext context, boolean userNeeded, boolean usingGlobus, List<String> slaveWorkersNodeNames, List<Integer> predecessors, Integer numSuccessors) {
        super(taskId, taskParams, impl, res, listener, predecessors, numSuccessors);
        this.context = context;
        this.userNeeded = userNeeded;
        this.usingGlobus = usingGlobus;
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
    }

    public TaskType getType() {
        return TaskType.METHOD;
    }

    public void submitJob() throws Exception {
        LOGGER.info("Submit GATJob with ID " + this.jobId);
        JobDescription jobDescr = null;
        jobDescr = this.prepareJob();
        ResourceBroker broker = null;
        String dest = (String)jobDescr.getResourceDescription().getResourceAttribute(RES_ATTR);
        broker = this.brokers.get(dest);
        if (broker == null) {
            broker = GAT.createResourceBroker(this.context, new URI(dest));
            this.brokers.put(dest, broker);
        }
        Job job = null;
        try {
            job = broker.submitJob(jobDescr, this, JOB_STATUS);
            RUNNING_JOBS.add(this);
        }
        catch (Exception e) {
            if (Tracer.isActivated()) {
                SoftwareDescription sd = jobDescr.getSoftwareDescription();
                this.releaseTracingSlot(sd);
            }
            throw e;
        }
        this.gatJob = job;
    }

    private int acquireTracingSlot(SoftwareDescription sd) {
        String host = ((GATWorkerNode)this.getResourceNode()).getHost();
        int slot = Tracer.getNextSlot((String)host);
        sd.addAttribute("slot", slot);
        return slot;
    }

    private void releaseTracingSlot(SoftwareDescription sd) {
        Integer slot = (Integer)sd.getAttributes().get("slot");
        String host = ((GATWorkerNode)this.getResourceNode()).getHost();
        Tracer.freeSlot((String)host, (int)slot);
    }

    protected static void stopAll() {
        LOGGER.debug("GAT stopping all jobs");
        for (GATJob job : RUNNING_JOBS) {
            try {
                job.cancelJob();
            }
            catch (Exception e) {
                LOGGER.error(TERM_ERR, (Throwable)e);
            }
        }
    }

    public void cancelJob() throws Exception {
        LOGGER.debug("GAT stop job " + this.jobId);
        if (this.gatJob != null) {
            MetricDefinition md = this.gatJob.getMetricDefinitionByName(JOB_STATUS);
            Metric m = md.createMetric();
            this.gatJob.removeMetricListener(this, m);
            this.gatJob.stop();
        }
    }

    private JobDescription prepareJob() throws Exception {
        LOGGER.debug("Preparing GAT Job " + this.jobId);
        TaskDescription taskParams = this.taskParams;
        String targetPath = ((GATWorkerNode)this.getResourceNode()).getInstallDir();
        String targetUser = ((GATWorkerNode)this.getResourceNode()).getUser();
        targetUser = this.userNeeded && !targetUser.isEmpty() ? targetUser + "@" : "";
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable(targetPath + WORKER_SCRIPT_PATH + WORKER_SCRIPT_NAME);
        ArrayList<String> lArgs = new ArrayList<String>();
        GATWorkerNode resource = (GATWorkerNode)this.getResourceNode();
        lArgs.add(resource.getName());
        lArgs.add(resource.getInstallDir());
        lArgs.add(resource.getAppDir());
        lArgs.add(resource.getEnvScriptPath());
        lArgs.add(resource.getLibPath());
        lArgs.add(resource.getWorkingDir());
        lArgs.add(STORAGE_CONF);
        lArgs.add(Comm.getStreamingBackend().name());
        lArgs.add(Comm.getAppHost().getName());
        lArgs.add(String.valueOf(Comm.getStreamingPort()));
        lArgs.add(String.valueOf(DEBUG));
        List obsoleteFiles = this.getResource().pollObsoletes();
        if (obsoleteFiles != null) {
            lArgs.add("" + obsoleteFiles.size());
            for (MultiURI u : obsoleteFiles) {
                String renaming = u.getPath();
                lArgs.add(renaming);
            }
        } else {
            lArgs.add("0");
        }
        lArgs.add(Boolean.toString(Tracer.isActivated()));
        if (Tracer.isActivated()) {
            lArgs.add(String.valueOf(TraceEventType.RUNTIME.code));
            lArgs.add(String.valueOf(TraceEvent.CREATING_TASK_SANDBOX.getId()));
            lArgs.add(String.valueOf(TraceEvent.REMOVING_TASK_SANDBOX.getId()));
            lArgs.add(String.valueOf(TraceEventType.TASKS_FUNC.code));
            lArgs.add(String.valueOf(this.taskId));
            int slot = this.acquireTracingSlot(sd);
            lArgs.add(String.valueOf(slot));
        }
        AbstractMethodImplementation absImpl = (AbstractMethodImplementation)this.impl;
        lArgs.add(String.valueOf(absImpl.getMethodType()));
        switch (absImpl.getMethodType()) {
            case METHOD: {
                COMPSsConstants.Lang lang = this.getLang();
                lArgs.add(lang.toString().toLowerCase());
                switch (lang) {
                    case JAVA: {
                        lArgs.add(this.getClasspath());
                        break;
                    }
                    case C: {
                        break;
                    }
                    case PYTHON: {
                        lArgs.add(this.getPythonpath());
                        lArgs.add(PYTHON_INTERPRETER);
                        lArgs.add(PYTHON_VERSION);
                        lArgs.add(PYTHON_VIRTUAL_ENVIRONMENT);
                        lArgs.add(PYTHON_PROPAGATE_VIRTUAL_ENVIRONMENT);
                        lArgs.add(PYTHON_CUSTOM_EXTRAE_FILE);
                        break;
                    }
                    case UNKNOWN: {
                        throw new LangNotDefinedException();
                    }
                }
                MethodDefinition methodImpl = (MethodDefinition)absImpl.getDefinition();
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName == null || methodName.isEmpty()) {
                    methodImpl.setAlternativeMethodName(taskParams.getName());
                }
                methodImpl.appendToArgs(lArgs, taskParams.getName());
                break;
            }
            case BINARY: {
                BinaryDefinition binaryImpl = (BinaryDefinition)absImpl.getDefinition();
                binaryImpl.appendToArgs(lArgs, null);
                break;
            }
            case MPI: {
                MPIDefinition mpiImpl = (MPIDefinition)absImpl.getDefinition();
                mpiImpl.appendToArgs(lArgs, null);
                break;
            }
            case COMPSs: {
                COMPSsDefinition compssImpl = (COMPSsDefinition)absImpl.getDefinition();
                compssImpl.appendToArgs(lArgs, null);
                break;
            }
            case DECAF: {
                DecafDefinition decafImpl = (DecafDefinition)absImpl.getDefinition();
                decafImpl.appendToArgs(lArgs, ((GATWorkerNode)this.getResourceNode()).getAppDir());
                break;
            }
            case MULTI_NODE: {
                MultiNodeDefinition multiNodeImpl = (MultiNodeDefinition)absImpl.getDefinition();
                multiNodeImpl.appendToArgs(lArgs, null);
                break;
            }
            case OMPSS: {
                OmpSsDefinition ompssImpl = (OmpSsDefinition)absImpl.getDefinition();
                ompssImpl.appendToArgs(lArgs, null);
                break;
            }
            case OPENCL: {
                OpenCLDefinition openclImpl = (OpenCLDefinition)absImpl.getDefinition();
                openclImpl.appendToArgs(lArgs, null);
                break;
            }
            case PYTHON_MPI: {
                PythonMPIDefinition pythonMPIImpl = (PythonMPIDefinition)absImpl.getDefinition();
                pythonMPIImpl.appendToArgs(lArgs, null);
                break;
            }
            case CONTAINER: {
                ContainerDefinition containerImpl = (ContainerDefinition)absImpl.getDefinition();
                containerImpl.appendToArgs(lArgs, null);
            }
        }
        lArgs.add(String.valueOf(this.jobId));
        lArgs.add(String.valueOf(this.taskId));
        lArgs.add(String.valueOf(this.getTimeOut()));
        lArgs.add(String.valueOf(this.slaveWorkersNodeNames.size()));
        lArgs.addAll(this.slaveWorkersNodeNames);
        lArgs.add(String.valueOf(((MethodResourceDescription)this.impl.getRequirements()).getTotalCPUComputingUnits()));
        int numReturns = taskParams.getNumReturns();
        int numParams = taskParams.getParameters().size();
        numParams -= numReturns;
        if (taskParams.hasTargetObject()) {
            --numParams;
        }
        lArgs.add(Integer.toString(numParams));
        lArgs.add(Boolean.toString(taskParams.hasTargetObject()));
        lArgs.add(Integer.toString(numReturns));
        for (Parameter param : taskParams.getParameters()) {
            lArgs.addAll(this.processParameter(param));
        }
        String[] arguments = new String[lArgs.size()];
        arguments = lArgs.toArray(arguments);
        try {
            sd.setArguments(arguments);
        }
        catch (NullPointerException e) {
            StringBuilder sb = new StringBuilder("Null argument parameter of job " + this.jobId + " " + absImpl.getMethodDefinition() + "\n");
            int i = 0;
            for (Parameter param : taskParams.getParameters()) {
                sb.append("Parameter ").append(i).append("\n");
                DataType type = param.getType();
                sb.append("\t Type: ").append(param.getType()).append("\n");
                switch (type) {
                    case FILE_T: 
                    case OBJECT_T: 
                    case STREAM_T: 
                    case BINDING_OBJECT_T: {
                        DependencyParameter dPar = (DependencyParameter)param;
                        DataAccessId dAccId = dPar.getDataAccessId();
                        sb.append("\t Target: ").append(dPar.getDataTarget()).append("\n");
                        if (type != DataType.OBJECT_T && type != DataType.STREAM_T && type != DataType.BINDING_OBJECT_T) break;
                        if (dAccId.isWrite()) {
                            sb.append("\t Direction: W").append("\n");
                            break;
                        }
                        sb.append("\t Direction: R").append("\n");
                        break;
                    }
                    case STRING_T: 
                    case STRING_64_T: {
                        BasicTypeParameter btParS = (BasicTypeParameter)param;
                        String value = btParS.getValue().toString();
                        int numSubStrings = value.split(" ").length;
                        sb.append("\t Num Substrings: ").append(Integer.toString(numSubStrings)).append("\n");
                        sb.append("\t Value:").append(value).append("\n");
                        break;
                    }
                    default: {
                        BasicTypeParameter btParB = (BasicTypeParameter)param;
                        sb.append("\t Value: ").append(btParB.getValue().toString()).append("\n");
                    }
                }
                ++i;
            }
            LOGGER.error(sb.toString());
            this.failed(JobEndStatus.SUBMISSION_FAILED);
        }
        sd.addAttribute("jobId", this.jobId);
        sd.addAttribute("walltime.max", absImpl.getRequirements().getWallClockLimit());
        if (absImpl.getRequirements().getHostQueues().size() > 0) {
            sd.addAttribute("job.queue", absImpl.getRequirements().getHostQueues().get(0));
        }
        sd.addAttribute("coreCount", absImpl.getRequirements().getTotalCPUComputingUnits());
        sd.addAttribute("gpuCount", absImpl.getRequirements().getTotalGPUComputingUnits());
        sd.addAttribute("fpgaCount", absImpl.getRequirements().getTotalFPGAComputingUnits());
        sd.addAttribute("memory.max", Float.valueOf(absImpl.getRequirements().getMemorySize()));
        sd.addAttribute("sandbox.root", ((GATWorkerNode)this.getResourceNode()).getWorkingDir());
        sd.addAttribute("sandbox.useroot", "true");
        sd.addAttribute("sandbox.delete", "false");
        if (DEBUG) {
            File outFile = GAT.createFile(this.context, ProtocolType.ANY_URI.getSchema() + File.separator + JOBS_DIR + "job" + this.jobId + "_" + this.getHistory() + ".out");
            sd.setStdout(outFile);
        }
        if (DEBUG || this.usingGlobus) {
            File errFile = GAT.createFile(this.context, ProtocolType.ANY_URI.getSchema() + File.separator + JOBS_DIR + "job" + this.jobId + "_" + this.getHistory() + ".err");
            sd.setStderr(errFile);
        }
        String targetHost = ((GATWorkerNode)this.getResourceNode()).getHost();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(RES_ATTR, ProtocolType.ANY_URI.getSchema() + targetUser + targetHost);
        attributes.put("Jobname", "compss_remote_job_" + this.jobId);
        HardwareResourceDescription rd = new HardwareResourceDescription(attributes);
        if (DEBUG) {
            LOGGER.debug("Ready to submit job " + this.jobId + ":");
            LOGGER.debug("  * Host: " + targetHost);
            LOGGER.debug("  * Executable: " + sd.getExecutable());
            StringBuilder sb = new StringBuilder("  - Arguments:");
            for (String arg : sd.getArguments()) {
                sb.append(" ").append(arg);
            }
            LOGGER.debug(sb.toString());
        }
        JobDescription jd = new JobDescription(sd, rd);
        return jd;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Job id: ").append(this.getJobId()).append("]");
        buffer.append(", ").append(this.taskParams.toString());
        GATWorkerNode node = (GATWorkerNode)this.getResourceNode();
        String host = node.getHost();
        String user = node.getUser();
        buffer.append(", [Target host: ").append(host).append("]");
        buffer.append(", [User: ").append(user).append("]]");
        return buffer.toString();
    }

    private LinkedList<String> processParameter(Parameter param) {
        LinkedList<String> paramDesc = new LinkedList<String>();
        DataType type = param.getType();
        paramDesc.add(Integer.toString(type.ordinal()));
        paramDesc.add(Integer.toString(param.getStream().ordinal()));
        String prefix = param.getPrefix();
        if (prefix == null || prefix.isEmpty()) {
            prefix = "null";
        }
        paramDesc.add(prefix);
        String paramName = param.getName();
        paramDesc.add(paramName == null ? "null" : (paramName.isEmpty() ? "null" : paramName));
        String conType = param.getContentType();
        paramDesc.add(conType == null ? "null" : (conType.isEmpty() ? "null" : conType));
        paramDesc.add(Double.toString(param.getWeight()));
        paramDesc.add(Boolean.toString(param.isKeepRename()));
        switch (type) {
            case FILE_T: 
            case EXTERNAL_STREAM_T: {
                DependencyParameter dFilePar = (DependencyParameter)param;
                String originalName = dFilePar.getOriginalName();
                paramDesc.add(originalName);
                paramDesc.add(dFilePar.getDataTarget());
                break;
            }
            case PSCO_T: 
            case EXTERNAL_PSCO_T: {
                LOGGER.error("GAT Adaptor does not support PSCO Types");
                this.failed(JobEndStatus.SUBMISSION_FAILED);
                break;
            }
            case OBJECT_T: 
            case STREAM_T: {
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                paramDesc.add(dPar.getDataTarget());
                if (dAccId.isWrite()) {
                    paramDesc.add("W");
                    break;
                }
                paramDesc.add("R");
                break;
            }
            case BINDING_OBJECT_T: {
                DependencyParameter dExtObjPar = (DependencyParameter)param;
                BindingObject bo = BindingObject.generate((String)dExtObjPar.getDataTarget());
                paramDesc.add(bo.getId());
                paramDesc.add(Integer.toString(bo.getType()));
                paramDesc.add(Integer.toString(bo.getElements()));
                break;
            }
            case STRING_T: {
                BasicTypeParameter btParS = (BasicTypeParameter)param;
                String value = btParS.getValue().toString();
                int numSubStrings = value.split(" ").length;
                paramDesc.add(Integer.toString(numSubStrings));
                paramDesc.add(value);
                break;
            }
            case STRING_64_T: {
                BasicTypeParameter btp = (BasicTypeParameter)param;
                byte[] decodedBytes = Base64.getDecoder().decode(btp.getValue().toString());
                String[] values = new String(decodedBytes).split(" ");
                paramDesc.add(Integer.toString(values.length));
                paramDesc.addAll(Arrays.asList(values));
                break;
            }
            default: {
                BasicTypeParameter btParB = (BasicTypeParameter)param;
                paramDesc.add(btParB.getValue().toString());
            }
        }
        return paramDesc;
    }

    @Override
    public void processMetricEvent(MetricEvent value) {
        block16: {
            Job job = (Job)value.getSource();
            Job.JobState newJobState = (Job.JobState)((Object)value.getValue());
            JobDescription jd = (JobDescription)job.getJobDescription();
            SoftwareDescription sd = jd.getSoftwareDescription();
            Integer jobId = (Integer)sd.getAttributes().get("jobId");
            LOGGER.debug("Processing job ID = " + jobId);
            if (newJobState == Job.JobState.STOPPED) {
                if (Tracer.isActivated()) {
                    this.releaseTracingSlot(sd);
                }
                try {
                    if (this.usingGlobus) {
                        File errFile = sd.getStderr();
                        File localFile = GAT.createFile(this.context, errFile.toGATURI());
                        if (localFile.length() > 0L) {
                            this.gatJob = null;
                            RUNNING_JOBS.remove(this);
                            ErrorManager.warn((String)"Error when creating file.");
                            this.failed(JobEndStatus.EXECUTION_FAILED);
                        } else {
                            if (!DEBUG) {
                                localFile.delete();
                            }
                            RUNNING_JOBS.remove(this);
                            this.completed();
                        }
                        break block16;
                    }
                    if (job.getExitStatus() == 0) {
                        RUNNING_JOBS.remove(this);
                        this.completed();
                        break block16;
                    }
                    this.gatJob = null;
                    RUNNING_JOBS.remove(this);
                    this.failed(JobEndStatus.EXECUTION_FAILED);
                }
                catch (Exception e) {
                    ErrorManager.fatal((String)("Error processing callback for job: " + this), (Exception)e);
                }
            } else if (newJobState == Job.JobState.SUBMISSION_ERROR) {
                if (Tracer.isActivated()) {
                    this.releaseTracingSlot(sd);
                }
                try {
                    if (this.usingGlobus && job.getInfo().get("resManError").equals("NO_ERROR")) {
                        RUNNING_JOBS.remove(this);
                        this.completed();
                    } else {
                        this.gatJob = null;
                        RUNNING_JOBS.remove(this);
                        this.failed(JobEndStatus.SUBMISSION_FAILED);
                    }
                }
                catch (GATInvocationException e) {
                    ErrorManager.fatal((String)("Error processing callback for job: " + this), (Exception)e);
                }
            }
        }
    }

    public void completed() {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        super.registerAllJobOutputsAsExpected();
        super.completed();
    }

    public void failed(JobEndStatus status) {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        if (this.isBeingCancelled()) {
            super.registerAllJobOutputsAsExpected();
        }
        switch (this.taskParams.getOnFailure()) {
            case IGNORE: 
            case CANCEL_SUCCESSORS: {
                super.registerAllJobOutputsAsExpected();
                break;
            }
            default: {
                this.removeTmpData();
            }
        }
        super.failed(status);
    }
}

