/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.resources.SoftwareDescription;

public class JavaSoftwareDescription
extends SoftwareDescription {
    public static final String JAVA_MAIN = "java.main";
    public static final String JAVA_OPTIONS = "java.options";
    public static final String JAVA_SYSTEM_PROPERTIES = "java.system.properties";
    public static final String JAVA_ARGUMENTS = "java.arguments";
    private String[] javaOptions;
    private Map<String, String> javaSystemProperties;
    private String javaMain;
    private String[] javaArguments;
    private String javaClassPath;

    public JavaSoftwareDescription() {
    }

    public JavaSoftwareDescription(Map<String, Object> attributes) {
        super(attributes);
        this.javaMain = (String)attributes.get(JAVA_MAIN);
        this.setJavaOptions((String[])attributes.get(JAVA_OPTIONS));
        this.javaSystemProperties = (Map)attributes.get(JAVA_SYSTEM_PROPERTIES);
        this.javaArguments = (String[])attributes.get(JAVA_ARGUMENTS);
        this.checkArguments();
    }

    private void checkArguments() {
        if (this.javaArguments != null) {
            for (int i = 0; i < this.javaArguments.length; ++i) {
                if (this.javaArguments[i] != null) continue;
                throw new NullPointerException("Argument " + i + " is null");
            }
        }
    }

    public String[] getJavaOptions() {
        return this.javaOptions;
    }

    public void setJavaOptions(String ... options) {
        this.javaOptions = options;
    }

    public Map<String, String> getJavaSystemProperties() {
        return this.javaSystemProperties;
    }

    public void setJavaSystemProperties(Map<String, String> systemProperties) {
        this.javaSystemProperties = systemProperties;
    }

    public void addJavaSystemProperty(String key, String value) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new HashMap<String, String>();
        }
        this.javaSystemProperties.put(key, value);
    }

    public String getJavaMain() {
        return this.javaMain;
    }

    public void setJavaMain(String main) {
        this.javaMain = main;
    }

    public String[] getJavaArguments() {
        return this.javaArguments;
    }

    public void setJavaArguments(String ... javaArguments) {
        this.javaArguments = javaArguments;
        this.checkArguments();
    }

    @Override
    public void setArguments(String ... arguments) {
    }

    @Override
    public String[] getArguments() {
        if (this.toWrapper) {
            return super.getArguments();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.getJavaOptions() != null) {
            for (String option : this.getJavaOptions()) {
                result.add(option);
            }
        }
        if (this.getJavaClassPath() != null) {
            result.add("-classpath");
            result.add(this.getJavaClassPath());
        }
        if (this.getJavaSystemProperties() != null) {
            Map<String, String> properties = this.getJavaSystemProperties();
            for (String key : properties.keySet()) {
                if (properties.get(key) == null) continue;
                result.add("-D" + key + "=" + properties.get(key));
            }
        }
        if (this.getJavaMain() == null) {
            return null;
        }
        result.add(this.getJavaMain());
        if (this.getJavaArguments() != null) {
            for (String javaArgument : this.getJavaArguments()) {
                result.add(javaArgument);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getExecutable() {
        if (super.getExecutable() == null) {
            return "java";
        }
        return super.getExecutable();
    }

    public String getJavaClassPath() {
        return this.javaClassPath;
    }

    public void setJavaClassPath(String javaClassPath) {
        this.javaClassPath = javaClassPath;
    }
}

