/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.resources.JavaSoftwareDescription;

public class WrapperSoftwareDescription
extends JavaSoftwareDescription {
    private static final long serialVersionUID = -8066795059038763966L;
    private String gatLocation;

    public WrapperSoftwareDescription() {
        super.setJavaMain("org.gridlab.gat.resources.cpi.Wrapper");
    }

    @Override
    public void setJavaMain(String main) {
    }

    public void setGATLocation(String gatLocation) {
        this.gatLocation = gatLocation;
    }

    public String getGATLocation() {
        return this.gatLocation;
    }

    @Override
    public void setJavaClassPath(String classpath) {
    }

    @Override
    public String getJavaClassPath() {
        if (this.gatLocation == null) {
            return ".:lib/*";
        }
        if (this.gatLocation.startsWith("/")) {
            return ".:" + this.gatLocation + "/lib/*";
        }
        if (this.getStringAttribute("sandbox.root", null) != null) {
            throw new Error("If SANDBOX_ROOT is specified, the GAT location must be an absolute path");
        }
        if (this.getBooleanAttribute("sandbox.useroot", false)) {
            return ".:" + this.gatLocation + "/lib/*";
        }
        return ".:../" + this.gatLocation + "/lib/*";
    }

    @Override
    public Map<org.gridlab.gat.io.File, org.gridlab.gat.io.File> getPreStaged() {
        Map<org.gridlab.gat.io.File, org.gridlab.gat.io.File> result = super.getPreStaged();
        if (this.gatLocation == null) {
            if (result == null) {
                result = new HashMap<org.gridlab.gat.io.File, org.gridlab.gat.io.File>();
            }
            try {
                result.put(GAT.createFile(System.getenv("GAT_LOCATION") + File.separator + "lib"), GAT.createFile("."));
                result.put(GAT.createFile(System.getenv("GAT_LOCATION") + File.separator + "log4j.properties"), GAT.createFile("log4j.properties"));
            }
            catch (GATObjectCreationException gATObjectCreationException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getJavaSystemProperties() {
        Map<String, String> result = super.getJavaSystemProperties();
        if (result == null) {
            result = new HashMap<String, String>();
            super.setJavaSystemProperties(result);
            result = super.getJavaSystemProperties();
        }
        if (this.gatLocation == null) {
            result.put("log4j.configuration", "file:log4j.properties");
            result.put("gat.adaptor.path", "lib/adaptors");
        } else if (this.gatLocation.startsWith("/")) {
            result.put("log4j.configuration", "file:" + this.gatLocation + "/log4j.properties");
            result.put("gat.adaptor.path", this.gatLocation + "/lib/adaptors");
        } else {
            if (this.getStringAttribute("sandbox.root", null) != null) {
                throw new Error("If SANDBOX_ROOT is specified, the GAT location must be an absolute path");
            }
            if (this.getBooleanAttribute("sandbox.useroot", false)) {
                result.put("log4j.configuration", "file:" + this.gatLocation + "/log4j.properties");
                result.put("gat.adaptor.path", this.gatLocation + "/lib/adaptors");
            } else {
                result.put("log4j.configuration", "file:../" + this.gatLocation + "/log4j.properties");
                result.put("gat.adaptor.path", "../" + this.gatLocation + "/lib/adaptors");
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getEnvironment() {
        Map<String, Object> result = super.getEnvironment();
        if (result == null) {
            result = new HashMap<String, Object>();
            super.setEnvironment(result);
            result = super.getEnvironment();
        }
        if (result.containsKey("GAT_LOCATION")) {
            return result;
        }
        if (this.gatLocation == null) {
            result.put("GAT_LOCATION", ".");
        } else if (this.gatLocation.startsWith("/")) {
            result.put("GAT_LOCATION", this.gatLocation);
        } else {
            result.put("GAT_LOCATION", "../" + this.gatLocation);
        }
        return result;
    }
}

