/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine.util;

import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduledExecutor
implements RejectedExecutionHandler {
    private ScheduledThreadPoolExecutor executor = null;
    private HashMap<Runnable, Future<?>> map = null;
    private static ScheduledExecutor scheduledExecutor;

    public static synchronized void schedule(Runnable r, long initialDelay, long delay) {
        if (scheduledExecutor == null) {
            int sz = 16;
            String poolSize = System.getProperty("gat.threadpool.size");
            if (poolSize != null) {
                try {
                    sz = Integer.parseInt(poolSize);
                }
                catch (Throwable e) {
                    System.err.println("Warning: could not parse value of gat.threadpool.size property");
                }
            }
            scheduledExecutor = new ScheduledExecutor(sz);
        }
        scheduledExecutor.addJob(r, initialDelay, delay);
    }

    public static synchronized void schedule(Runnable r, long delay) {
        if (scheduledExecutor == null) {
            int sz = 16;
            String poolSize = System.getProperty("gat.threadpool.size");
            if (poolSize != null) {
                try {
                    sz = Integer.parseInt(poolSize);
                }
                catch (Throwable e) {
                    System.err.println("Warning: could not parse value of gat.threadpool.size property");
                }
            }
            scheduledExecutor = new ScheduledExecutor(sz);
        }
        scheduledExecutor.addJob(r, delay);
    }

    private ScheduledExecutor(int size) {
        this.executor = new ScheduledThreadPoolExecutor(size, new MyThreadFactory(), this);
        this.map = new HashMap();
    }

    private void addJob(Runnable r, long initialDelay, long delay) {
        this.map.put(r, this.executor.scheduleWithFixedDelay(r, initialDelay, delay, TimeUnit.MILLISECONDS));
    }

    private void addJob(Runnable r, long delay) {
        this.executor.schedule(r, delay, TimeUnit.MILLISECONDS);
    }

    private void shutdown() {
        this.executor.shutdownNow();
    }

    public static synchronized void end() {
        if (scheduledExecutor != null) {
            scheduledExecutor.shutdown();
        }
    }

    private void cancel(Runnable r) {
        Future<?> f = this.map.get(r);
        if (f != null) {
            f.cancel(true);
            this.map.remove(r);
        }
        this.executor.remove(r);
    }

    public static synchronized void remove(Runnable r) {
        if (scheduledExecutor != null) {
            scheduledExecutor.cancel(r);
        }
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        System.err.println("Warning: rejected scheduled execution of " + r);
        this.map.remove(r);
    }

    static class MyThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";

        MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

