/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.security.ssh;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.InvalidUsernameOrPasswordException;
import org.gridlab.gat.URI;
import org.gridlab.gat.security.cpi.SecurityContextUtils;
import org.gridlab.gat.security.ssh.SshContextCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSecurityUtils {
    public static final int SSH_PORT = 22;
    protected static Logger logger = LoggerFactory.getLogger(SshSecurityUtils.class);
    private static String defaultPrivateKeyfile = null;
    private static boolean didDefaultPrivateKeyfile = false;

    public static Map<String, String> getSecurityInfo(GATContext gatContext, URI brokerURI, String adaptorName, int ssh_port) throws GATObjectCreationException {
        Map securityInfo;
        try {
            securityInfo = (Map)SecurityContextUtils.getSecurityUserData(gatContext, adaptorName, "ssh", brokerURI, ssh_port, new SshContextCreator());
        }
        catch (Throwable e) {
            logger.info("SshPbsResourceBrokerAdaptor: failed to retrieve credentials", e);
            throw new GATObjectCreationException("Unable to retrieve user info for authentication", e);
        }
        if (securityInfo == null) {
            throw new GATObjectCreationException("Unable to retrieve user info for authentication");
        }
        if (securityInfo.containsKey("privatekeyfile") && logger.isDebugEnabled()) {
            logger.debug("key file argument not supported yet");
        }
        return securityInfo;
    }

    protected static Map<String, String> getDefaultUserInfo(GATContext gatContext, URI location) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        HashMap<String, String> credential = new HashMap<String, String>();
        credential.put("privatekeyfile", SshSecurityUtils.getDefaultPrivateKeyfile(gatContext));
        credential.put("username", SecurityContextUtils.getUser(gatContext, null, location));
        credential.put("default", "");
        return credential;
    }

    private static synchronized String getDefaultPrivateKeyfile(GATContext context) {
        if (!didDefaultPrivateKeyfile) {
            didDefaultPrivateKeyfile = true;
            String keyfile = null;
            String home = System.getProperty("user.home");
            String fileSep = System.getProperty("file.separator");
            home = home == null ? "" : home + fileSep;
            keyfile = home + ".ssh" + fileSep + "id_dsa";
            File keyf = new File(keyfile);
            if (!(keyf.exists() || (keyf = new File(keyfile = home + ".ssh" + fileSep + "id_rsa")).exists() || (keyf = new File(keyfile = home + ".ssh" + fileSep + "identity")).exists() || (keyf = new File(keyfile = home + "ssh" + fileSep + "id_dsa")).exists() || (keyf = new File(keyfile = home + "ssh" + fileSep + "id_rsa")).exists() || (keyf = new File(keyfile = home + "ssh" + fileSep + "identity")).exists())) {
                keyfile = null;
            }
            defaultPrivateKeyfile = keyfile;
        }
        return defaultPrivateKeyfile;
    }
}

