/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi;

import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileOutputStreamInterface;
import org.gridlab.gat.monitoring.cpi.MonitorableCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileOutputStreamCpi
extends MonitorableCpi
implements FileOutputStreamInterface {
    protected static Logger logger = LoggerFactory.getLogger(FileOutputStreamCpi.class);
    protected GATContext gatContext;
    protected URI location;
    protected boolean append;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map<String, Boolean> capabilities = MonitorableCpi.getSupportedCapabilities();
        capabilities.put("close", false);
        capabilities.put("flush", false);
        capabilities.put("write", false);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = MonitorableCpi.getSupportedPreferences();
        preferences.put("FileOutputStream.adaptor.name", "<no default>");
        preferences.put("adaptors.local", "false");
        return preferences;
    }

    protected FileOutputStreamCpi(GATContext gatContext, URI location, Boolean append) {
        this.gatContext = gatContext;
        this.location = location;
        this.append = append;
        if (logger.isDebugEnabled()) {
            logger.debug("FileOutputStreamCpi: created stream with URI " + location);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileOutputStreamCpi)) {
            return false;
        }
        FileOutputStreamCpi s = (FileOutputStreamCpi)object;
        return this.location.equals(s.location);
    }

    @Override
    public void close() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void flush() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void write(byte[] arg0) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void write(int arg0) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        return this.location.toString();
    }
}

