/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;

public class Adaptor {
    String cpi;
    String adaptorName;
    Class<?> adaptorClass;
    private String[] schemes;

    public Adaptor(String cpiName, Class<?> adaptorClass, String[] schemes) {
        this.cpi = cpiName;
        this.adaptorName = adaptorClass.getName();
        this.adaptorClass = adaptorClass;
        this.schemes = schemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object newInstance(Class<?>[] parameterTypes, Object[] parameters) throws Throwable {
        Throwable t = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.adaptorClass.getClassLoader());
        try {
            Constructor<?> ctor = this.adaptorClass.getConstructor(parameterTypes);
            if (ctor == null) {
                throw new GATObjectCreationException("No correct contructor exists in adaptor");
            }
            if (parameters == null) {
                throw new GATObjectCreationException("Parameters array is null (internal error)");
            }
            Object obj = ctor.newInstance(parameters);
            return obj;
        }
        catch (InvocationTargetException e) {
            t = e.getTargetException();
        }
        catch (Throwable e) {
            t = e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
        throw t;
    }

    String getCpi() {
        return this.cpi;
    }

    String getName() {
        return this.adaptorName;
    }

    Class<?> getAdaptorClass() {
        return this.adaptorClass;
    }

    public String toString() {
        return this.getName();
    }

    public String getShortAdaptorClassName() {
        String shortAdaptorClassName = this.adaptorClass.getName();
        int index = shortAdaptorClassName.lastIndexOf(".");
        if (index > 0) {
            shortAdaptorClassName = shortAdaptorClassName.substring(index + 1);
        }
        return shortAdaptorClassName;
    }

    public boolean matchScheme(URI param) {
        if (param == null) {
            return true;
        }
        if (this.schemes == null) {
            return true;
        }
        String scheme = param.getScheme();
        if (scheme == null) {
            scheme = "";
        }
        if (scheme.equalsIgnoreCase("any")) {
            return true;
        }
        for (String s : this.schemes) {
            if (!s.equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }
}

