/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import ibis.util.ThreadPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.FileWaiter;
import org.gridlab.gat.io.File;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wrapper {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final String WRAPPER_COMMON_DIR = "WRAPPER_COMMON_DIR";
    public static final String WRAPPER_START_TIME = "WRAPPER_START_TIME";
    private static Logger logger = LoggerFactory.getLogger(Wrapper.class);
    private URI initiator;
    private WrapperJobDescription.ScheduledType scheduledType;
    private int numberJobs;
    private int wrapperId;
    private int jobsDone;
    private URI triggerDirectory;
    private String wrapperCommonSrc;
    private String wrapperCommonDest;
    private final String startTime = this.dateFormatter.format(new Date());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            new Wrapper().start(args);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        finally {
            GAT.end();
        }
    }

    private String replaceEnv(String arg) {
        int start = 0;
        int index;
        while ((index = arg.indexOf("${", start)) >= 0) {
            int endIndex = arg.indexOf("}", index + 2);
            if (endIndex < 0) {
                return arg;
            }
            String target = arg.substring(index, endIndex + 1);
            String env = arg.substring(2, target.length() - 1);
            String replacement = System.getenv(env);
            if (replacement != null) {
                arg = arg.replace(target, replacement);
                start = index + replacement.length();
                continue;
            }
            start = index + 2;
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting JavaGAT Wrapper Application");
        }
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream("wrapper.info")));
        this.initiator = (URI)in.readObject();
        int level = in.readInt();
        this.wrapperId = in.readInt();
        this.wrapperCommonSrc = this.replaceEnv((String)in.readObject());
        this.wrapperCommonDest = this.replaceEnv((String)in.readObject());
        String wrapperCommonTrigger = this.replaceEnv((String)in.readObject());
        this.triggerDirectory = (URI)in.readObject();
        this.scheduledType = (WrapperJobDescription.ScheduledType)((Object)in.readObject());
        List infos = (List)in.readObject();
        in.close();
        if (logger.isDebugEnabled()) {
            logger.debug("original host:  " + this.initiator);
            logger.debug("debug level:    " + level);
            logger.debug("wrapperId:   " + this.wrapperId);
            logger.debug("triggerdir: " + this.triggerDirectory);
            logger.debug("staging type:   " + (Object)((Object)this.scheduledType));
            logger.debug("# wrapped jobs:" + infos.size());
            for (WrapperJobDescription.WrappedJobInfo info : infos) {
                logger.debug("  * " + info.getBrokerURI() + "\t" + info.getJobStateFileName() + "\t" + info.getPreferences() + "\t" + info.getJobDescription());
            }
        }
        this.numberJobs = infos.size();
        Preferences preferences = new Preferences();
        preferences.put("file.adaptor.name", "local");
        preferences.put("file.directory.copy", "contents");
        if (infos.size() != 0 && this.wrapperCommonSrc != null && this.wrapperCommonDest != null) {
            File wrapperCommonSrcFile = GAT.createFile(preferences, this.wrapperCommonSrc);
            this.wrapperCommonDest = this.wrapperCommonDest + java.io.File.separator + ".JavaGAT_SANDBOX_" + Math.random();
            java.io.File wrapperCommonDestFile = new java.io.File(this.wrapperCommonDest);
            if (!wrapperCommonDestFile.mkdirs()) {
                throw new Exception("Could not create directory " + this.wrapperCommonDest);
            }
            File triggerDir = GAT.createFile(((WrapperJobDescription.WrappedJobInfo)infos.get(0)).getPreferences(), this.triggerDirectory);
            if (triggerDir.exists()) {
                if (!triggerDir.isDirectory()) {
                    throw new Exception("specified trigger directory " + this.triggerDirectory + " exists and is not a directory");
                }
            } else if (!triggerDir.mkdirs()) {
                throw new Exception("could not create specified trigger directory " + this.triggerDirectory);
            }
            this.wrapperCommonDest = wrapperCommonDestFile.getPath();
            if ("true".equals(wrapperCommonTrigger)) {
                try {
                    FileWaiter w = FileWaiter.createFileWaiter(triggerDir);
                    w.waitFor("WrapperCommonTrigger." + this.wrapperId);
                    File file = GAT.createFile(((WrapperJobDescription.WrappedJobInfo)infos.get(0)).getPreferences(), this.triggerDirectory.setPath(this.triggerDirectory.getPath() + "/WrapperCommonTrigger." + this.wrapperId));
                    file.delete();
                }
                catch (Throwable e) {
                    logger.warn("Could not wait for trigger", e);
                }
            }
            wrapperCommonSrcFile.copy(new URI(this.wrapperCommonDest));
        } else {
            this.wrapperCommonDest = null;
        }
        for (int i = 0; i < infos.size(); ++i) {
            WrapperJobDescription.WrappedJobInfo info = (WrapperJobDescription.WrappedJobInfo)infos.get(i);
            if (this.scheduledType == WrapperJobDescription.ScheduledType.COORDINATED) {
                SoftwareDescription sd = info.getJobDescription().getSoftwareDescription();
                sd.addAttribute("triggerDirectory", this.triggerDirectory.toString());
            }
            ThreadPool.createNew(new Submitter(info, i), info.getJobStateFileName().getPath());
            if (i >= infos.size() - 1) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Wrapper i = this;
        synchronized (i) {
            while (this.jobsDone < this.numberJobs) {
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting for " + (this.numberJobs - this.jobsDone) + " jobs");
                }
                this.wait();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DONE!");
        }
        if (this.wrapperCommonDest != null) {
            File wrapperCommonDestFile = GAT.createFile(preferences, this.wrapperCommonDest);
            wrapperCommonDestFile.recursivelyDeleteDirectory();
        }
    }

    private AbstractJobDescription modify(Preferences prefs, AbstractJobDescription description, URI origin, int id) {
        File stdin;
        File stderr;
        Map<File, File> postStaged;
        Map<File, File> preStaged;
        if (!(description instanceof JobDescription)) {
            return description;
        }
        JobDescription jobDescription = (JobDescription)description;
        Map<String, Object> env = jobDescription.getSoftwareDescription().getEnvironment();
        if (env == null) {
            env = new HashMap<String, Object>();
            jobDescription.getSoftwareDescription().setEnvironment(env);
            env = jobDescription.getSoftwareDescription().getEnvironment();
        }
        env.put(WRAPPER_START_TIME, this.startTime);
        if (this.wrapperCommonDest != null) {
            env.put(WRAPPER_COMMON_DIR, this.wrapperCommonDest);
        }
        if ((preStaged = jobDescription.getSoftwareDescription().getPreStaged()) != null) {
            ArrayList<File> keys = new ArrayList<File>(preStaged.keySet());
            for (File file : keys) {
                if (!file.toGATURI().isCompatible("file") || !file.toGATURI().refersToLocalHost()) continue;
                File target = preStaged.get(file);
                preStaged.remove(file);
                try {
                    preStaged.put(GAT.createFile(prefs, Wrapper.rewriteURI(file.toGATURI(), origin)), target);
                }
                catch (GATObjectCreationException e) {
                    logger.error("Got Exception", e);
                }
            }
        }
        if ((postStaged = jobDescription.getSoftwareDescription().getPostStaged()) != null) {
            ArrayList<File> keys = new ArrayList<File>(postStaged.keySet());
            for (File file : keys) {
                File target = postStaged.get(file);
                if (target == null) {
                    try {
                        postStaged.put(file, GAT.createFile(prefs, origin + "/" + file.getName()));
                    }
                    catch (GATObjectCreationException e) {
                        logger.error("Got Exception", e);
                    }
                    continue;
                }
                if (!target.toGATURI().refersToLocalHost()) continue;
                postStaged.remove(file);
                try {
                    postStaged.put(file, GAT.createFile(prefs, Wrapper.rewriteURI(target.toGATURI(), origin)));
                }
                catch (GATObjectCreationException e) {
                    logger.error("Got Exception", e);
                }
            }
        }
        java.io.File sandbox = new java.io.File(".");
        String sandboxPath = sandbox.getAbsolutePath();
        File stdout = jobDescription.getSoftwareDescription().getStdout();
        String jobName = jobDescription.getSoftwareDescription().getStringAttribute("job.name", null);
        if (stdout != null) {
            String outName = jobName == null ? ".stdout_" + id : jobName + ".stdout";
            try {
                File out = GAT.createFile(prefs, new URI(sandboxPath + "/" + outName));
                jobDescription.getSoftwareDescription().setStdout(out);
                postStaged.put(out, GAT.createFile(prefs, Wrapper.rewriteURI(stdout.toGATURI(), origin)));
            }
            catch (Throwable e) {
                logger.error("Got Exception", e);
            }
        }
        if ((stderr = jobDescription.getSoftwareDescription().getStderr()) != null) {
            String errName = jobName == null ? ".stderr_" + id : jobName + ".stderr";
            try {
                File err = GAT.createFile(prefs, new URI(sandboxPath + "/" + errName));
                jobDescription.getSoftwareDescription().setStderr(err);
                postStaged.put(err, GAT.createFile(prefs, Wrapper.rewriteURI(stderr.toGATURI(), origin)));
            }
            catch (Throwable e) {
                logger.error("Got Exception", e);
            }
        }
        if ((stdin = jobDescription.getSoftwareDescription().getStdin()) != null) {
            String inName = jobName == null ? ".stdin_" + id : jobName + ".stdin";
            try {
                File in = GAT.createFile(prefs, new URI(sandboxPath + "/" + inName));
                jobDescription.getSoftwareDescription().setStdin(in);
                preStaged.put(GAT.createFile(prefs, Wrapper.rewriteURI(stdin.toGATURI(), origin)), in);
            }
            catch (Throwable e) {
                logger.error("Got Exception", e);
            }
        }
        Map<String, Object> attributes = jobDescription.getSoftwareDescription().getAttributes();
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            String s = this.replaceEnv((String)e.getValue());
            if (logger.isDebugEnabled() && s != e.getValue()) {
                logger.debug("Replacing " + e.getValue() + " with " + s);
            }
            e.setValue(s);
        }
        return description;
    }

    static URI rewriteURI(URI uri, URI origin) {
        try {
            String auth;
            if (uri.isAbsolute() && (auth = uri.getAuthority()) != null && !"".equals(auth)) {
                return uri;
            }
            uri = uri.hasAbsolutePath() ? origin.setPath(uri.getPath()) : origin.setPath(origin.getPath() + "/" + uri.getPath());
        }
        catch (URISyntaxException e) {
            logger.error("Got Exception", e);
        }
        return uri;
    }

    class JobListener
    implements MetricListener {
        private URI filename;
        private Preferences prefs;

        public JobListener(WrapperJobDescription.WrappedJobInfo info) {
            this.filename = info.getJobStateFileName();
            this.prefs = info.getPreferences();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processMetricEvent(MetricEvent event) {
            ObjectOutputStream out = null;
            try {
                Class<?> e2;
                URI dest = this.filename;
                java.io.File tmp = java.io.File.createTempFile(".JavaGAT", "jobstate");
                tmp.createNewFile();
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tmp)));
                out.writeObject(((Job)event.getSource()).getInfo());
                out.flush();
                out.close();
                File remoteFile = GAT.createFile(this.prefs, dest);
                File localFile = GAT.createFile(this.prefs, tmp.getPath());
                int count = 0;
                while (count < 30) {
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        if (!remoteFile.exists()) {
                            break;
                        }
                    }
                    ++count;
                    try {
                        Thread.sleep(1000 + count * 100);
                    }
                    catch (InterruptedException e2) {}
                }
                count = 0;
                while (count < 30) {
                    try {
                        e2 = this.getClass();
                        synchronized (e2) {
                            localFile.copy(dest);
                        }
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("Created status file " + dest + " for event " + event);
                        break;
                    }
                    catch (Throwable e3) {
                        Thread.sleep(1000 + ++count * 100);
                    }
                }
                if (count >= 30) {
                    logger.error("Could not create job status file " + dest + " for event " + event);
                }
                tmp.delete();
                count = 0;
                while (count < 30) {
                    e2 = this.getClass();
                    synchronized (e2) {
                        if (!remoteFile.exists()) {
                            break;
                        }
                    }
                    ++count;
                    try {
                        Thread.sleep(1000 + 100 * count);
                    }
                    catch (InterruptedException e2) {}
                }
            }
            catch (GATObjectCreationException e) {
                logger.error("Got Exception", e);
            }
            catch (Throwable e) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        logger.error("Got Exception", e1);
                    }
                }
                logger.error("Got Exception", e);
            }
            if (event.getValue() == Job.JobState.STOPPED || event.getValue() == Job.JobState.SUBMISSION_ERROR) {
                Wrapper wrapper = Wrapper.this;
                synchronized (wrapper) {
                    Wrapper.this.jobsDone++;
                    Wrapper.this.notifyAll();
                }
            }
        }
    }

    class Submitter
    implements Runnable {
        private WrapperJobDescription.WrappedJobInfo info;
        private int wrappedId;

        public Submitter(WrapperJobDescription.WrappedJobInfo info, int wrappedId) {
            this.info = info;
            this.wrappedId = wrappedId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResourceBroker broker = null;
            Preferences prefs = this.info.getPreferences();
            try {
                broker = GAT.createResourceBroker(prefs, this.info.getBrokerURI());
            }
            catch (GATObjectCreationException e) {
                System.err.println("Could not create resource broker to submit wrapped job " + Wrapper.this.wrapperId);
                System.err.println("Its job description: " + this.info.getJobDescription());
                System.err.println("The exception: " + e);
                e.printStackTrace(System.err);
                Wrapper wrapper = Wrapper.this;
                synchronized (wrapper) {
                    Wrapper.this.jobsDone++;
                    Wrapper.this.notifyAll();
                }
                return;
            }
            try {
                broker.submitJob(Wrapper.this.modify(prefs, this.info.getJobDescription(), Wrapper.this.initiator, this.wrappedId), new JobListener(this.info), "job.status");
            }
            catch (GATInvocationException e) {
                System.err.println("Could not submit wrapped job " + Wrapper.this.wrapperId);
                System.err.println("Its job description: " + this.info.getJobDescription());
                System.err.println("The exception: " + e);
                e.printStackTrace(System.err);
                Wrapper wrapper = Wrapper.this;
                synchronized (wrapper) {
                    Wrapper.this.jobsDone++;
                    Wrapper.this.notifyAll();
                }
            }
        }
    }
}

