/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi;

import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.RandomAccessFile;
import org.gridlab.gat.io.RandomAccessFileInterface;
import org.gridlab.gat.monitoring.cpi.MonitorableCpi;

public abstract class RandomAccessFileCpi
extends MonitorableCpi
implements RandomAccessFileInterface {
    protected GATContext gatContext;
    protected URI location;
    protected String mode;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map<String, Boolean> capabilities = MonitorableCpi.getSupportedCapabilities();
        capabilities.put("toURI", true);
        capabilities.put("getFile", true);
        capabilities.put("close", false);
        capabilities.put("getFilePointer", false);
        capabilities.put("length", false);
        capabilities.put("read", false);
        capabilities.put("seek", false);
        capabilities.put("setLength", false);
        capabilities.put("skipBytes", false);
        capabilities.put("write", false);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = MonitorableCpi.getSupportedPreferences();
        preferences.put("RandomAccessFile.adaptor.name", "<no default>");
        preferences.put("adaptors.local", "false");
        return preferences;
    }

    public RandomAccessFileCpi(GATContext gatContext, URI location, String mode) {
        this.gatContext = gatContext;
        this.location = location;
        this.mode = mode;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof RandomAccessFile)) {
            return false;
        }
        RandomAccessFile rf = (RandomAccessFile)object;
        return this.location.equals(rf.toURI());
    }

    @Override
    public URI toURI() {
        return this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public File getFile() throws GATInvocationException {
        try {
            return GAT.createFile(this.gatContext, this.location);
        }
        catch (Exception e) {
            throw new GATInvocationException("random access file cpi", e);
        }
    }

    @Override
    public void close() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long getFilePointer() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long length() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int read() throws GATInvocationException {
        byte[] buf2 = new byte[1];
        int len = this.read(buf2);
        if (len <= 0) {
            return -1;
        }
        return buf2[0] & 0xFF;
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int read(byte[] arg0) throws GATInvocationException {
        return this.read(arg0, 0, arg0.length);
    }

    @Override
    public void seek(long arg0) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setLength(long arg0) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int skipBytes(int arg0) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void write(byte[] arg0) throws GATInvocationException {
        this.write(arg0, 0, arg0.length);
    }

    @Override
    public void write(int arg0) throws GATInvocationException {
        byte[] buf2 = new byte[]{(byte)arg0};
        this.write(buf2);
    }

    public String toString() {
        return this.location.toString();
    }
}

