/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    public TypedProperties() {
    }

    public TypedProperties(Properties defaults) {
        super(defaults);
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            this.setProperty(key, value);
        }
    }

    public void putAll(Properties properties) {
        this.addProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromClassPath(String resourceName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (inputStream != null) {
            try {
                this.load(inputStream);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e2) {}
            }
        }
    }

    public void expandSystemVariables() {
        Set<Object> keys = this.keySet();
        Pattern pattern = Pattern.compile("\\$\\{\\w+?\\}");
        for (Object key : keys) {
            Matcher matcher = pattern.matcher((String)this.get(key));
            while (matcher.find()) {
                String fullSystemVar = matcher.group();
                String strippedSystemVar = fullSystemVar.substring(2, fullSystemVar.length() - 1);
                if (System.getenv(strippedSystemVar) == null) continue;
                this.put(key, ((String)this.get(key)).replace(fullSystemVar, System.getenv(strippedSystemVar)));
                matcher = pattern.matcher((String)this.get(key));
            }
        }
    }

    public void loadFromFile(String fileName) {
        if (fileName == null) {
            return;
        }
        try {
            FileInputStream inputStream = new FileInputStream(fileName);
            try {
                this.load(inputStream);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void loadFromHomeFile(String fileName) {
        this.loadFromFile(System.getProperty("user.home") + File.separator + fileName);
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (value != null) {
            return value.equals("1") || value.equals("on") || value.equals("") || value.equals("true") || value.equals("yes");
        }
        return defaultValue;
    }

    public int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Integer expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Integer expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public long getLongProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Long expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public long getLongProperty(String key, long defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Long expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public short getShortProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Short expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public short getShortProperty(String key, short defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Short expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public double getDoubleProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Double expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public double getDoubleProperty(String key, double defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Double expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public float getFloatProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Float expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public float getFloatProperty(String key, float defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Float expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public long getSizeProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        return this.getSizeProperty(key, 0L);
    }

    public long getSizeProperty(String key, long defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value.endsWith("G") || value.endsWith("g")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 1024L * 1024L * 1024L;
            }
            if (value.endsWith("M") || value.endsWith("m")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 1024L * 1024L;
            }
            if (value.endsWith("K") || value.endsWith("k")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 1024L;
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Long[G|g|M|m|K|k] expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public String[] getStringList(String key) {
        return this.getStringList(key, "\\s*,\\s*", new String[0]);
    }

    public String[] getStringList(String key, String delim) {
        return this.getStringList(key, delim, new String[0]);
    }

    public String[] getStringList(String key, String delim, String[] defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.split(delim);
    }

    public boolean stringPropertyMatch(String key, String match) {
        String value = this.getProperty(key);
        return value != null && value.equals(match);
    }

    private static boolean contains(String[] list, String element) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!element.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(String string, String[] prefixes) {
        if (prefixes == null) {
            return false;
        }
        for (int i = 0; i < prefixes.length; ++i) {
            if (!string.startsWith(prefixes[i])) continue;
            return true;
        }
        return false;
    }

    public TypedProperties checkProperties(String prefix, String[] validKeys, String[] validSubPrefixes, boolean printWarning) {
        TypedProperties result = new TypedProperties();
        if (prefix == null) {
            prefix = "";
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String suffix = key.substring(prefix.length());
            String value = this.getProperty(key);
            if (TypedProperties.startsWith(suffix, validSubPrefixes) || TypedProperties.contains(validKeys, key)) continue;
            if (printWarning) {
                System.err.println("Warning, unknown property: " + key + " with value: " + value);
            }
            result.put(key, value);
        }
        return result;
    }

    public TypedProperties filter(String prefix, boolean removePrefix, boolean removeProperties) {
        TypedProperties result = new TypedProperties();
        if (prefix == null) {
            prefix = "";
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = this.getProperty(key);
            if (removePrefix) {
                result.put(key.substring(prefix.length()), value);
            } else {
                result.put(key, value);
            }
            if (!removeProperties) continue;
            this.remove(key);
        }
        return result;
    }

    public TypedProperties filter(String prefix) {
        return this.filter(prefix, false, false);
    }

    public void printProperties(PrintStream out, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            if (!key.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            out.println(key + " = " + value);
        }
    }

    public String toString() {
        String result = "";
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            result = result + key + " = " + value + "\n";
        }
        return result;
    }

    String[] getPropertyNames() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            list.add(key);
        }
        Object[] result = list.toArray(new String[list.size()]);
        Arrays.sort(result);
        return result;
    }

    public boolean equals(Object object) {
        String[] otherProps;
        if (!(object instanceof TypedProperties)) {
            return false;
        }
        TypedProperties other = (TypedProperties)object;
        String[] myProps = this.getPropertyNames();
        if (myProps.length != (otherProps = other.getPropertyNames()).length) {
            return false;
        }
        int i = 0;
        for (String key : myProps) {
            if (!key.equals(otherProps[i])) {
                return false;
            }
            ++i;
            String value = this.getProperty(key);
            String otherValue = other.getProperty(key);
            if (otherValue != null && otherValue.equals(value)) continue;
            return false;
        }
        return true;
    }
}

