/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.io.File;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.cpi.StagedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostStagedFile
extends StagedFile {
    protected static Logger logger = LoggerFactory.getLogger(PostStagedFile.class);
    private boolean isStdout;
    private boolean isStderr;

    public PostStagedFile() {
    }

    public PostStagedFile(GATContext context, org.gridlab.gat.io.File origSrc, org.gridlab.gat.io.File origDest, String authority, String sandbox, boolean isStdOut, boolean isStderr) throws GATInvocationException {
        super(context, origSrc, origDest, authority, sandbox);
        this.isStdout = isStdOut;
        this.isStderr = isStderr;
        this.inSandbox = this.inSandbox(origSrc.getPath());
        this.resolve();
    }

    private void resolve() throws GATInvocationException {
        this.setResolvedSrc(this.resolve(this.origSrc, false));
        String cwd = new File(System.getProperty("user.dir")).toURI().getPath();
        if (cwd == null) {
            throw new GATInvocationException("cannot get current working directory");
        }
        if (this.origDest == null) {
            try {
                URI resolvedDestURI = new URI("any:///" + cwd + this.origSrc.getName());
                this.setResolvedDest(GAT.createFile(this.gatContext, resolvedDestURI));
            }
            catch (Exception e) {
                throw new GATInvocationException("poststagedFile", e);
            }
        }
        URI destURI = this.origDest.toGATURI();
        if (this.origDest.isAbsolute() || destURI.isAbsolute()) {
            this.setResolvedDest(this.origDest);
        } else {
            try {
                String destURIString = "any:///" + cwd + this.origDest.getPath();
                this.setResolvedDest(GAT.createFile(this.origSrc.getFileInterface().getGATContext(), new URI(destURIString)));
            }
            catch (Exception e) {
                throw new GATInvocationException("poststagedFile", e);
            }
        }
    }

    protected void poststage() throws GATInvocationException {
        if (logger.isInfoEnabled()) {
            logger.info("  exists: " + this.getResolvedSrc().exists());
            logger.info("  copy " + this.getResolvedSrc().toGATURI() + " to " + this.getResolvedDest().toGATURI());
        }
        this.getResolvedSrc().copy(this.getResolvedDest().toGATURI());
    }

    protected void delete() throws GATInvocationException {
        if (this.inSandbox) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("DELETE_FILE: " + this.getResolvedSrc());
        }
        this.getResolvedSrc().delete();
    }

    protected void wipe() throws GATInvocationException {
        if (logger.isInfoEnabled()) {
            logger.info("WIPE_FILE:" + this.getResolvedSrc());
        }
        this.wipe(this.getResolvedSrc());
    }

    public String toString() {
        String srcURI = this.getResolvedSrc() == null ? "" : this.getResolvedSrc().toGATURI().toString();
        String destURI = this.getResolvedDest() == null ? "" : this.getResolvedDest().toGATURI().toString();
        return "PostStaged: " + srcURI + " -> " + destURI + (this.isStdout ? " (STDOUT)" : "") + (this.isStderr ? " (STDERR)" : "") + (this.inSandbox ? " (IN SANDBOX)" : " (OUTSIDE SANDBOX)");
    }

    public boolean isStderr() {
        return this.isStderr;
    }

    public void setStderr(boolean isStderr) {
        this.isStderr = isStderr;
    }

    public boolean isStdout() {
        return this.isStdout;
    }

    public void setStdout(boolean isStdout) {
        this.isStdout = isStdout;
    }
}

