/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master;

import es.bsc.compss.exceptions.CopyException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.gat.master.GATAdaptor;
import es.bsc.compss.gat.master.exceptions.GATCopyException;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.copy.ImmediateCopy;
import es.bsc.compss.types.data.transferable.WorkersDebugInfoCopyTransferable;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInterface;

public class GATCopy
extends ImmediateCopy {
    private static final String ERR_NO_TGT_URI = "No valid target URIs";
    private static final String ERR_NO_SRC_URI = "No valid source URIs";
    private static final String DBG_PREFIX = "[GAT_COPY] ";
    private final Transferable reason;

    public GATCopy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, EventListener listener) {
        super(srcData, prefSrc, prefTgt, tgtData, reason, listener);
        MultiURI uri;
        String path;
        this.reason = reason;
        Iterator<MultiURI> iterator = prefTgt.getURIs().iterator();
        while (iterator.hasNext() && !(path = (uri = iterator.next()).getPath()).startsWith(File.separator)) {
            Resource host = uri.getHost();
            try {
                this.tgtLoc = DataLocation.createLocation(host, host.getCompleteRemotePath(DataType.FILE_T, path));
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + path, e);
            }
        }
        LOGGER.debug("[GAT_COPY] GAT Specific Copy created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void specificCopy() throws CopyException {
        LOGGER.debug("[GAT_COPY] Performing GAT Specific Copy for " + this.getName());
        List<MultiURI> targetURIs = this.tgtLoc.getURIs();
        LinkedList<URI> selectedTargetURIs = new LinkedList<URI>();
        for (MultiURI uri : targetURIs) {
            try {
                URI internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                if (internalURI == null) continue;
                selectedTargetURIs.add(internalURI);
            }
            catch (UnstartedNodeException une) {
                throw new GATCopyException(une);
            }
        }
        if (selectedTargetURIs.isEmpty()) {
            LOGGER.error("[GAT_COPY] No valid target URIs");
            throw new GATCopyException(ERR_NO_TGT_URI);
        }
        LOGGER.debug("[GAT_COPY] Selected target URIs");
        LinkedList<URI> selectedSourceURIs = new LinkedList<URI>();
        LogicalData une = this.srcData;
        synchronized (une) {
            URI internalURI;
            List<MultiURI> sourceURIs;
            if (this.srcLoc != null) {
                sourceURIs = this.srcLoc.getURIs();
                for (MultiURI uri : sourceURIs) {
                    try {
                        internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                        if (internalURI == null) continue;
                        selectedSourceURIs.add(internalURI);
                    }
                    catch (UnstartedNodeException une2) {
                        LOGGER.error("[GAT_COPY] Exception selecting source URI");
                        throw new GATCopyException(une2);
                    }
                }
            }
            sourceURIs = this.srcData.getURIs();
            for (MultiURI uri : sourceURIs) {
                try {
                    internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                    if (internalURI == null) continue;
                    selectedSourceURIs.add(internalURI);
                }
                catch (UnstartedNodeException une3) {
                    LOGGER.error("[GAT_COPY] Exception selecting source URI for " + this.getName());
                    throw new GATCopyException(une3);
                }
            }
            if (selectedSourceURIs.isEmpty()) {
                if (this.srcData.isInMemory()) {
                    LOGGER.debug("Data for " + this.getName() + " is in memory");
                    try {
                        this.srcData.writeToStorage();
                        sourceURIs = this.srcData.getURIs();
                        for (MultiURI uri : sourceURIs) {
                            internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
                            if (internalURI == null) continue;
                            selectedSourceURIs.add(internalURI);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.fatal("Exception writing object to file.", (Throwable)e);
                        throw new GATCopyException(ERR_NO_SRC_URI);
                    }
                } else {
                    LOGGER.error("[GAT_COPY] No valid source URIs");
                    throw new GATCopyException(ERR_NO_SRC_URI);
                }
            }
        }
        GATInvocationException exception = new GATInvocationException("default logical file");
        for (URI src : selectedSourceURIs) {
            for (URI tgt : selectedTargetURIs) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("GATCopy From: " + src + " to " + tgt);
                    }
                    URI gatSrc = new URI(DataLocation.Protocol.ANY_URI.getSchema() + src.getHost() + "/" + src.getPath());
                    URI gatTgt = new URI(DataLocation.Protocol.ANY_URI.getSchema() + tgt.getHost() + "/" + tgt.getPath());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("GATCopy From: " + gatSrc + " to " + gatTgt);
                    }
                    this.doCopy(gatSrc, gatTgt);
                }
                catch (Exception e) {
                    exception.add("default logical file", e);
                    LOGGER.warn("Error copying file", (Throwable)e);
                    continue;
                }
                return;
            }
        }
        if (!(this.reason instanceof WorkersDebugInfoCopyTransferable)) {
            ErrorManager.error("File '" + this.srcData.getName() + "' could not be copied because it does not exist.", exception);
        }
        throw new GATCopyException(exception);
    }

    private void doCopy(URI src, URI dest) throws GATCopyException {
        FileInterface f = null;
        LOGGER.debug("RawPath: " + src.getRawPath());
        LOGGER.debug("isLocal: " + src.isLocal());
        if (src.isLocal() && !new File(src.getRawPath()).exists()) {
            String errorMessage = null;
            if (this.reason instanceof WorkersDebugInfoCopyTransferable) {
                errorMessage = "Workers Debug Information not supported in GAT Adaptor";
                LOGGER.warn(errorMessage);
            } else {
                errorMessage = "File '" + src.toString() + "' could not be copied to '" + dest.toString() + "' because it does not exist.";
                ErrorManager.warn(errorMessage);
                LOGGER.warn(errorMessage);
            }
            throw new GATCopyException(errorMessage);
        }
        try {
            f = GAT.createFile(GATAdaptor.getTransferContext(), src).getFileInterface();
            f.copy(dest);
        }
        catch (GATInvocationException | GATObjectCreationException e) {
            throw new GATCopyException(e);
        }
    }
}

