/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.persistent;

import es.bsc.compss.execution.types.ExecutorContext;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.external.persistent.PersistentMirror;
import es.bsc.compss.executor.types.ExternalTaskStatus;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import java.io.File;

public abstract class PersistentInvoker
extends ExternalInvoker {
    public PersistentInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        super.appendOtherExecutionCommandArguments();
    }

    @Override
    protected void invokeMethod() throws JobExecutionException {
        ExternalTaskStatus taskStatus;
        Integer exitValue;
        int jobId = this.invocation.getJobId();
        String taskCMD = this.command.getAsString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing in binding: " + taskCMD);
        }
        String results = PersistentInvoker.executeInBinding(taskCMD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result: " + results);
        }
        if ((exitValue = (taskStatus = new ExternalTaskStatus(results.split(" "))).getExitValue()) != 0) {
            throw new JobExecutionException("Job " + jobId + " has failed. Exit values is " + exitValue);
        }
        LOGGER.debug("Updating parameters for job " + jobId);
        for (int i = 0; i < taskStatus.getNumParameters(); ++i) {
            DataType paramType = taskStatus.getParameterType(i);
            if (!paramType.equals((Object)DataType.EXTERNAL_PSCO_T)) continue;
            String paramValue = taskStatus.getParameterValue(i);
            this.invocation.getParams().get(i).setType(DataType.EXTERNAL_PSCO_T);
            this.invocation.getParams().get(i).setValue(paramValue);
        }
        LOGGER.debug("Job " + jobId + " has finished with exit value 0");
    }

    public static native String executeInBinding(String var0);

    public static native void initThread();

    public static native void finishThread();

    public static PersistentMirror getMirror(InvocationContext context, ExecutorContext platform) {
        int threads = platform.getSize();
        return new PersistentMirror(context, threads);
    }

    static {
        System.loadLibrary("bindings_common");
    }
}

