/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class COMPSsDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 6;
    public static final String SIGNATURE = "compss.NESTED";
    private static final String DEFAULT_RUNCOMPSS = "runcompss";
    private static final String DEFAULT_FLAGS = "";
    private String runcompss;
    private String flags;
    private String appName;
    private String workerInMaster;
    private String workingDir;
    private boolean failByEV;
    private String parentAppId;

    public COMPSsDefinition() {
    }

    public COMPSsDefinition(String runcompss, String flags, String appName, String workerInMaster, String workingDir, boolean failByEV) {
        this.runcompss = runcompss != null && !runcompss.isEmpty() && !runcompss.equals("[unassigned]") ? runcompss : DEFAULT_RUNCOMPSS;
        this.flags = flags != null && !flags.isEmpty() && !flags.equals("[unassigned]") ? flags : DEFAULT_FLAGS;
        this.appName = appName;
        this.workerInMaster = workerInMaster;
        this.workingDir = workingDir;
        this.failByEV = failByEV;
        this.parentAppId = new File(System.getProperty("compss.appLogDir")).getName();
    }

    public COMPSsDefinition(String[] implTypeArgs, int offset) {
        this.runcompss = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.flags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        if (this.runcompss == null || this.runcompss.isEmpty() | this.runcompss.equals("[unassigned]")) {
            this.runcompss = DEFAULT_RUNCOMPSS;
        }
        if (this.flags == null || this.flags.isEmpty() || this.flags.equals("[unassigned]")) {
            this.flags = DEFAULT_FLAGS;
        }
        this.appName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.workerInMaster = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 4]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[5]);
        String appLogDir = System.getProperty("compss.appLogDir");
        if (appLogDir != null && !appLogDir.isEmpty()) {
            this.parentAppId = new File(System.getProperty("compss.appLogDir")).getName();
        }
        if (this.appName == null || this.appName.isEmpty()) {
            throw new IllegalArgumentException("Empty appName annotation for COMPSs method ");
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.runcompss);
        lArgs.add(this.flags);
        lArgs.add(this.appName);
        lArgs.add(this.workerInMaster);
        lArgs.add(this.workingDir);
        lArgs.add(Boolean.toString(this.failByEV));
    }

    public String getRuncompss() {
        return this.runcompss;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getWorkerInMaster() {
        return this.workerInMaster;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    public String getParentAppId() {
        return this.parentAppId;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.COMPSs;
    }

    @Override
    public String toMethodDefinitionFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("[RUNCOMPSS=").append(this.runcompss);
        sb.append(", FLAGS=").append(this.flags);
        sb.append(", APP_NAME=").append(this.appName);
        sb.append(", WORKER_IN_MASTER=").append(this.workerInMaster);
        sb.append(", WORKING_DIR=").append(this.workingDir);
        sb.append(", FAIL_BY_EV=").append(this.failByEV);
        sb.append(", PARENT_APP_ID=").append(this.parentAppId);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return " COMPSs Method with appName " + this.appName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.runcompss = (String)in.readObject();
        this.flags = (String)in.readObject();
        this.appName = (String)in.readObject();
        this.workerInMaster = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.failByEV = in.readBoolean();
        this.parentAppId = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.runcompss);
        out.writeObject(this.flags);
        out.writeObject(this.appName);
        out.writeObject(this.workerInMaster);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.parentAppId);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }
}

