/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.cepbatools.extrae.Wrapper;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.PythonTraceMerger;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.TraceEventType;
import es.bsc.compss.util.tracing.TraceScript;
import es.bsc.compss.util.types.ThreadTranslator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Tracer {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String ERROR_TRACE_DIR = "ERROR: Cannot create trace directory";
    private static final String ERROR_MASTER_PACKAGE_FILEPATH = "Cannot locate master tracing package on working directory";
    public static final String TRACER_SUBFOLDER = "trace";
    private static final String TRACER_OUT_FILENAME = "tracer.out";
    private static final String TRACER_ERR_FILENAME = "tracer.err";
    public static final String TO_MERGE_SUBDIR = "to_merge";
    public static final String MASTER_TRACE_SUFFIX = "_compss";
    public static final String TRACE_ROW_FILE_EXTENTION = ".row";
    public static final String TRACE_PRV_FILE_EXTENTION = ".prv";
    public static final String TRACE_PCF_FILE_EXTENTION = ".pcf";
    public static final String PACKAGE_SUFFIX = "_compss_trace.tar.gz";
    private static final boolean IS_CUSTOM_EXTRAE_FILE = System.getProperty("compss.extrae.file") != null && !System.getProperty("compss.extrae.file").isEmpty() && !System.getProperty("compss.extrae.file").equals("null");
    private static final String EXTRAE_FILE = IS_CUSTOM_EXTRAE_FILE ? System.getProperty("compss.extrae.file") : "null";
    public static final String LD_PRELOAD = "LD_PRELOAD";
    public static final String EXTRAE_CONFIG_FILE = "EXTRAE_CONFIG_FILE";
    public static final String EXTRAE_USE_POSIX_CLOCK = "EXTRAE_USE_POSIX_CLOCK";
    public static final int EVENT_END = 0;
    private static final AtomicInteger NEXT_HOST_ID = new AtomicInteger(1);
    public static boolean tracerAlreadyLoaded = false;
    private static boolean enabled = false;
    private static String nodeName;
    private static String installDir;
    private static String workingDir;
    private static String traceDirPath;
    private static String hostId;
    protected static boolean tracingTaskDependencies;
    private static final Map<String, TraceHost> hostToSlots;
    private static int numPthreadsEnabled;
    private static final HashMap<Integer, ArrayList<Integer>> predecessorsMap;

    public static void init(boolean enabled, int hostId, String nodeName, String installDir, String workingDir, String baseLogDir, boolean tracingTasks) {
        if (tracerAlreadyLoaded) {
            if (DEBUG) {
                LOGGER.debug("Tracing already initialized.");
            }
            return;
        }
        tracerAlreadyLoaded = true;
        Tracer.enabled = enabled;
        Tracer.nodeName = nodeName;
        Tracer.installDir = installDir;
        if (!workingDir.endsWith(File.separator)) {
            workingDir = workingDir + File.separator;
        }
        Tracer.workingDir = workingDir;
        if (DEBUG) {
            LOGGER.debug("Initializing tracing: " + (enabled ? "Enabled" : "Disabled"));
            LOGGER.debug("Tracing task dependencies: " + tracingTasks);
        }
        if (enabled) {
            Tracer.hostId = String.valueOf(hostId);
            tracingTaskDependencies = tracingTasks;
            if (!baseLogDir.endsWith(File.separator)) {
                baseLogDir = baseLogDir + File.separator;
            }
            if (!(baseLogDir = baseLogDir + TRACER_SUBFOLDER).endsWith(File.separator)) {
                baseLogDir = baseLogDir + File.separator;
            }
            if (!new File(traceDirPath = baseLogDir).mkdir()) {
                ErrorManager.error(ERROR_TRACE_DIR);
            }
            Tracer.setUpWrapper(hostId, hostId + 1);
        }
    }

    public static String getHostID() {
        return hostId;
    }

    public static String getTraceOutPath() {
        return traceDirPath + TRACER_OUT_FILENAME;
    }

    public static String getTraceErrPath() {
        return traceDirPath + TRACER_ERR_FILENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUpWrapper(int taskId, int numTasks) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (DEBUG) {
                LOGGER.debug("Initializing extrae Wrapper.");
            }
            Wrapper.SetTaskID(taskId);
            Wrapper.SetNumTasks(numTasks);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean isActivated() {
        return enabled;
    }

    public static boolean isTracingTaskDependencies() {
        return tracingTaskDependencies;
    }

    public static String getExtraeFile() {
        return EXTRAE_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enablePThreads(int n) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if ((numPthreadsEnabled += n) > 0) {
                Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disablePThreads(int n) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if ((numPthreadsEnabled -= n) < 1) {
                numPthreadsEnabled = 0;
                Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerHost(String name, int slots) {
        int id;
        if (DEBUG) {
            LOGGER.debug("Tracing: Registering host " + name + " in the tracing system");
        }
        Map<String, TraceHost> map = hostToSlots;
        synchronized (map) {
            if (hostToSlots.containsKey(name)) {
                if (DEBUG) {
                    LOGGER.debug("Host " + name + " already in tracing system, skipping");
                }
                return -1;
            }
            id = NEXT_HOST_ID.getAndIncrement();
            hostToSlots.put(name, new TraceHost(slots));
        }
        return id;
    }

    public static int getNextSlot(String host) {
        int slot = Tracer.hostToSlots.get(host).getNextSlot();
        if (DEBUG) {
            LOGGER.debug("Tracing: Getting slot " + slot + " of host " + host);
        }
        return slot;
    }

    public static void freeSlot(String host, int slot) {
        if (DEBUG) {
            LOGGER.debug("Tracing: Freeing slot " + slot + " of host " + host);
        }
        Tracer.hostToSlots.get(host).freeSlot(slot);
    }

    public static int getRuntimeEventsType() {
        return TraceEventType.RUNTIME.code;
    }

    public static int getSyncType() {
        return TraceEventType.SYNC.code;
    }

    public static int getTaskTransfersType() {
        return TraceEventType.TASK_TRANSFERS.code;
    }

    public static int getDataTransfersType() {
        return TraceEventType.DATA_TRANSFERS.code;
    }

    public static int getTaskEventsType() {
        return TraceEventType.TASKS_FUNC.code;
    }

    public static int getTaskSchedulingType() {
        return TraceEventType.TASKS_ID.code;
    }

    public static int getInsideTasksEventsType() {
        return TraceEventType.BINDING_INSIDE_TASKS.code;
    }

    public static int getTasksCPUAffinityEventsType() {
        return TraceEventType.TASKS_CPU_AFFINITY.code;
    }

    public static int getTasksGPUAffinityEventsType() {
        return TraceEventType.TASKS_GPU_AFFINITY.code;
    }

    public static int getInsideTasksCPUAffinityEventsType() {
        return TraceEventType.BINDING_INSIDE_TASKS_CPU_AFFINITY.code;
    }

    public static int getInsideTasksGPUAffinityEventsType() {
        return TraceEventType.BINDING_INSIDE_TASKS_GPU_AFFINITY.code;
    }

    public static int getBindingInsideWorkerEventsType() {
        return TraceEventType.BINDING_INSIDE_WORKER.code;
    }

    public static int getBindingMasterEventsType() {
        return TraceEventType.BINDING_MASTER.code;
    }

    public static int getTaskTypeEventsType() {
        return TraceEventType.TASKTYPE.code;
    }

    public static int getCPUCountEventsType() {
        return TraceEventType.CPU_COUNTS.code;
    }

    public static int getGPUCountEventsType() {
        return TraceEventType.GPU_COUNTS.code;
    }

    public static int getReadyCountEventsType() {
        return TraceEventType.READY_COUNTS.code;
    }

    public static int getMemoryEventsType() {
        return TraceEventType.MEMORY.code;
    }

    public static int getDiskBWEventsType() {
        return TraceEventType.DISK_BW.code;
    }

    public static int getThreadIdEventsType() {
        return TraceEventType.THREAD_IDENTIFICATION.code;
    }

    public static TraceEvent getAcessProcessorRequestEvent(String eventType) {
        return TraceEvent.valueOf(eventType);
    }

    public static ArrayList<Integer> getPredecessors(int taskId) {
        return predecessorsMap.get(taskId);
    }

    public static void removePredecessor(int taskId) {
        predecessorsMap.remove(taskId);
    }

    public static void addPredecessors(int taskId, int predecessorTaskId) {
        ArrayList<Integer> predecessors = predecessorsMap.get(taskId);
        if (predecessors == null) {
            predecessors = new ArrayList();
        }
        predecessors.add(predecessorTaskId);
        predecessorsMap.put(taskId, predecessors);
    }

    public static TraceEvent getTaskDispatcherRequestEvent(String eventType) {
        TraceEvent event = null;
        try {
            event = TraceEvent.valueOf(eventType);
        }
        catch (Exception e) {
            LOGGER.error("Task Dispatcher event " + eventType + " is not present in Tracer's list ");
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEvent(TraceEvent event) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Event(event.getType(), event.getId());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event [type, id] = [" + event.getType() + " , " + event.getId() + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEvent(long eventID, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Event(eventType, eventID);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event [type, id] = [" + eventType + " , " + eventID + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEventAndCounters(int taskId, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Eventandcounters(eventType, taskId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event with HW counters [type, taskId] = [" + eventType + " , " + taskId + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEventEnd(TraceEvent event) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Event(event.getType(), 0L);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event [type, id] = [" + event.getType() + " , " + 0 + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitCommEvent(boolean send, int ownID, int partnerID, int tag, long size) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Comm(send, tag, (int)size, partnerID, ownID);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting communication event [" + (send ? "SEND" : "REC") + "] " + tag + ", " + size + ", " + partnerID + ", " + ownID + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fini(Map<String, Integer> runtimeEvents) {
        if (DEBUG) {
            LOGGER.debug("Tracing: finalizing");
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (enabled) {
                Tracer.defineEvents(runtimeEvents);
                Tracer.stopWrapper();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopWrapper() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            LOGGER.debug("[Tracer] Disabling pthreads");
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            Wrapper.Fini();
            if (DEBUG) {
                LOGGER.debug("[Tracer] Finishing extrae");
            }
            Wrapper.SetOptions(Wrapper.EXTRAE_DISABLE_ALL_OPTIONS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCompleteTrace() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (enabled) {
                String masterPackage = traceDirPath + "master" + PACKAGE_SUFFIX;
                Tracer.generatePackage(masterPackage);
                Tracer.generateTrace();
                Tracer.sortTrace();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void defineEvents(Map<String, Integer> runtimeEvents) {
        if (DEBUG) {
            LOGGER.debug("SignatureToId size: " + runtimeEvents.size());
        }
        block5: for (TraceEventType type : TraceEventType.values()) {
            switch (type) {
                case TASKS_FUNC: {
                    Tracer.defineEventsForFunctions(type, runtimeEvents);
                    continue block5;
                }
                case BINDING_TASKS_FUNC: {
                    continue block5;
                }
                case TASKTYPE: {
                    Tracer.defineEventsForTaskType(type, MethodType.values());
                    continue block5;
                }
                default: {
                    Tracer.defineEventsForType(type);
                }
            }
        }
    }

    private static void defineEventsForTaskType(TraceEventType type, MethodType[] types) {
        int size = types.length + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (MethodType tp : types) {
            values[i] = (long)tp.ordinal() + 1L;
            descriptionValues[i] = tp.name();
            ++i;
        }
        Wrapper.defineEventType(type.code, type.desc, values, descriptionValues);
    }

    private static void defineEventsForFunctions(TraceEventType type, Map<String, Integer> runtimeEvents) {
        int size = runtimeEvents.entrySet().size() + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (Map.Entry<String, Integer> entry : runtimeEvents.entrySet()) {
            String signature = entry.getKey();
            Integer methodId = entry.getValue();
            values[i] = (long)methodId.intValue() + 1L;
            LOGGER.debug("Tracing debug: " + signature);
            String methodName = signature.substring(signature.indexOf(46) + 1, signature.length());
            String mN = methodName.replace("(", "([").replace(")", "])");
            if (mN.contains(".")) {
                int start = mN.lastIndexOf(".");
                mN = "[" + mN.substring(0, start) + ".]" + mN.substring(start + 1);
            }
            descriptionValues[i] = mN;
            if (DEBUG) {
                LOGGER.debug("Tracing Funtion Event [i,methodId]: [" + i + "," + methodId + "] => value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(type.code, type.desc, values, descriptionValues);
    }

    private static void defineEventsForType(TraceEventType type) {
        String[] descriptions;
        long[] values;
        boolean endable = type.endable;
        List<TraceEvent> events = type.getEvents();
        int size = events.size();
        int offset = 0;
        if (endable) {
            values = new long[size + 1];
            values[0] = 0L;
            descriptions = new String[size + 1];
            descriptions[0] = "End";
            offset = 1;
        } else {
            values = new long[size];
            descriptions = new String[size];
        }
        for (TraceEvent event : events) {
            values[offset] = event.getId();
            descriptions[offset] = event.getSignature();
            if (DEBUG) {
                LOGGER.debug("Tracing[API]: Type " + type.code + " Event " + offset + "=> value: " + values[offset] + ", Desc: " + descriptions[offset]);
            }
            ++offset;
        }
        Wrapper.defineEventType(type.code, type.desc, values, descriptions);
    }

    public static void generatePackage(String packagePath) {
        if (DEBUG) {
            LOGGER.debug("[Tracer] Generating trace package of " + nodeName);
        }
        try {
            int exitCode = TraceScript.package_extrae(installDir, workingDir, packagePath, hostId);
            if (exitCode != 0) {
                ErrorManager.warn("Error generating " + nodeName + " package, exit code " + exitCode);
            }
        }
        catch (IOException e) {
            ErrorManager.warn("Error generating " + nodeName + " package", e);
        }
        catch (InterruptedException e) {
            ErrorManager.warn("Error generating " + nodeName + " package (interruptedException)", e);
            Thread.currentThread().interrupt();
        }
    }

    private static void generateTrace() {
        if (DEBUG) {
            LOGGER.debug("Tracing: Generating trace");
        }
        String traceName = "";
        String appName = System.getProperty("compss.appName");
        String label = System.getProperty("compss.trace.label");
        if (appName != null && !appName.isEmpty() && !appName.equals("None")) {
            traceName = label != null && !label.isEmpty() && !label.equals("None") ? appName.concat("_" + label) : appName;
        } else if (label != null && !label.isEmpty() && !label.equals("None")) {
            traceName = label;
        }
        String appLogDir = System.getProperty("compss.appLogDir");
        try {
            int numHosts = hostToSlots.size() + 1;
            int exitCode = TraceScript.gentrace_extrae(installDir, appLogDir, traceName, String.valueOf(numHosts));
            if (exitCode != 0) {
                ErrorManager.warn("Error generating trace, exit code " + exitCode);
                return;
            }
        }
        catch (IOException e) {
            ErrorManager.warn("Error generating trace", e);
            return;
        }
        catch (InterruptedException e) {
            ErrorManager.warn("Error generating trace (interruptedException)", e);
            return;
        }
        String lang = System.getProperty("compss.lang");
        if (lang.equalsIgnoreCase(COMPSsConstants.Lang.PYTHON.name())) {
            try {
                PythonTraceMerger t = new PythonTraceMerger(traceDirPath);
                t.merge();
            }
            catch (Exception e) {
                ErrorManager.warn("Error while trying to merge files", e);
            }
        }
    }

    private static void sortTrace() {
        File[] prvFileArray;
        File[] rowFileArray;
        String disable = System.getProperty("compss.tracing.disableCustomThreads");
        if (disable != null) {
            LOGGER.debug("Custom thread translation disabled");
            return;
        }
        LOGGER.debug("Tracing: Updating thread labels");
        try {
            File dir = new File(traceDirPath);
            rowFileArray = dir.listFiles((d, name) -> name.endsWith(TRACE_ROW_FILE_EXTENTION));
            prvFileArray = dir.listFiles((d, name) -> name.endsWith(TRACE_PRV_FILE_EXTENTION));
        }
        catch (Exception e) {
            ErrorManager.error(ERROR_MASTER_PACKAGE_FILEPATH, e);
            return;
        }
        try {
            if (rowFileArray != null && rowFileArray.length > 0) {
                File rowFile = rowFileArray[0];
                File prvFile = prvFileArray[0];
                ThreadTranslator thTranslator = new ThreadTranslator(prvFile);
                thTranslator.translatePrvFile(prvFile);
                thTranslator.translateRowFile(rowFile);
            }
        }
        catch (Exception e) {
            LOGGER.debug(e);
            LOGGER.debug(e.toString());
            ErrorManager.error("Could not update thread labels " + traceDirPath, e);
            e.printStackTrace();
        }
    }

    public static String getTraceNamePrefix() {
        String traceName = System.getProperty("compss.appName");
        String label = System.getProperty("compss.trace.label");
        if (label != null && !label.isEmpty() && !label.equals("None")) {
            traceName = traceName.concat("_" + label);
        }
        return traceName + MASTER_TRACE_SUFFIX;
    }

    static {
        hostToSlots = new HashMap<String, TraceHost>();
        numPthreadsEnabled = 0;
        predecessorsMap = new HashMap();
    }

    private static class TraceHost {
        private boolean[] slots;
        private int numFreeSlots;
        private int nextSlot;

        private TraceHost(int nslots) {
            this.slots = new boolean[nslots];
            this.numFreeSlots = nslots;
            this.nextSlot = 0;
        }

        private int getNextSlot() {
            if (this.numFreeSlots-- > 0) {
                while (this.slots[this.nextSlot]) {
                    this.nextSlot = (this.nextSlot + 1) % this.slots.length;
                }
                this.slots[this.nextSlot] = true;
                return this.nextSlot;
            }
            return -1;
        }

        private void freeSlot(int slot) {
            this.slots[slot] = false;
            this.nextSlot = slot;
            ++this.numFreeSlots;
        }
    }
}

