/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.types;

import es.bsc.compss.util.Tracer;
import es.bsc.compss.util.tracing.ThreadIdentifier;
import es.bsc.compss.util.tracing.Threads;
import es.bsc.compss.util.types.PrvHeader;
import es.bsc.compss.util.types.PrvLine;
import es.bsc.compss.util.types.RowFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadTranslator {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    private static final String THREAD_ID_EVENT_TYPE = Integer.toString(Tracer.getThreadIdEventsType());
    private final List<Machine> machines = new ArrayList<Machine>();
    public Map<ThreadIdentifier, ThreadIdentifier> threadTranslations;

    public ThreadTranslator() {
    }

    public ThreadTranslator(File prvFile) throws FileNotFoundException, IOException {
        this();
        this.parsePrvFile(prvFile);
    }

    public final void parsePrvFile(File prvFile) throws FileNotFoundException, IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(prvFile));){
            String line;
            br.readLine();
            while ((line = br.readLine()) != null && !line.isEmpty()) {
                PrvLine prvLine = new PrvLine(line);
                ThreadIdentifier threadId = prvLine.getStateLineThreadIdentifier();
                Map<String, String> events = prvLine.getEvents();
                String identifierEventValue = events.get(THREAD_ID_EVENT_TYPE);
                this.registerThread(threadId, identifierEventValue);
            }
        }
        this.computeTranslationMap();
    }

    public void translatePrvFile(File prvFile) throws FileNotFoundException, IOException, Exception {
        PrintWriter prvWriter;
        LOGGER.debug("Tracing: Updating thread identifiers in .prv file");
        String oldFilePath = prvFile.getAbsolutePath();
        String newFilePath = oldFilePath + "_tmp_updatedThreadsId";
        File updatedPrvFile = new File(newFilePath);
        if (!updatedPrvFile.exists()) {
            updatedPrvFile.createNewFile();
        }
        try (BufferedReader br = new BufferedReader(new FileReader(prvFile));){
            String line;
            prvWriter = new PrintWriter(new FileWriter(updatedPrvFile.getAbsolutePath(), true));
            PrvHeader header = new PrvHeader(br.readLine());
            header.transformNodesToAplications();
            header.splitRuntimeExecutors(this.createRuntimeThreadNumberPerApp());
            prvWriter.println(header.toString());
            while ((line = br.readLine()) != null && !line.isEmpty()) {
                PrvLine prvLine = new PrvLine(line);
                prvLine.translateLineThreads(this.threadTranslations);
                prvWriter.println(prvLine.toString());
            }
        }
        prvWriter.close();
        updatedPrvFile.renameTo(new File(oldFilePath));
    }

    public final void translateRowFile(File rowFile) throws IOException, Exception {
        List<String> labels = this.getRowLabels();
        RowFile rFile = new RowFile(rowFile);
        rFile.updateRowLabels(labels);
        rFile.printInfo(rowFile);
    }

    private void registerThread(ThreadIdentifier threadId, String threadTypeIdString) {
        int machineId = Integer.parseInt(threadId.getTask());
        while (this.machines.size() < machineId) {
            this.machines.add(new Machine());
        }
        Machine machine = this.machines.get(machineId - 1);
        machine.addThread(threadId);
        if (threadTypeIdString != null) {
            Integer threadTypeId = new Integer(threadTypeIdString);
            if (threadTypeId == Threads.EXEC.id) {
                machine.addExecutor(threadId);
            } else if (threadTypeId != 0) {
                machine.putRuntimeIdentifier(threadTypeId, threadId);
            }
        }
    }

    private void computeTranslationMap() {
        this.threadTranslations = new HashMap<ThreadIdentifier, ThreadIdentifier>();
        for (int i = 0; i < this.machines.size(); ++i) {
            ThreadIdentifier newThread;
            Threads.ExtraeTaskType task;
            String machineId = Integer.toString(i + 1);
            ThreadIdentifier oldMainId = new ThreadIdentifier("1", machineId, "1");
            ThreadIdentifier newMainId = ThreadTranslator.computeNewThreadId(oldMainId, Threads.ExtraeTaskType.RUNTIME, 1);
            this.threadTranslations.put(oldMainId, newMainId);
            Machine m = this.machines.get(i);
            Map runtimeIdentifiers = m.getRuntimeIdentifiers();
            Set translatedUnknownList = m.getTranslatedMachineUnknowns();
            int runtimeThreadsNum = 2;
            for (int ident = 0; ident < Threads.EXEC.id; ++ident) {
                if (!runtimeIdentifiers.containsKey(ident)) continue;
                ThreadIdentifier oldThread = (ThreadIdentifier)runtimeIdentifiers.get(ident);
                int threadId = runtimeThreadsNum++;
                Threads.ExtraeTaskType task2 = Threads.ExtraeTaskType.RUNTIME;
                ThreadIdentifier newThread2 = ThreadTranslator.computeNewThreadId(oldThread, task2, threadId);
                this.threadTranslations.put(oldThread, newThread2);
            }
            int executorsNum = 1;
            for (ThreadIdentifier oldThread : m.getExecutors()) {
                int threadId = executorsNum++;
                task = Threads.ExtraeTaskType.EXECUTOR;
                newThread = ThreadTranslator.computeNewThreadId(oldThread, task, threadId);
                this.threadTranslations.put(oldThread, newThread);
            }
            for (ThreadIdentifier oldThread : m.getThreads()) {
                if (this.threadTranslations.containsKey(oldThread)) continue;
                int threadId = runtimeThreadsNum++;
                task = Threads.ExtraeTaskType.RUNTIME;
                newThread = ThreadTranslator.computeNewThreadId(oldThread, task, threadId);
                translatedUnknownList.add(newThread);
                this.threadTranslations.put(oldThread, newThread);
            }
        }
    }

    private static ThreadIdentifier computeNewThreadId(ThreadIdentifier id, Threads.ExtraeTaskType type, int threadId) {
        String thread = Integer.toString(threadId++);
        String task = type.getLabel();
        String app = id.getTask();
        return new ThreadIdentifier(app, task, thread);
    }

    private String createLabel(String threadId, int identifierEvent) {
        String label = Threads.getLabelByID(identifierEvent);
        return label + " (" + threadId + ")";
    }

    private List<String> getRowLabels() throws Exception {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("MAIN APP (1.1.1)");
        for (int i = 1; i < this.machines.size(); ++i) {
            String iString = Integer.toString(i + 1);
            labels.add("WORKER MAIN (" + iString + ".1.1)");
        }
        for (Machine m : this.machines) {
            String newLabel;
            String newThreadId;
            String oldLabel;
            for (Map.Entry identifier : m.getRuntimeIdentifiers().entrySet()) {
                int eventIdentifier = (Integer)identifier.getKey();
                oldLabel = this.threadTranslations.get(identifier.getValue()).toString();
                newThreadId = oldLabel.replace(":", ".");
                newLabel = this.createLabel(newThreadId, eventIdentifier);
                labels.add(newLabel);
            }
            for (ThreadIdentifier exec : m.getExecutors()) {
                ThreadIdentifier newThread = this.threadTranslations.get(exec);
                oldLabel = newThread.toString();
                newThreadId = oldLabel.replace(":", ".");
                newLabel = this.createLabel(newThreadId, Threads.EXEC.id);
                labels.add(newLabel);
            }
            for (ThreadIdentifier unkn : m.getTranslatedMachineUnknowns()) {
                ThreadIdentifier newThread = this.threadTranslations.get(unkn);
                oldLabel = newThread.toString();
                labels.add("THREAD " + oldLabel.replace(":", "."));
            }
        }
        return labels;
    }

    private int[] createRuntimeThreadNumberPerApp() {
        int[] result = new int[this.machines.size()];
        for (int i = 0; i < result.length; ++i) {
            Machine machine = this.machines.get(i);
            result[i] = machine.getNumThreads() - machine.getNumExecutors();
        }
        return result;
    }

    private static class Machine {
        private Map<Integer, ThreadIdentifier> runtimeIdentifiers;
        private Set<ThreadIdentifier> threads = new HashSet<ThreadIdentifier>();
        private Set<ThreadIdentifier> executors = new HashSet<ThreadIdentifier>();
        private Set<ThreadIdentifier> translatedMachineUnknowns = new HashSet<ThreadIdentifier>();

        public Machine() {
            this.runtimeIdentifiers = new HashMap<Integer, ThreadIdentifier>();
        }

        private void addThread(ThreadIdentifier threadId) {
            this.threads.add(threadId);
        }

        private Set<ThreadIdentifier> getThreads() {
            return this.threads;
        }

        private int getNumThreads() {
            return this.threads.size();
        }

        private void addExecutor(ThreadIdentifier threadId) {
            this.executors.add(threadId);
        }

        private Set<ThreadIdentifier> getExecutors() {
            return this.executors;
        }

        private int getNumExecutors() {
            return this.executors.size();
        }

        private void putRuntimeIdentifier(Integer threadTypeId, ThreadIdentifier threadId) {
            this.runtimeIdentifiers.put(threadTypeId, threadId);
        }

        private Map<Integer, ThreadIdentifier> getRuntimeIdentifiers() {
            return this.runtimeIdentifiers;
        }

        private Set<ThreadIdentifier> getTranslatedMachineUnknowns() {
            return this.translatedMachineUnknowns;
        }
    }
}

