/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.worker;

import es.bsc.compss.gat.worker.utils.Invokers;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Serializer;
import es.bsc.compss.util.Tracer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public class GATWorker {
    private static final String WARN_UNSUPPORTED_TYPE = "WARNING: Unsupported data type";
    private static final String WARN_UNSUPPORTED_STREAM = "WARNING: Unsupported data stream";
    private static final String ERROR_APP_PARAMETERS = "ERROR: Incorrect number of parameters";
    private static final String ERROR_STORAGE_CONF = "ERROR: Cannot load storage configuration file: ";
    private static final String ERROR_SERIALIZE_RETURN = "Error serializing object return value with renaming ";
    private static final String ERROR_OUTPUT_FILES = "ERROR: One or more OUT files have not been created by task '";
    private static final int DEFAULT_FLAGS_SIZE = 3;
    private static File taskSandboxWorkingDir;
    private static boolean debug;
    private static String storageConf;
    private static int numNodes;
    private static List<String> hostnames;
    private static int cus;
    private static AbstractMethodImplementation.MethodType methodType;
    private static String[] methodDefinition;
    private static boolean hasTarget;
    private static boolean hasReturn;
    private static int numReturns;
    private static int numParams;
    private static int initialAppParamsPosition;
    private static Class<?>[] types;
    private static Stream[] streams;
    private static String[] prefixes;
    private static Object[] values;
    private static boolean[] isFile;
    private static boolean[] mustWrite;
    private static String[] renamings;
    private static Object target;
    private static String retRenaming;
    private static Object retValue;

    public static void main(String[] args) {
        GATWorker.parseArguments(args);
        GATWorker.parseApplicationParameters(args);
        if (debug) {
            GATWorker.logArguments();
        }
        GATWorker.setEnvironmentVariables();
        GATWorker.invokeMethod();
        GATWorker.serializeResults();
        GATWorker.checkOutputFiles();
    }

    private static void parseArguments(String[] args) {
        String returnType;
        taskSandboxWorkingDir = new File(args[0]);
        debug = Boolean.valueOf(args[1]);
        storageConf = args[2];
        int argPosition = 3;
        methodType = AbstractMethodImplementation.MethodType.valueOf(args[argPosition++]);
        methodDefinition = null;
        switch (methodType) {
            case METHOD: {
                methodDefinition = new String[]{args[argPosition], args[argPosition + 1]};
                argPosition += 2;
                break;
            }
            case MPI: {
                methodDefinition = new String[]{args[argPosition], args[argPosition + 1]};
                argPosition += 2;
                break;
            }
            case DECAF: {
                methodDefinition = new String[]{args[argPosition], args[argPosition + 1], args[argPosition + 2], args[argPosition + 3], args[argPosition + 4]};
                argPosition += 5;
                break;
            }
            case OMPSS: {
                methodDefinition = new String[]{args[argPosition]};
                break;
            }
            case OPENCL: {
                methodDefinition = new String[]{args[argPosition]};
                ++argPosition;
                break;
            }
            case BINARY: {
                methodDefinition = new String[]{args[argPosition]};
                ++argPosition;
            }
        }
        int n = ++argPosition;
        ++argPosition;
        numNodes = Integer.parseInt(args[n]);
        hostnames = new ArrayList<String>();
        for (int i = 0; i < numNodes; ++i) {
            hostnames.add(args[argPosition++]);
        }
        cus = Integer.parseInt(args[argPosition++]);
        hasTarget = Boolean.parseBoolean(args[argPosition++]);
        hasReturn = (returnType = args[argPosition++]) != null && !returnType.equals("null") && !returnType.isEmpty();
        numReturns = Integer.parseInt(args[argPosition++]);
        if (args.length < 2 * (numParams = Integer.parseInt(args[argPosition++])) + (initialAppParamsPosition = argPosition)) {
            ErrorManager.error(ERROR_APP_PARAMETERS);
        }
        System.setProperty("compss.storage.conf", storageConf);
        if (storageConf != null && !storageConf.equals("") && !storageConf.equals("null")) {
            try {
                StorageItf.init(storageConf);
            }
            catch (StorageException e) {
                ErrorManager.fatal(ERROR_STORAGE_CONF + storageConf, e);
            }
        }
    }

    private static void parseApplicationParameters(String[] args) {
        if (hasTarget) {
            types = new Class[numParams - 1];
            values = new Object[numParams - 1];
        } else {
            types = new Class[numParams];
            values = new Object[numParams];
        }
        streams = new Stream[numParams];
        prefixes = new String[numParams];
        isFile = new boolean[numParams];
        mustWrite = new boolean[numParams];
        renamings = new String[numParams];
        DataType[] dataTypesEnum = DataType.values();
        Stream[] dataStream = Stream.values();
        int argPosition = initialAppParamsPosition;
        for (int i = 0; i < numParams; ++i) {
            String prefix;
            int argStream_index;
            int argType_index = Integer.parseInt(args[argPosition]);
            if (argType_index >= dataTypesEnum.length) {
                ErrorManager.error(WARN_UNSUPPORTED_TYPE + argType_index);
            }
            DataType argType = dataTypesEnum[argType_index];
            if ((argStream_index = Integer.parseInt(args[++argPosition])) >= dataStream.length) {
                ErrorManager.error(WARN_UNSUPPORTED_STREAM + argStream_index);
            }
            GATWorker.streams[i] = dataStream[argStream_index];
            if ((prefix = args[++argPosition]) == null || prefix.isEmpty()) {
                prefix = "null";
            }
            GATWorker.prefixes[i] = prefix;
            ++argPosition;
            switch (argType) {
                case FILE_T: {
                    GATWorker.types[i] = String.class;
                    GATWorker.values[i] = args[argPosition++];
                    break;
                }
                case OBJECT_T: {
                    GATWorker.renamings[i] = args[argPosition++];
                    GATWorker.mustWrite[i] = args[argPosition++].equals("W");
                    GATWorker.retrieveObject(renamings[i], i);
                    break;
                }
                case BINDING_OBJECT_T: {
                    GATWorker.renamings[i] = args[argPosition++];
                    GATWorker.mustWrite[i] = args[argPosition++].equals("W");
                    GATWorker.retrieveBindingObject(renamings[i], i);
                    break;
                }
                case PSCO_T: {
                    GATWorker.renamings[i] = args[argPosition++];
                    GATWorker.mustWrite[i] = args[argPosition++].equals("W");
                    GATWorker.retrievePSCO(renamings[i], i);
                    break;
                }
                case EXTERNAL_PSCO_T: {
                    GATWorker.types[i] = String.class;
                    GATWorker.values[i] = args[argPosition++];
                    break;
                }
                case BOOLEAN_T: {
                    GATWorker.types[i] = Boolean.TYPE;
                    GATWorker.values[i] = new Boolean(args[argPosition++]);
                    break;
                }
                case CHAR_T: {
                    GATWorker.types[i] = Character.TYPE;
                    GATWorker.values[i] = new Character(args[argPosition++].charAt(0));
                    break;
                }
                case STRING_T: {
                    GATWorker.types[i] = String.class;
                    int numSubStrings = Integer.parseInt(args[argPosition++]);
                    String aux = "";
                    for (int j = 0; j < numSubStrings; ++j) {
                        if (j != 0) {
                            aux = aux + " ";
                        }
                        aux = aux + args[argPosition++];
                    }
                    GATWorker.values[i] = aux;
                    break;
                }
                case BYTE_T: {
                    GATWorker.types[i] = Byte.TYPE;
                    GATWorker.values[i] = new Byte(args[argPosition++]);
                    break;
                }
                case SHORT_T: {
                    GATWorker.types[i] = Short.TYPE;
                    GATWorker.values[i] = new Short(args[argPosition++]);
                    break;
                }
                case INT_T: {
                    GATWorker.types[i] = Integer.TYPE;
                    GATWorker.values[i] = new Integer(args[argPosition++]);
                    break;
                }
                case LONG_T: {
                    GATWorker.types[i] = Long.TYPE;
                    GATWorker.values[i] = new Long(args[argPosition++]);
                    break;
                }
                case FLOAT_T: {
                    GATWorker.types[i] = Float.TYPE;
                    GATWorker.values[i] = new Float(args[argPosition++]);
                    break;
                }
                case DOUBLE_T: {
                    GATWorker.types[i] = Double.TYPE;
                    GATWorker.values[i] = new Double(args[argPosition++]);
                    break;
                }
                default: {
                    ErrorManager.error(WARN_UNSUPPORTED_TYPE + (Object)((Object)argType));
                    return;
                }
            }
            GATWorker.isFile[i] = argType.equals((Object)DataType.FILE_T);
        }
        if (hasReturn) {
            retRenaming = args[argPosition + 3];
        }
    }

    private static void retrieveBindingObject(String string, int i) {
    }

    private static void retrieveObject(String renaming, int position) {
        Object o = null;
        try {
            o = Serializer.deserialize(renaming);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error deserializing object parameter ").append(position);
            sb.append(" with renaming ").append(renaming);
            sb.append(", at");
            String[] stringArray = methodDefinition;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String info = stringArray[i];
                sb.append(info).append(" ");
            }
            ErrorManager.error(sb.toString());
        }
        if (o == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Object with renaming ").append(renaming);
            sb.append(", at");
            for (String info : methodDefinition) {
                sb.append(info).append(" ");
            }
            sb.append("is null!");
            ErrorManager.error(sb.toString());
            return;
        }
        if (hasTarget && position == numParams - 1) {
            target = o;
        } else {
            GATWorker.types[position] = o.getClass();
            GATWorker.values[position] = o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retrievePSCO(String renaming, int position) {
        String id = null;
        try {
            id = (String)Serializer.deserialize(renaming);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error deserializing PSCO id parameter ").append(position);
            sb.append(" with renaming ").append(renaming);
            sb.append(", at");
            for (String info : methodDefinition) {
                sb.append(info).append(" ");
            }
            ErrorManager.error(sb.toString());
            return;
        }
        if (id == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("PSCO Id with renaming ").append(renaming);
            sb.append(", at");
            for (String info : methodDefinition) {
                sb.append(info).append(" ");
            }
            sb.append("is null!");
            ErrorManager.error(sb.toString());
            return;
        }
        Object obj = null;
        if (Tracer.isActivated()) {
            Tracer.emitEvent(Tracer.Event.STORAGE_GETBYID.getId(), Tracer.Event.STORAGE_GETBYID.getType());
        }
        try {
            obj = StorageItf.getByID(id);
        }
        catch (StorageException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot getByID parameter ").append(position);
            sb.append(" with PSCOId ").append(id);
            sb.append(", at");
            for (String info : methodDefinition) {
                sb.append(info).append(" ");
            }
            ErrorManager.error(sb.toString());
            return;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEvent(0L, Tracer.Event.STORAGE_GETBYID.getType());
            }
        }
        if (obj == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("PSCO with id ").append(id);
            sb.append(", at");
            for (String info : methodDefinition) {
                sb.append(info).append(" ");
            }
            sb.append("is null!");
            ErrorManager.error(sb.toString());
            return;
        }
        if (hasTarget && position == numParams - 1) {
            target = obj;
        } else {
            GATWorker.types[position] = obj.getClass();
            GATWorker.values[position] = obj;
        }
    }

    private static void logArguments() {
        System.out.println("");
        System.out.println("[GAT WORKER] ------------------------------------");
        System.out.println("[GAT WORKER] Parameters of execution:");
        System.out.println("  * Method type: " + methodType.toString());
        System.out.println("  * Method definition: " + GATWorker.printMethodDefinition());
        System.out.print("  * Parameter types:");
        for (Class<?> c : types) {
            System.out.print(" " + c.getName());
        }
        System.out.println("");
        System.out.print("  * Parameter values:");
        for (Object v : values) {
            System.out.print(" " + v);
        }
        System.out.println("");
        System.out.print("  * Parameter streams:");
        for (Stream s : streams) {
            System.out.print(" " + s.name());
        }
        System.out.println("");
        if (hasReturn) {
            System.out.println("  * Has " + String.valueOf(numReturns) + " return with renaming " + retRenaming);
        } else {
            System.out.println("  * Has NO return");
        }
    }

    private static String printMethodDefinition() {
        String methodDefStr = null;
        switch (methodType) {
            case METHOD: {
                methodDefStr = new String("[DECLARING CLASS=" + methodDefinition[0] + ", METHOD NAME=" + methodDefinition[1] + "]");
                break;
            }
            case MPI: {
                methodDefStr = new String("[MPI RUNNER=" + methodDefinition[0] + ", BINARY=" + methodDefinition[1] + "]");
                break;
            }
            case DECAF: {
                methodDefStr = new String("[DF SCRIPT= " + methodDefinition[0] + ", MPI RUNNER=" + methodDefinition[1] + ", BINARY=" + methodDefinition[2] + "]");
                break;
            }
            case OMPSS: {
                methodDefStr = new String("[BINARY=" + methodDefinition[0] + "]");
                break;
            }
            case OPENCL: {
                methodDefStr = new String("[KERNEL=" + methodDefinition[0] + "]");
                break;
            }
            case BINARY: {
                methodDefStr = new String("[BINARY=" + methodDefinition[0] + "]");
                break;
            }
            default: {
                methodDefStr = new String();
            }
        }
        return methodDefStr;
    }

    private static void setEnvironmentVariables() {
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            ErrorManager.warn("Cannot obtain hostname. Loading default value " + hostname);
        }
        hostnames.add(hostname);
        ++numNodes;
        boolean firstElement = true;
        StringBuilder hostnamesSTR = new StringBuilder();
        for (String nodeName : hostnames) {
            int i;
            if (nodeName.endsWith("-ib0")) {
                nodeName = nodeName.substring(0, nodeName.lastIndexOf("-ib0"));
            }
            if (firstElement) {
                firstElement = false;
                hostnamesSTR.append(nodeName);
                for (i = 1; i < cus; ++i) {
                    hostnamesSTR.append(",").append(nodeName);
                }
                continue;
            }
            for (i = 0; i < cus; ++i) {
                hostnamesSTR.append(",").append(nodeName);
            }
        }
        if (debug) {
            System.out.println("  * HOSTNAMES: " + hostnamesSTR.toString());
            System.out.println("  * NUM_NODES: " + numNodes);
            System.out.println("  * CPU_COMPUTING_UNITS: " + cus);
        }
        System.setProperty("COMPSS_HOSTNAMES", hostnamesSTR.toString());
        System.setProperty("COMPSS_NUM_NODES", String.valueOf(numNodes));
        System.setProperty("COMPSS_NUM_THREADS", String.valueOf(cus));
    }

    private static void invokeMethod() {
        System.out.println("");
        System.out.println("[GAT WORKER] ------------------------------------");
        System.out.println("[GAT WORKER] Invoking task method");
        retValue = null;
        switch (methodType) {
            case METHOD: {
                retValue = Invokers.invokeJavaMethod(methodDefinition[0], methodDefinition[1], target, types, values);
                break;
            }
            case MPI: {
                retValue = Invokers.invokeMPIMethod(methodDefinition[0], methodDefinition[1], target, values, streams, prefixes, taskSandboxWorkingDir);
                GATWorker.serializeBinaryExitValue();
                break;
            }
            case DECAF: {
                retValue = Invokers.invokeDecafMethod(methodDefinition[0], methodDefinition[1], methodDefinition[2], methodDefinition[3], methodDefinition[4], target, values, streams, prefixes, taskSandboxWorkingDir);
                GATWorker.serializeBinaryExitValue();
                break;
            }
            case OMPSS: {
                retValue = Invokers.invokeOmpSsMethod(methodDefinition[0], target, values, streams, prefixes, taskSandboxWorkingDir);
                GATWorker.serializeBinaryExitValue();
                break;
            }
            case OPENCL: {
                retValue = Invokers.invokeOpenCLMethod(methodDefinition[0], target, values, streams, prefixes, taskSandboxWorkingDir);
                GATWorker.serializeBinaryExitValue();
                break;
            }
            case BINARY: {
                retValue = Invokers.invokeBinaryMethod(methodDefinition[0], target, values, streams, prefixes, taskSandboxWorkingDir);
                GATWorker.serializeBinaryExitValue();
            }
        }
        System.out.println("");
        System.out.println("[GAT WORKER] ------------------------------------");
    }

    private static void serializeResults() {
        for (int i = 0; i < numParams; ++i) {
            if (!mustWrite[i]) continue;
            try {
                String id;
                Object toSerialize = null;
                toSerialize = hasTarget && i == numParams - 1 ? target : values[i];
                if (toSerialize instanceof StubItf && (id = ((StubItf)toSerialize).getID()) != null) {
                    toSerialize = id;
                }
                Serializer.serialize(toSerialize, renamings[i]);
                continue;
            }
            catch (Exception e) {
                StringBuilder errMsg = new StringBuilder();
                errMsg.append("Error serializing object parameter ").append(i);
                errMsg.append(" with renaming ").append(renamings[i]);
                errMsg.append(", at ");
                String[] stringArray = methodDefinition;
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String info = stringArray[j];
                    errMsg.append(info).append(" ");
                }
                ErrorManager.warn(errMsg.toString());
            }
        }
        if (hasReturn && retValue != null) {
            String id;
            if (retValue instanceof StubItf && (id = ((StubItf)retValue).getID()) != null) {
                retValue = id;
            }
            try {
                Serializer.serialize(retValue, retRenaming);
            }
            catch (IOException ioe) {
                StringBuilder errMsg = new StringBuilder();
                errMsg.append(ERROR_SERIALIZE_RETURN).append(retRenaming);
                errMsg.append(", at ");
                for (String info : methodDefinition) {
                    errMsg.append(info).append(" ");
                }
                ErrorManager.warn(errMsg.toString());
            }
        }
    }

    public static void serializeBinaryExitValue() {
        System.out.println("Checking binary exit value serialization");
        boolean isFile = GATWorker.isFile[GATWorker.isFile.length - 1];
        String lastParamPrefix = prefixes[prefixes.length - 1];
        String lastParamName = (String)values[values.length - 1];
        if (debug) {
            System.out.println("- Param isFile: " + isFile);
            System.out.println("- Prefix: " + lastParamPrefix);
        }
        if (isFile && lastParamPrefix.equals("#")) {
            System.out.println("Writing Binary Exit Value (" + retValue.toString() + ") to " + lastParamName);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(lastParamName));){
                String value = "0000I" + retValue.toString() + "\n.\n";
                writer.write(value);
                writer.flush();
            }
            catch (IOException ioe) {
                System.err.println("ERROR: Cannot serialize binary exit value for bindings");
                ioe.printStackTrace();
            }
        }
    }

    private static void checkOutputFiles() {
        boolean allOutFilesCreated = true;
        for (int i = 0; i < numParams; ++i) {
            String filepath;
            File f;
            if (!isFile[i] || (f = new File(filepath = (String)values[i])).exists()) continue;
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("ERROR: File with path '").append(values[i]).append("' has not been generated by task '");
            for (String info : methodDefinition) {
                errMsg.append(info).append(" ");
            }
            ErrorManager.warn(errMsg.toString());
            allOutFilesCreated = false;
        }
        if (!allOutFilesCreated) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(ERROR_OUTPUT_FILES);
            for (String info : methodDefinition) {
                errMsg.append(info).append(" ");
            }
            errMsg.append("'");
            ErrorManager.error(errMsg.toString());
        }
    }
}

