/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.worker;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

class GATLog {
    private static final String appenderName = "Stdout";
    private static final String pattern = "[(%r)(%d) %19c{1}]    @%-15.15M  -  %m%n";

    GATLog() {
    }

    public static void init(boolean debug) {
        Level level = debug ? Level.DEBUG : Level.OFF;
        ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationFactory.newConfigurationBuilder();
        AppenderRefComponentBuilder appender = builder.newAppenderRef(appenderName);
        AppenderComponentBuilder appenderBuilder = builder.newAppender(appenderName, "CONSOLE");
        appenderBuilder.addAttribute("target", ConsoleAppender.Target.SYSTEM_OUT);
        LayoutComponentBuilder layoutBuilder = builder.newLayout("PatternLayout");
        layoutBuilder.addAttribute("pattern", pattern);
        appenderBuilder.add(layoutBuilder);
        builder.add(appenderBuilder);
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);
        rootLogger.add(appender);
        builder.add(rootLogger);
        GATLog.addLogger("es.bsc.compss.Worker", level, appender, builder);
        GATLog.addLogger("es.bsc.compss.Worker.Executor.Invoker", level, appender, builder);
        Configuration conf = (Configuration)builder.build();
        Configurator.initialize(conf);
    }

    private static void addLogger(String name, Level level, AppenderRefComponentBuilder appender, ConfigurationBuilder<?> builder) {
        LoggerComponentBuilder logger = builder.newLogger(name, level);
        logger.add(appender);
        logger.addAttribute("additivity", false);
        builder.add(logger);
    }
}

