/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.worker;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.executor.ExecutionManager;
import es.bsc.compss.executor.types.Execution;
import es.bsc.compss.executor.types.ExecutionListener;
import es.bsc.compss.gat.executor.types.ExecutionEnd;
import es.bsc.compss.gat.worker.GATLog;
import es.bsc.compss.gat.worker.ImplementationDefinition;
import es.bsc.compss.gat.worker.implementations.BinaryDefinition;
import es.bsc.compss.gat.worker.implementations.COMPSsDefinition;
import es.bsc.compss.gat.worker.implementations.DecafDefinition;
import es.bsc.compss.gat.worker.implementations.JavaMethodDefinition;
import es.bsc.compss.gat.worker.implementations.MPIDefinition;
import es.bsc.compss.gat.worker.implementations.MultiNodeDefinition;
import es.bsc.compss.gat.worker.implementations.OMPSsDefinition;
import es.bsc.compss.gat.worker.implementations.OpenCLDefinition;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Serializer;
import java.io.PrintStream;
import java.util.concurrent.Semaphore;
import storage.StorageException;
import storage.StorageItf;

public class GATWorker
implements InvocationContext {
    private static final String EXECUTION_MANAGER_ERR = "Error starting ExecutionManager";
    private static final String WARN_UNSUPPORTED_METHOD_TYPE = "WARNING: Unsupported method type";
    private static final String ERROR_STORAGE_CONF = "ERROR: Cannot load storage configuration file: ";
    private static final int DEFAULT_FLAGS_SIZE = 6;
    private static final int WORKER_NAME_IDX = 0;
    private static final int WORKING_DIR_IDX = 1;
    private static final int DEBUG_IDX = 2;
    private static final int INSTALL_DIR_IDX = 3;
    private static final int APP_DIR_IDX = 4;
    private static final int STORAGE_CONF_IDX = 5;
    private final String hostName;
    private final boolean debug;
    private final String appDir;
    private final String installDir;
    private final String workingDir;
    private final String storageConf;
    private final ExecutionManager executionManager;

    public static void main(String[] args) throws Exception {
        ImplementationDefinition implDef;
        GATWorker worker;
        String workerName = args[0];
        String workingDir = args[1];
        boolean debug = Boolean.valueOf(args[2]);
        GATLog.init(debug);
        String installDir = args[3];
        String appDir = args[4];
        String storageConf = args[5];
        System.setProperty("compss.storage.conf", storageConf);
        if (storageConf != null && !storageConf.equals("") && !storageConf.equals("null")) {
            try {
                StorageItf.init(storageConf);
            }
            catch (StorageException e) {
                ErrorManager.fatal(ERROR_STORAGE_CONF + storageConf, e);
            }
        }
        if (!(worker = new GATWorker(workerName, workingDir, debug, installDir, appDir, storageConf, (implDef = GATWorker.parseArguments(args)).getComputingUnits())).runTask(implDef)) {
            System.exit(7);
        }
    }

    public GATWorker(String workerName, String workingDir, boolean debug, String installDir, String appDir, String storageConf, int computingUnitsCPU) {
        this.hostName = workerName;
        this.debug = debug;
        this.appDir = appDir;
        this.installDir = installDir;
        this.workingDir = workingDir;
        this.storageConf = storageConf;
        this.executionManager = new ExecutionManager(this, computingUnitsCPU, "disabled", 0, "disabled", 0, "disabled", 1);
        if (this.debug) {
            System.out.println("Initializing ExecutionManager");
        }
        try {
            this.executionManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(EXECUTION_MANAGER_ERR, ie);
        }
    }

    private static ImplementationDefinition parseArguments(String[] args) {
        int argPosition = 6;
        boolean debug = Boolean.valueOf(args[2]);
        AbstractMethodImplementation.MethodType methodType = AbstractMethodImplementation.MethodType.valueOf(args[argPosition++]);
        switch (methodType) {
            case METHOD: {
                return new JavaMethodDefinition(debug, args, argPosition);
            }
            case BINARY: {
                return new BinaryDefinition(debug, args, argPosition);
            }
            case MPI: {
                return new MPIDefinition(debug, args, argPosition);
            }
            case COMPSs: {
                return new COMPSsDefinition(debug, args, argPosition);
            }
            case DECAF: {
                return new DecafDefinition(debug, args, argPosition);
            }
            case MULTI_NODE: {
                return new MultiNodeDefinition(debug, args, argPosition);
            }
            case OMPSS: {
                return new OMPSsDefinition(debug, args, argPosition);
            }
            case OPENCL: {
                return new OpenCLDefinition(debug, args, argPosition);
            }
        }
        ErrorManager.error(WARN_UNSUPPORTED_METHOD_TYPE + (Object)((Object)methodType));
        return null;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public long getTracingHostID() {
        return 0L;
    }

    @Override
    public String getAppDir() {
        return this.appDir;
    }

    @Override
    public String getInstallDir() {
        return this.installDir;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public PrintStream getThreadOutStream() {
        return System.out;
    }

    @Override
    public PrintStream getThreadErrStream() {
        return System.err;
    }

    @Override
    public COMPSsConstants.TaskExecution getExecutionType() {
        return COMPSsConstants.TaskExecution.COMPSS;
    }

    @Override
    public boolean isPersistentEnabled() {
        return false;
    }

    @Override
    public LanguageParams getLanguageParams(COMPSsConstants.Lang language) {
        return null;
    }

    @Override
    public void registerOutputs(String outputsBasename) {
    }

    @Override
    public void unregisterOutputs() {
    }

    @Override
    public String getStandardStreamsPath(Invocation invocation) {
        return null;
    }

    @Override
    public String getStorageConf() {
        return this.storageConf;
    }

    @Override
    public void loadParam(InvocationParam np) throws Exception {
        switch (np.getType()) {
            case OBJECT_T: {
                String fileLocation = (String)np.getValue();
                np.setOriginalName(fileLocation);
                np.setValue(Serializer.deserialize(fileLocation));
                break;
            }
            case PSCO_T: {
                String pscoId = (String)np.getValue();
                StorageItf.getByID(pscoId);
                break;
            }
            case FILE_T: 
            case BINDING_OBJECT_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    @Override
    public void storeParam(InvocationParam np) throws Exception {
        switch (np.getType()) {
            case OBJECT_T: {
                String fileLocation = np.getOriginalName();
                Serializer.serialize(np.getValue(), fileLocation);
                break;
            }
            case PSCO_T: {
                throw new UnsupportedOperationException("Output PSCOs are not suported with the GAT adaptor");
            }
            case FILE_T: 
            case BINDING_OBJECT_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    private boolean runTask(ImplementationDefinition task) {
        final ExecutionEnd status = new ExecutionEnd();
        final Semaphore sem = new Semaphore(0);
        Execution e = new Execution(task, new ExecutionListener(){

            @Override
            public void notifyEnd(Invocation invocation, boolean success) {
                status.setSuccess(success);
                sem.release();
            }
        });
        this.executionManager.enqueue(e);
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executionManager.stop();
        return status.getSuccess();
    }
}

