/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class COMPSsNode
implements Comparable<COMPSsNode> {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final String DELETE_ERR = "Error deleting intermediate files";
    protected static final String URI_CREATION_ERR = "Error creating new URI";

    public abstract String getName();

    public abstract void start() throws InitNodeException;

    public abstract void setInternalURI(MultiURI var1) throws UnstartedNodeException;

    public abstract Job<?> newJob(int var1, TaskDescription var2, Implementation var3, Resource var4, List<String> var5, JobListener var6);

    public abstract void sendData(LogicalData var1, DataLocation var2, DataLocation var3, LogicalData var4, Transferable var5, EventListener var6);

    public abstract void obtainData(LogicalData var1, DataLocation var2, DataLocation var3, LogicalData var4, Transferable var5, EventListener var6);

    public abstract void stop(ShutdownListener var1);

    public abstract SimpleURI getCompletePath(DataType var1, String var2);

    public abstract void deleteTemporary();

    public abstract boolean generatePackage();

    public abstract void shutdownExecutionManager(ExecutorShutdownListener var1);

    public abstract boolean generateWorkersDebugInfo();

    @Override
    public int compareTo(COMPSsNode host) {
        return this.getName().compareTo(host.getName());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof COMPSsNode) {
            COMPSsNode host = (COMPSsNode)obj;
            return this.getName().equals(host.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public abstract void increaseComputingCapabilities(ResourceDescription var1);

    public abstract void reduceComputingCapabilities(ResourceDescription var1);
}

