/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.comm;

import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.exceptions.NonInstantiableException;
import es.bsc.compss.types.resources.MasterResource;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.Classpath;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public class Comm {
    private static final String STORAGE_CONF = System.getProperty("compss.storage.conf");
    private static final String ADAPTORS_REL_PATH = File.separator + "Runtime" + File.separator + "adaptors";
    private static final Map<String, CommAdaptor> adaptors = new ConcurrentHashMap<String, CommAdaptor>();
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static Map<String, LogicalData> data = Collections.synchronizedMap(new TreeMap());
    private static MasterResource appHost;

    private Comm() {
        throw new NonInstantiableException("Comm");
    }

    public static void init(MasterResource master) {
        appHost = master;
        try {
            if (STORAGE_CONF == null || STORAGE_CONF.equals("") || STORAGE_CONF.equals("null")) {
                LOGGER.warn("No storage configuration file passed");
            } else {
                LOGGER.debug("Initializing Storage with: " + STORAGE_CONF);
                StorageItf.init(STORAGE_CONF);
            }
        }
        catch (StorageException e) {
            LOGGER.fatal("Error loading storage configuration file: " + STORAGE_CONF, (Throwable)e);
            System.exit(1);
        }
        Comm.loadAdaptorsJars();
        if (System.getProperty("compss.tracing") != null && Integer.parseInt(System.getProperty("compss.tracing")) != 0) {
            int tracingLevel = Integer.parseInt(System.getProperty("compss.tracing"));
            LOGGER.debug("Tracing is activated [" + tracingLevel + ']');
            Tracer.init(tracingLevel);
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(Tracer.Event.STATIC_IT.getId(), Tracer.Event.STATIC_IT.getType());
            }
        }
    }

    public static Configuration constructConfiguration(String adaptorName, Object projectProperties, Object resourcesProperties) throws ConstructConfigurationException {
        CommAdaptor adaptor = adaptors.get(adaptorName);
        if (adaptor == null) {
            try {
                Constructor<?> constrAdaptor = Class.forName(adaptorName).getConstructor(new Class[0]);
                adaptor = (CommAdaptor)constrAdaptor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ConstructConfigurationException(e);
            }
            adaptor.init();
            adaptors.put(adaptorName, adaptor);
        }
        if (DEBUG) {
            LOGGER.debug("Adaptor Name: " + adaptorName);
        }
        return adaptor.constructConfiguration(projectProperties, resourcesProperties);
    }

    public static MasterResource getAppHost() {
        return appHost;
    }

    public static COMPSsWorker initWorker(String name, Configuration config) {
        String adaptorName = config.getAdaptorName();
        CommAdaptor adaptor = adaptors.get(adaptorName);
        return adaptor.initWorker(name, config);
    }

    public static void stop() {
        appHost.deleteIntermediate();
        for (CommAdaptor adaptor : adaptors.values()) {
            adaptor.stop();
        }
        if (STORAGE_CONF != null && !STORAGE_CONF.equals("") && !STORAGE_CONF.equals("null")) {
            try {
                LOGGER.debug("Stopping Storage...");
                StorageItf.finish();
            }
            catch (StorageException e) {
                LOGGER.error("Error releasing storage library: " + e.getMessage());
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
            Tracer.fini();
        }
    }

    public static synchronized LogicalData registerData(String dataId) {
        LOGGER.debug("Register new data " + dataId);
        LogicalData logicalData = new LogicalData(dataId);
        data.put(dataId, logicalData);
        return logicalData;
    }

    public static synchronized LogicalData registerLocation(String dataId, DataLocation location) {
        LOGGER.debug("Registering new Location for data " + dataId + ":");
        LOGGER.debug("  * Location: " + location);
        LogicalData logicalData = data.get(dataId);
        logicalData.addLocation(location);
        return logicalData;
    }

    public static synchronized LogicalData registerValue(String dataId, Object value) {
        String id;
        LOGGER.debug("Register value " + value + " for data " + dataId);
        String targetPath = DataLocation.Protocol.OBJECT_URI.getSchema() + dataId;
        DataLocation location = null;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            location = DataLocation.createLocation(appHost, uri);
        }
        catch (IOException e) {
            ErrorManager.error("ERROR: Invalid location URI " + targetPath, e);
        }
        LogicalData logicalData = data.get(dataId);
        logicalData.addLocation(location);
        logicalData.setValue(value);
        if (value instanceof StubItf && (id = ((StubItf)value).getID()) != null) {
            Comm.registerPSCO(dataId, id);
        }
        return logicalData;
    }

    public static synchronized LogicalData registerCollection(String dataId, List<?> parameters) {
        return Comm.registerValue(dataId, parameters);
    }

    public static synchronized LogicalData registerExternalPSCO(String dataId, String id) {
        LogicalData ld = Comm.registerPSCO(dataId, id);
        ld.setValue(id);
        return ld;
    }

    public static synchronized LogicalData registerBindingObject(String dataId, BindingObject bo) {
        String targetPath = DataLocation.Protocol.BINDING_URI.getSchema() + bo.toString();
        DataLocation location = null;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            location = DataLocation.createLocation(appHost, uri);
        }
        catch (IOException ioe) {
            ErrorManager.error("ERROR: Invalid location URI " + targetPath, ioe);
        }
        LogicalData logicalData = data.get(dataId);
        logicalData.addLocation(location);
        logicalData.setValue(dataId + "#" + bo.getType() + "#" + bo.getElements());
        return logicalData;
    }

    public static synchronized LogicalData registerPSCO(String dataId, String id) {
        String targetPath = DataLocation.Protocol.PERSISTENT_URI.getSchema() + id;
        DataLocation location = null;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            location = DataLocation.createLocation(appHost, uri);
        }
        catch (IOException ioe) {
            ErrorManager.error("ERROR: Invalid location URI " + targetPath, ioe);
        }
        LogicalData logicalData = data.get(dataId);
        logicalData.addLocation(location);
        return logicalData;
    }

    public static synchronized Object clearValue(String dataId) {
        LOGGER.debug("Clear value of data " + dataId);
        LogicalData logicalData = data.get(dataId);
        return logicalData.removeValue();
    }

    public static synchronized boolean existsData(String renaming) {
        return data.get(renaming) != null;
    }

    public static synchronized LogicalData getData(String dataId) {
        LogicalData retVal = data.get(dataId);
        if (retVal == null) {
            LOGGER.warn("Get data " + dataId + " is null.");
        }
        return retVal;
    }

    public static synchronized String dataDump() {
        StringBuilder sb = new StringBuilder("DATA DUMP\n");
        for (Map.Entry<String, LogicalData> lde : data.entrySet()) {
            sb.append("\t *").append(lde.getKey()).append(":\n");
            LogicalData ld = lde.getValue();
            for (MultiURI u : ld.getURIs()) {
                sb.append("\t\t + ").append(u.toString()).append("\n");
                for (String adaptor : adaptors.keySet()) {
                    Object internal = null;
                    try {
                        internal = u.getInternalURI(adaptor);
                        if (internal == null) continue;
                        sb.append("\t\t\t - ").append(internal.toString()).append("\n");
                    }
                    catch (UnstartedNodeException unstartedNodeException) {}
                }
            }
        }
        return sb.toString();
    }

    public static Set<LogicalData> getAllData(Resource host) {
        return host.getAllDataFromHost();
    }

    public static synchronized void removeData(String renaming) {
        LOGGER.debug("Removing data " + renaming);
        LogicalData ld = data.remove(renaming);
        ld.isObsolete();
        for (DataLocation dl : ld.getLocations()) {
            File f;
            MultiURI uri = dl.getURIInHost(appHost);
            if (uri == null || !(f = new File(uri.getPath())).exists()) continue;
            LOGGER.info("Deleting file " + f.getAbsolutePath());
            if (f.delete()) continue;
            LOGGER.error("Cannot delete file " + f.getAbsolutePath());
        }
        ld.removeValue();
    }

    public static Map<String, CommAdaptor> getAdaptors() {
        return adaptors;
    }

    public static void stopSubmittedjobs() {
        for (CommAdaptor adaptor : adaptors.values()) {
            adaptor.stopSubmittedJobs();
        }
    }

    private static void loadAdaptorsJars() {
        LOGGER.info("Loading Adaptors...");
        String compssHome = System.getenv("COMPSS_HOME");
        if (compssHome == null || compssHome.isEmpty()) {
            LOGGER.warn("WARN: COMPSS_HOME not defined, no adaptors loaded.");
            return;
        }
        try {
            Classpath.loadPath(compssHome + ADAPTORS_REL_PATH, LOGGER);
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("WARN_MSG = [Adaptors folder not defined, no adaptors loaded.]");
        }
    }
}

