/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.JavaParams;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.COMPSsImplementation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class COMPSsInvoker
extends Invoker {
    private static final String RELATIVE_PATH_XML_GENERATION = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "xmls" + File.separator;
    private static final String GENERATE_PROJECT_SCRIPT = "generate_project.sh";
    private static final String GENERATE_RESOURCES_SCRIPT = "generate_resources.sh";
    private static final int NUM_BASE_COMPSS_ARGS = 5;
    private static final String ERROR_RUNCOMPSS = "ERROR: Invalid runcompss";
    private static final String ERROR_APP_NAME = "ERROR: Invalid appName";
    private static final String ERROR_TARGET_PARAM = "ERROR: COMPSs Execution doesn't support target parameters";
    private final String runcompss;
    private final String extraFlags;
    private final String appName;
    private final String workerInMaster;

    public COMPSsInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, ResourceManager.InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        COMPSsImplementation compssImpl = null;
        try {
            compssImpl = (COMPSsImplementation)this.invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.invocation.getMethodImplementation().getMethodType()), e);
        }
        this.runcompss = compssImpl.getRuncompss();
        this.extraFlags = compssImpl.getFlags();
        this.appName = compssImpl.getAppName();
        this.workerInMaster = compssImpl.getWorkerInMaster();
    }

    private void checkArguments() throws JobExecutionException {
        if (this.runcompss == null || this.runcompss.isEmpty()) {
            throw new JobExecutionException(ERROR_RUNCOMPSS);
        }
        if (this.appName == null || this.appName.isEmpty()) {
            throw new JobExecutionException(ERROR_APP_NAME);
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoked " + this.appName + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException(iee);
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            if (invocationParam.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(invocationParam, retValue);
                continue;
            }
            invocationParam.setValue(retValue);
            invocationParam.setValueClass(retValue.getClass());
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String nestedLogDirFlag;
        System.out.println("");
        System.out.println("[COMPSs INVOKER] Begin COMPSs call to " + this.appName);
        System.out.println("[COMPSs INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
        HashMap<String, Integer> hostnames2cus = new HashMap<String, Integer>();
        for (String hostname : this.invocation.getSlaveNodesNames()) {
            if (hostnames2cus.containsKey(hostname)) {
                int accumComputingUnits = (Integer)hostnames2cus.get(hostname) + this.computingUnits;
                hostnames2cus.put(hostname, accumComputingUnits);
                continue;
            }
            hostnames2cus.put(hostname, this.computingUnits);
        }
        if (!Boolean.parseBoolean(this.workerInMaster)) {
            String hostname = this.context.getHostName();
            if (hostnames2cus.containsKey(hostname)) {
                int accumComputingUnits = (Integer)hostnames2cus.remove(hostname);
                if ((accumComputingUnits -= this.computingUnits) > 0) {
                    hostnames2cus.put(hostname, accumComputingUnits);
                }
            } else {
                System.err.println("[WARN] Cannot reserve master CUs because hostname does not appear in slavenodes");
            }
            if (hostnames2cus.isEmpty()) {
                throw new InvokeExecutionException("Error no remaining resources after reserving nested master");
            }
        }
        StringBuilder workersInfoBuilder = new StringBuilder();
        for (Map.Entry entry : hostnames2cus.entrySet()) {
            String hostname = (String)entry.getKey();
            Integer cus = (Integer)entry.getValue();
            System.out.println("[COMPSs INVOKER] Slave hostname " + hostname + " with " + String.valueOf(cus) + " cus");
            workersInfoBuilder.append(hostname);
            workersInfoBuilder.append(":").append(String.valueOf(cus));
            workersInfoBuilder.append(":").append(this.context.getInstallDir());
            workersInfoBuilder.append(":").append(this.taskSandboxWorkingDir.getAbsolutePath());
            workersInfoBuilder.append(" ");
        }
        String workersInfo = workersInfoBuilder.toString();
        String uuid = UUID.randomUUID().toString();
        String projectXml = "project_" + uuid + ".xml";
        String resourcesXml = "resources_" + uuid + ".xml";
        System.out.println("[COMPSs INVOKER] Generate project.xml at: " + projectXml);
        String generateProjectScript = this.context.getInstallDir() + RELATIVE_PATH_XML_GENERATION + GENERATE_PROJECT_SCRIPT;
        String[] cmdProject = new String[]{generateProjectScript, projectXml, workersInfo};
        try {
            int ev = this.xmlGenerationScript(cmdProject);
            if (ev != 0) {
                throw new InvokeExecutionException("Error generating project.xml file (ev = " + ev + ")");
            }
        }
        catch (IOException ioe) {
            throw new InvokeExecutionException("Error generating project.xml file", ioe);
        }
        catch (InterruptedException ie) {
            throw new InvokeExecutionException("Error generating project.xml file", ie);
        }
        System.out.println("[COMPSs INVOKER] Generate resources.xml at: " + resourcesXml);
        String generateResourcesScript = this.context.getInstallDir() + RELATIVE_PATH_XML_GENERATION + GENERATE_RESOURCES_SCRIPT;
        String[] cmdResources = new String[]{generateResourcesScript, resourcesXml, workersInfo};
        try {
            int ev = this.xmlGenerationScript(cmdResources);
            if (ev != 0) {
                throw new InvokeExecutionException("Error generating resources.xml file (ev = " + ev + ")");
            }
        }
        catch (IOException ioe) {
            throw new InvokeExecutionException("Error generating resources.xml file", ioe);
        }
        catch (InterruptedException ie) {
            throw new InvokeExecutionException("Error generating resources.xml file", ie);
        }
        String nestedLogDir = this.taskSandboxWorkingDir.getAbsolutePath() + File.separator + "nestedCOMPSsLog";
        JavaParams javaParams = (JavaParams)this.context.getLanguageParams(COMPSsConstants.Lang.JAVA);
        String classpathFlag = "--classpath=" + javaParams.getClasspath();
        ArrayList<String> extraFlagsList = new ArrayList<String>();
        if (this.extraFlags != null && !this.extraFlags.isEmpty()) {
            List<String> partialExtraFlagsList = Arrays.asList(this.extraFlags.split(" "));
            for (String flag : partialExtraFlagsList) {
                int beginPos;
                if (flag.startsWith("--base_log_dir=")) {
                    System.out.println("[COMPSs INVOKER] Capturing flag " + flag);
                    System.out.println("[COMPSs INVOKER] Generating random UUID as specific_log_dir inside base_log_dir");
                    beginPos = "--base_log_dir=".length();
                    nestedLogDir = flag.substring(beginPos) + File.separator + UUID.randomUUID();
                    continue;
                }
                if (flag.startsWith("--specific_log_dir=")) {
                    System.out.println("[COMPSs INVOKER] Ommitting flag " + flag + " on nested runcompss command");
                    continue;
                }
                if (flag.startsWith("--classpath=")) {
                    beginPos = "--classpath=".length();
                    classpathFlag = classpathFlag + ":" + flag.substring(beginPos);
                    continue;
                }
                extraFlagsList.add(flag);
            }
        }
        System.out.println("[COMPSs INVOKER] Creating nested log dir in: " + nestedLogDir);
        if (!new File(nestedLogDir).mkdir()) {
            throw new InvokeExecutionException("Error creating COMPSs nested log directory " + nestedLogDir);
        }
        BinaryRunner.StreamSTD streamValues = new BinaryRunner.StreamSTD();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues);
        String[] cmd = new String[5 + extraFlagsList.size() + 1 + binaryParams.size()];
        cmd[0] = this.runcompss;
        cmd[1] = "--project=" + projectXml;
        cmd[2] = "--resources=" + resourcesXml;
        cmd[3] = nestedLogDirFlag = "--specific_log_dir=" + nestedLogDir;
        cmd[4] = classpathFlag;
        int i = 5;
        for (String flag : extraFlagsList) {
            cmd[i++] = flag;
        }
        cmd[i++] = this.appName;
        for (String param : binaryParams) {
            cmd[i++] = param;
        }
        System.out.print("[COMPSs INVOKER] COMPSs CMD: ");
        for (int index = 0; index < cmd.length; ++index) {
            System.out.print(cmd[index] + " ");
        }
        System.out.println("");
        System.out.println("[COMPSs INVOKER] COMPSs STDIN: " + streamValues.getStdIn());
        System.out.println("[COMPSs INVOKER] COMPSs STDOUT: " + streamValues.getStdOut());
        System.out.println("[COMPSs INVOKER] COMPSs STDERR: " + streamValues.getStdErr());
        return BinaryRunner.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream());
    }

    private int xmlGenerationScript(String[] cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(this.taskSandboxWorkingDir);
        builder.environment().remove("LD_PRELOAD");
        Process process = builder.start();
        process.getOutputStream().close();
        return process.waitFor();
    }
}

