/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.job;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Job<T extends COMPSsWorker> {
    protected static final int FIRST_JOB_ID = 1;
    protected static int nextJobId = 1;
    private static final String CLASSPATH_FROM_ENV = System.getProperty("compss.worker.cp") != null && !System.getProperty("compss.worker.cp").equals("") ? System.getProperty("compss.worker.cp") : "\"\"";
    private final String workerClasspath;
    private static final String PYTHONPATH_FROM_ENV = System.getProperty("compss.worker.pythonpath") != null && !System.getProperty("compss.worker.pythonpath").equals("") ? System.getProperty("compss.worker.pythonpath") : "\"\"";
    private final String workerPythonpath;
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected int jobId = nextJobId++;
    protected final int taskId;
    protected final TaskDescription taskParams;
    protected final Implementation impl;
    protected final Resource worker;
    protected final JobListener listener;
    protected JobHistory history;
    protected int transferId;

    public Job(int taskId, TaskDescription task, Implementation impl, Resource res, JobListener listener) {
        this.taskId = taskId;
        this.history = JobHistory.NEW;
        this.taskParams = task;
        this.impl = impl;
        this.worker = res;
        this.listener = listener;
        String classpathFromFile = ((COMPSsWorker)this.getResourceNode()).getClasspath();
        this.workerClasspath = !classpathFromFile.equals("") ? (!CLASSPATH_FROM_ENV.equals("") ? CLASSPATH_FROM_ENV + ":" + classpathFromFile : classpathFromFile) : CLASSPATH_FROM_ENV;
        String pythonpathFromFile = ((COMPSsWorker)this.getResourceNode()).getPythonpath();
        this.workerPythonpath = !pythonpathFromFile.equals("") ? (!PYTHONPATH_FROM_ENV.equals("") ? PYTHONPATH_FROM_ENV + ":" + pythonpathFromFile : pythonpathFromFile) : PYTHONPATH_FROM_ENV;
    }

    public COMPSsConstants.Lang getLang() {
        return this.taskParams.getLang();
    }

    public int getJobId() {
        return this.jobId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public TaskDescription getTaskParams() {
        return this.taskParams;
    }

    public JobHistory getHistory() {
        return this.history;
    }

    public void setHistory(JobHistory newHistoryState) {
        this.history = newHistoryState;
    }

    public Resource getResource() {
        return this.worker;
    }

    public String getClasspath() {
        return this.workerClasspath;
    }

    public String getPythonpath() {
        return this.workerPythonpath;
    }

    public T getResourceNode() {
        return (T)((COMPSsWorker)this.worker.getNode());
    }

    public JobListener getListener() {
        return this.listener;
    }

    public Implementation getImplementation() {
        return this.impl;
    }

    public void setTransferGroupId(int transferId) {
        this.transferId = transferId;
    }

    public int getTransferGroupId() {
        return this.transferId;
    }

    public Object getReturnValue() {
        return null;
    }

    public abstract void submit() throws Exception;

    public abstract void stop() throws Exception;

    public abstract String getHostName();

    public abstract Implementation.TaskType getType();

    public abstract String toString();

    public static enum JobHistory {
        NEW,
        RESUBMITTED_FILES,
        RESUBMITTED,
        FAILED;

    }
}

