/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.util;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.util.StreamGobbler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;

public class BinaryRunner {
    private static final String ERROR_PARAM_NOT_STRING = "ERROR: Binary parameter cannot be serialized to string";
    private static final String ERROR_OUTPUTREADER = "ERROR: Cannot retrieve command output";
    private static final String ERROR_ERRORREADER = "ERROR: Cannot retrieve command error";
    private static final String ERROR_PROC_EXEC = "ERROR: Exception executing Binary command";

    public static ArrayList<String> createCMDParametersFromValues(List<? extends InvocationParam> parameters, InvocationParam target, StreamSTD streamValues) throws InvokeExecutionException {
        ArrayList<String> binaryParams = new ArrayList<String>();
        for (InvocationParam invocationParam : parameters) {
            binaryParams.addAll(BinaryRunner.processParam(invocationParam, streamValues));
        }
        if (target != null) {
            binaryParams.addAll(BinaryRunner.processParam(target, streamValues));
        }
        return binaryParams;
    }

    private static ArrayList<String> processParam(InvocationParam param, StreamSTD streamValues) throws InvokeExecutionException {
        ArrayList<String> binaryParam = new ArrayList<String>();
        switch (param.getStream()) {
            case STDIN: {
                streamValues.setStdIn((String)param.getValue());
                break;
            }
            case STDOUT: {
                streamValues.setStdOut((String)param.getValue());
                break;
            }
            case STDERR: {
                streamValues.setStdErr((String)param.getValue());
                break;
            }
            case UNSPECIFIED: {
                if (param.getPrefix().equals("#")) break;
                if (param.getValue() != null && param.getValue().getClass().isArray()) {
                    try {
                        if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
                            binaryParam.add(param.getPrefix());
                        }
                        binaryParam.addAll(BinaryRunner.serializeArrayParam(param.getValue()));
                        break;
                    }
                    catch (Exception e) {
                        throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
                    }
                }
                if (param.getValue() != null && param.getValue() instanceof Collection) {
                    try {
                        if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
                            binaryParam.add(param.getPrefix());
                        }
                        binaryParam.addAll(BinaryRunner.serializeCollectionParam((Collection)param.getValue()));
                        break;
                    }
                    catch (Exception e) {
                        throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
                    }
                }
                if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
                    if (param.getType().equals((Object)DataType.FILE_T)) {
                        binaryParam.add(param.getPrefix() + String.valueOf(param.getOriginalName()));
                        break;
                    }
                    binaryParam.add(param.getPrefix() + String.valueOf(param.getValue()));
                    break;
                }
                if (param.getType().equals((Object)DataType.FILE_T)) {
                    binaryParam.add(String.valueOf(param.getOriginalName()));
                    break;
                }
                binaryParam.add(String.valueOf(param.getValue()));
            }
        }
        return binaryParam;
    }

    public static Object executeCMD(String[] cmd, StreamSTD streamValues, File taskSandboxWorkingDir, PrintStream outLog, PrintStream errLog) throws InvokeExecutionException {
        String fileErrPath;
        String fileOutPath;
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(taskSandboxWorkingDir);
        builder.environment().remove("LD_PRELOAD");
        builder.environment().put("COMPSS_HOSTNAMES", System.getProperty("COMPSS_HOSTNAMES"));
        builder.environment().put("COMPSS_NUM_NODES", System.getProperty("COMPSS_NUM_NODES"));
        builder.environment().put("COMPSS_NUM_THREADS", System.getProperty("COMPSS_NUM_THREADS"));
        builder.environment().put("OMP_NUM_THREADS", System.getProperty("OMP_NUM_THREADS"));
        String fileInPath = streamValues.getStdIn();
        if (fileInPath != null) {
            builder.redirectInput(new File(fileInPath));
        }
        if ((fileOutPath = streamValues.getStdOut()) != null) {
            builder.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(fileOutPath)));
        }
        if ((fileErrPath = streamValues.getStdErr()) != null) {
            builder.redirectError(ProcessBuilder.Redirect.appendTo(new File(fileErrPath)));
        }
        Process process = null;
        int exitValue = -1;
        try {
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
            outLog.println("[BINARY EXECUTION WRAPPER] Executing binary command");
            process = builder.start();
            process.getOutputStream().close();
            BinaryRunner.logBinaryExecution(process, fileOutPath, fileErrPath, outLog, errLog);
            exitValue = process.waitFor();
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
            outLog.println("[BINARY EXECUTION WRAPPER] CMD EXIT VALUE: " + exitValue);
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        }
        catch (InvokeExecutionException | IOException | InterruptedException e) {
            errLog.println(ERROR_PROC_EXEC);
            throw new InvokeExecutionException(ERROR_PROC_EXEC, e);
        }
        return exitValue;
    }

    private static void logBinaryExecution(Process process, String fileOutPath, String fileErrPath, PrintStream outLog, PrintStream errLog) throws InvokeExecutionException {
        Throwable throwable;
        Thread errorGobbler = null;
        StreamGobbler outputGobbler = null;
        outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        outLog.println("[BINARY EXECUTION WRAPPER] CMD OUTPUT:");
        if (process != null) {
            if (fileOutPath == null) {
                outputGobbler = new StreamGobbler(process.getInputStream(), outLog, LogManager.getLogger("es.bsc.compss.Worker"));
                outputGobbler.start();
            } else {
                try {
                    throwable = null;
                    try (FileInputStream outputStream = new FileInputStream(fileOutPath);){
                        outputGobbler = new StreamGobbler(outputStream, outLog, LogManager.getLogger("es.bsc.compss.Worker"));
                        outputGobbler.start();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException ioe) {
                    errLog.println(ERROR_OUTPUTREADER);
                    ioe.printStackTrace(errLog);
                    throw new InvokeExecutionException(ERROR_OUTPUTREADER, ioe);
                }
            }
        }
        errLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        errLog.println("[BINARY EXECUTION WRAPPER] CMD ERROR:");
        if (process != null) {
            if (fileErrPath == null) {
                errorGobbler = new StreamGobbler(process.getErrorStream(), errLog, LogManager.getLogger("es.bsc.compss.Worker"));
                errorGobbler.start();
            } else {
                try {
                    throwable = null;
                    try (FileInputStream errStream = new FileInputStream(fileErrPath);){
                        errorGobbler = new StreamGobbler(errStream, errLog, LogManager.getLogger("es.bsc.compss.Worker"));
                        errorGobbler.start();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException ioe) {
                    throw new InvokeExecutionException(ERROR_ERRORREADER, ioe);
                }
            }
        }
        if (outputGobbler != null) {
            try {
                outputGobbler.join();
            }
            catch (InterruptedException e) {
                errLog.println("Error waiting for output gobbler to end");
                e.printStackTrace();
            }
        }
        outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        if (errorGobbler != null) {
            try {
                errorGobbler.join();
            }
            catch (InterruptedException e) {
                errLog.println("Error waiting for error gobbler to end");
                e.printStackTrace();
            }
        }
        errLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
    }

    private static ArrayList<String> serializeArrayParam(Object value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        if (value instanceof int[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof boolean[]) {
            boolean[] arrayValues;
            for (boolean paramValue : arrayValues = (boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof byte[]) {
            byte[] arrayValues;
            for (byte paramValue : arrayValues = (byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof short[]) {
            short[] arrayValues;
            for (short paramValue : arrayValues = (short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof char[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof long[]) {
            long[] arrayValues;
            for (long paramValue : arrayValues = (long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof float[]) {
            float[] arrayValues;
            for (float paramValue : arrayValues = (float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof double[]) {
            double[] arrayValues;
            for (double paramValue : arrayValues = (double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Integer[]) {
            Integer[] arrayValues;
            for (Integer paramValue : arrayValues = (Integer[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Boolean[]) {
            Boolean[] arrayValues;
            for (Boolean paramValue : arrayValues = (Boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Character[]) {
            Character[] arrayValues;
            for (Character paramValue : arrayValues = (Character[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Byte[]) {
            Byte[] arrayValues;
            for (Byte paramValue : arrayValues = (Byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Short[]) {
            Short[] arrayValues;
            for (Short paramValue : arrayValues = (Short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Long[]) {
            Long[] arrayValues;
            for (Long paramValue : arrayValues = (Long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Float[]) {
            Float[] arrayValues;
            for (Float paramValue : arrayValues = (Float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Double[]) {
            Double[] arrayValues;
            for (Double paramValue : arrayValues = (Double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof String[]) {
            String[] arrayValues;
            for (String paramValue : arrayValues = (String[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Object[]) {
            Object[] arrayValues;
            for (Object paramValue : arrayValues = (Object[])value) {
                serializedValue.addAll(BinaryRunner.serializeArrayParam(paramValue));
            }
        } else {
            serializedValue.add(String.valueOf(value));
        }
        return serializedValue;
    }

    private static ArrayList<String> serializeCollectionParam(Collection<?> value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        Iterator<?> iterator = value.iterator();
        while (iterator.hasNext()) {
            serializedValue.add(String.valueOf(iterator.next()));
        }
        return serializedValue;
    }

    public static class StreamSTD {
        private String stdIn = null;
        private String stdOut = null;
        private String stdErr = null;

        public String getStdIn() {
            return this.stdIn;
        }

        public String getStdOut() {
            return this.stdOut;
        }

        public String getStdErr() {
            return this.stdErr;
        }

        public void setStdIn(String stdIn) {
            this.stdIn = stdIn;
        }

        public void setStdOut(String stdOut) {
            this.stdOut = stdOut;
        }

        public void setStdErr(String stdErr) {
            this.stdErr = stdErr;
        }
    }
}

