/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.external.piped;

import es.bsc.compss.executor.external.piped.ControlPipePair;
import es.bsc.compss.executor.external.piped.PipeElementInfo;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.executor.external.piped.commands.AliveGetPipeCommand;
import es.bsc.compss.executor.external.piped.commands.AliveReplyPipeCommand;
import es.bsc.compss.executor.external.piped.exceptions.ClosedPipeException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MirrorMonitor {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final long MONITORING_PERIOD = 5000L;
    private final Thread monitorThread;
    private Process mainProcess;
    private ControlPipePair controlPipe;
    private boolean keepAlive = false;
    private Map<String, PipeWorkerInfo> workers = new TreeMap<String, PipeWorkerInfo>();
    private Map<String, PipeExecutorInfo> executors = new TreeMap<String, PipeExecutorInfo>();
    private final List<String> unremovedElements = new LinkedList<String>();

    public MirrorMonitor() {
        this.monitorThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MirrorMonitor.this.monitor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MirrorMonitor mirrorMonitor = MirrorMonitor.this;
                synchronized (mirrorMonitor) {
                    MirrorMonitor.this.notify();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor() {
        long lastMonitored = System.currentTimeMillis();
        while (this.keepAlive) {
            Map<String, PipeExecutorInfo> executors;
            Map<String, PipeWorkerInfo> workers;
            long sleepTime = lastMonitored + 5000L - System.currentTimeMillis();
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            if (Thread.interrupted()) break;
            lastMonitored = System.currentTimeMillis();
            if (this.mainProcess != null && !this.mainProcess.isAlive()) {
                this.controlPipe.noLongerExists();
                this.controlPipe.delete();
                this.controlPipe = null;
                this.mainProcess = null;
            }
            if (Thread.interrupted()) break;
            MirrorMonitor mirrorMonitor = this;
            synchronized (mirrorMonitor) {
                workers = this.workers;
                executors = this.executors;
                this.workers = new TreeMap<String, PipeWorkerInfo>();
                this.executors = new TreeMap<String, PipeExecutorInfo>();
                this.unremovedElements.clear();
            }
            LinkedList<PipeElementInfo> elementsInfo = new LinkedList<PipeElementInfo>();
            elementsInfo.addAll(workers.values());
            elementsInfo.addAll(executors.values());
            if (elementsInfo.size() > 0) {
                Object id;
                AliveReplyPipeCommand reply;
                AliveGetPipeCommand aliveRequest = new AliveGetPipeCommand(elementsInfo);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder aliveQuery = new StringBuilder("Piped mirrors monitor obtaining alive processes. Checking processes ");
                    for (PipeElementInfo info : elementsInfo) {
                        aliveQuery.append(" ").append(info.getPID());
                    }
                    LOGGER.debug(aliveQuery.toString());
                }
                if (this.controlPipe.sendCommand(aliveRequest)) {
                    reply = new AliveReplyPipeCommand();
                    try {
                        this.controlPipe.waitForCommand(reply);
                    }
                    catch (ClosedPipeException ie) {
                        LOGGER.debug("Piped mirrors monitor could not obtain the alive processes - Pipe was closed");
                    }
                } else {
                    LOGGER.debug("Piped mirrors monitor could not obtain the alive processes - Message couldn't be sent");
                    continue;
                }
                List<Integer> aliveProcesses = reply.getAliveProcesses();
                Iterator<Map.Entry<String, PipeWorkerInfo>> workerItr = workers.entrySet().iterator();
                while (workerItr.hasNext() && !Thread.currentThread().isInterrupted()) {
                    boolean removed;
                    PipeElementInfo info;
                    Map.Entry<String, PipeWorkerInfo> pair = workerItr.next();
                    info = pair.getValue();
                    if (aliveProcesses.contains(info.getPID())) {
                        MirrorMonitor mirrorMonitor2 = this;
                        synchronized (mirrorMonitor2) {
                            this.workers.put(pair.getKey(), pair.getValue());
                            continue;
                        }
                    }
                    MirrorMonitor mirrorMonitor3 = this;
                    synchronized (mirrorMonitor3) {
                        id = pair.getKey();
                        removed = this.unremovedElements.remove(id);
                    }
                    if (removed) continue;
                    LOGGER.debug("Piped mirrors monitor has detected that worker process " + info.getPID() + " has died.");
                    ControlPipePair workerPipe = ((PipeWorkerInfo)info).getPipe();
                    workerPipe.noLongerExists();
                    workerPipe.delete();
                }
                Iterator<Map.Entry<String, PipeExecutorInfo>> executorItr = executors.entrySet().iterator();
                while (executorItr.hasNext() && !Thread.currentThread().isInterrupted()) {
                    boolean removed;
                    Map.Entry<String, PipeExecutorInfo> pair = executorItr.next();
                    PipeExecutorInfo info = pair.getValue();
                    if (aliveProcesses.contains(info.getPID())) {
                        MirrorMonitor workerPipe = this;
                        synchronized (workerPipe) {
                            this.executors.put(pair.getKey(), pair.getValue());
                            continue;
                        }
                    }
                    id = this;
                    synchronized (id) {
                        String id2 = pair.getKey();
                        removed = this.unremovedElements.remove(id2);
                    }
                    if (removed) continue;
                    PipePair workerPipe = info.getPipe();
                    LOGGER.debug("Piped mirrors monitor has detected that executor process " + info.getPID() + " has died.");
                    workerPipe.noLongerExists();
                    workerPipe.delete();
                    PipedMirror mirror = info.getMirror();
                    String executorId = info.getExecutorId();
                    mirror.unregisterExecutor(executorId);
                }
            }
            if (!Thread.interrupted()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MirrorMonitor mirrorMonitor = this;
        synchronized (mirrorMonitor) {
            this.keepAlive = true;
            this.monitorThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOGGER.debug("Stopping monitor");
        MirrorMonitor mirrorMonitor = this;
        synchronized (mirrorMonitor) {
            this.keepAlive = false;
            this.monitorThread.interrupt();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void mainProcess(Process piper, ControlPipePair pipe) {
        this.mainProcess = piper;
        this.controlPipe = pipe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWorker(String workerName, int workerPID, ControlPipePair workerControlPipe) {
        PipeWorkerInfo info = new PipeWorkerInfo(workerPID, workerControlPipe);
        MirrorMonitor mirrorMonitor = this;
        synchronized (mirrorMonitor) {
            this.workers.put(workerName, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterWorker(String workerName) {
        MirrorMonitor mirrorMonitor = this;
        synchronized (mirrorMonitor) {
            PipeWorkerInfo info = this.workers.remove(workerName);
            if (info == null) {
                this.unremovedElements.add(workerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExecutor(PipedMirror mirror, String executorId, int executorPId, PipePair pipe) {
        PipeExecutorInfo info = new PipeExecutorInfo(mirror, executorId, executorPId, pipe);
        MirrorMonitor mirrorMonitor = this;
        synchronized (mirrorMonitor) {
            this.executors.put(mirror.getMirrorId() + "_" + executorId, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExecutor(PipedMirror mirror, String executorId) {
        String id = mirror.getMirrorId() + "_" + executorId;
        MirrorMonitor mirrorMonitor = this;
        synchronized (mirrorMonitor) {
            PipeExecutorInfo info = this.executors.remove(id);
            if (info == null) {
                this.unremovedElements.add(id);
            }
        }
    }

    private static class PipeExecutorInfo
    extends PipeElementInfo {
        private final PipedMirror mirror;
        private final String executorId;
        private final PipePair pipe;

        public PipeExecutorInfo(PipedMirror mirror, String executorId, Integer pid, PipePair pipe) {
            super(pid);
            this.mirror = mirror;
            this.executorId = executorId;
            this.pipe = pipe;
        }

        public PipedMirror getMirror() {
            return this.mirror;
        }

        public String getExecutorId() {
            return this.executorId;
        }

        public PipePair getPipe() {
            return this.pipe;
        }
    }

    private static class PipeWorkerInfo
    extends PipeElementInfo {
        private final ControlPipePair pipe;

        public PipeWorkerInfo(Integer pid, ControlPipePair pipe) {
            super(pid);
            this.pipe = pipe;
        }

        public ControlPipePair getPipe() {
            return this.pipe;
        }
    }
}

