/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.resources.ContainerDescription;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ContainerImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 3;
    public static final String SIGNATURE = "container.CONTAINER";
    private ContainerDescription container;
    private String binary;

    public ContainerImplementation() {
    }

    public ContainerImplementation(ContainerDescription container, String binary, Integer coreId, Integer implementationId, String signature, MethodResourceDescription annot) {
        super(coreId, implementationId, signature, annot);
        this.container = container;
    }

    public ContainerDescription getContainer() {
        return this.container;
    }

    public String getBinary() {
        return this.binary;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.CONTAINER;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[CONTAINER=").append(this.container);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return "ContainerImplementation [container=" + this.container + ", binary=" + this.binary + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.container = (ContainerDescription)in.readObject();
        this.binary = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.container);
        out.writeObject(this.binary);
    }
}

