/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.ContainerImplementation;
import es.bsc.compss.types.resources.ContainerDescription;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class ContainerInvoker
extends Invoker {
    private static final int NUM_BASE_DOCKER_PYTHON_ARGS = 23;
    private static final int NUM_BASE_DOCKER_BINARY_ARGS = 10;
    private static final int NUM_BASE_SINGULARITY_PYTHON_ARGS = 19;
    private static final int NUM_BASE_SINGULARITY_BINARY_ARGS = 8;
    private static final String REL_PATH_WD = ".." + File.separator + ".." + File.separator;
    private static final String REL_PATH_WORKER_CONTAINER = File.separator + "pycompss" + File.separator + "worker" + File.separator + "container" + File.separator + "container_worker.py";
    private final ContainerDescription container;
    private final ContainerImplementation.ContainerExecutionType internalExecutionType;
    private final String internalBinary;
    private final String internalFunction;
    private final String customWorkingDir;
    private final boolean failByEV;
    private BinaryRunner br;

    public ContainerInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        ContainerImplementation containerImpl = null;
        try {
            containerImpl = (ContainerImplementation)invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()), e);
        }
        this.container = containerImpl.getContainer();
        this.internalExecutionType = containerImpl.getInternalExecutionType();
        this.internalBinary = containerImpl.getInternalBinary();
        this.internalFunction = containerImpl.getInternalFunction();
        this.customWorkingDir = containerImpl.getWorkingDir();
        this.failByEV = containerImpl.isFailByEV();
        this.br = null;
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        LOGGER.info("Invoked Container execution (internalType = " + (Object)((Object)this.internalExecutionType) + ", internalBinary = " + this.internalBinary + ", internalFunction = " + this.internalFunction + ") in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            LOGGER.error("Exception running container", (Throwable)iee);
            throw new JobExecutionException(iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams languageParams = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (languageParams instanceof PythonParams) {
                    PythonParams pp = (PythonParams)languageParams;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException(se);
        }
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("Python Container Execution of Job " + this.invocation.getJobId() + " (Task " + this.invocation.getTaskId() + ") has exit value " + retValue.toString());
                break;
            }
            case CET_BINARY: {
                for (InvocationParam invocationParam : this.invocation.getResults()) {
                    if (invocationParam.getType() == DataType.FILE_T) {
                        this.serializeBinaryExitValue(invocationParam, retValue);
                        continue;
                    }
                    invocationParam.setValue(retValue);
                    invocationParam.setValueClass(retValue.getClass());
                }
                break;
            }
        }
        if (this.failByEV && !retValue.toString().equals("0")) {
            throw new JobExecutionException("Received non-zero exit value (" + retValue.toString() + ") for Job " + this.invocation.getJobId() + " (Task " + this.invocation.getTaskId() + ")");
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String appDir;
        String pythonInterpreter = null;
        String pythonVersion = null;
        String pythonPath = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.getPythonInterpreter();
            pythonVersion = pp.getPythonVersion();
            pythonPath = pp.getPythonPath();
        }
        String workingDir = this.customWorkingDir != null && !this.customWorkingDir.isEmpty() && !this.customWorkingDir.equals("[unassigned]") ? this.customWorkingDir : this.taskSandboxWorkingDir.getAbsolutePath();
        String workingDirMountPoint = workingDir = workingDir.endsWith(File.separator) ? workingDir : workingDir + File.separator;
        if (workingDirMountPoint.contains("sandBox")) {
            workingDirMountPoint = workingDirMountPoint + REL_PATH_WD;
        }
        appDir = (appDir = this.context.getAppDir()).endsWith(File.separator) ? appDir : appDir + File.separator;
        String pyCompssDir = this.context.getInstallDir();
        pyCompssDir = pyCompssDir.endsWith(File.separator) ? pyCompssDir : pyCompssDir + File.separator;
        pyCompssDir = pyCompssDir + "Bindings" + File.separator + "python" + File.separator + pythonVersion;
        boolean hasTarget = false;
        String returnType = "null";
        int returnLength = 0;
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                hasTarget = this.invocation.getTarget() != null;
                List<? extends InvocationParam> results = this.invocation.getResults();
                if (results == null || results.isEmpty()) break;
                returnType = String.valueOf(DataType.FILE_T.ordinal());
                returnLength = results.size();
                break;
            }
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> containerCallParams = new ArrayList<String>();
        int numContainerCallParams = 0;
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                InvocationParam userParam;
                int i;
                if (hasTarget) {
                    this.addParamInfo(containerCallParams, this.invocation.getTarget());
                    ++numContainerCallParams;
                }
                if (returnLength > 0) {
                    for (i = 0; i < this.invocation.getResults().size(); ++i) {
                        userParam = this.invocation.getResults().get(i);
                        this.addParamInfo(containerCallParams, userParam);
                        ++numContainerCallParams;
                    }
                }
                for (i = 0; i < this.invocation.getParams().size(); ++i) {
                    userParam = this.invocation.getParams().get(i);
                    this.addParamInfo(containerCallParams, userParam);
                    ++numContainerCallParams;
                }
                break;
            }
            case CET_BINARY: {
                containerCallParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
            }
        }
        int numCmdArgs = 0;
        block7 : switch (this.container.getEngine()) {
            case DOCKER: {
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        numCmdArgs = 23 + containerCallParams.size();
                        break;
                    }
                    case CET_BINARY: {
                        numCmdArgs = 10 + containerCallParams.size();
                    }
                }
                break;
            }
            case SINGULARITY: {
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        numCmdArgs = 19 + containerCallParams.size();
                        break block7;
                    }
                    case CET_BINARY: {
                        numCmdArgs = 8 + containerCallParams.size();
                    }
                }
            }
        }
        String[] cmd = new String[numCmdArgs];
        int cmdIndex = 0;
        switch (this.container.getEngine()) {
            case DOCKER: {
                cmd[cmdIndex++] = "docker";
                cmd[cmdIndex++] = "run";
                cmd[cmdIndex++] = "-i";
                cmd[cmdIndex++] = "--rm";
                cmd[cmdIndex++] = "-v";
                cmd[cmdIndex++] = workingDirMountPoint + ":" + workingDirMountPoint;
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        cmd[cmdIndex++] = "-v";
                        cmd[cmdIndex++] = appDir + ":" + appDir;
                        cmd[cmdIndex++] = "-v";
                        cmd[cmdIndex++] = pyCompssDir + ":" + pyCompssDir;
                        cmd[cmdIndex++] = "--env";
                        cmd[cmdIndex++] = "PYTHONPATH=" + pythonPath + ":" + pyCompssDir;
                        break;
                    }
                }
                cmd[cmdIndex++] = "-w";
                cmd[cmdIndex++] = workingDir;
                cmd[cmdIndex++] = this.container.getImage();
                break;
            }
            case SINGULARITY: {
                cmd[cmdIndex++] = "singularity";
                cmd[cmdIndex++] = "exec";
                cmd[cmdIndex++] = "--bind";
                cmd[cmdIndex++] = workingDirMountPoint + ":" + workingDirMountPoint;
                switch (this.internalExecutionType) {
                    case CET_PYTHON: {
                        cmd[cmdIndex++] = "--bind";
                        cmd[cmdIndex++] = appDir + ":" + appDir;
                        cmd[cmdIndex++] = "--bind";
                        cmd[cmdIndex++] = pyCompssDir + ":" + pyCompssDir;
                        break;
                    }
                }
                cmd[cmdIndex++] = "--pwd";
                cmd[cmdIndex++] = workingDir;
                cmd[cmdIndex++] = this.container.getImage();
            }
        }
        switch (this.internalExecutionType) {
            case CET_PYTHON: {
                String[] parts = this.internalFunction.split("&");
                String userModule = parts[0];
                String userFunction = parts[1];
                cmd[cmdIndex++] = "python";
                cmd[cmdIndex++] = pyCompssDir + REL_PATH_WORKER_CONTAINER;
                cmd[cmdIndex++] = userModule;
                cmd[cmdIndex++] = userFunction;
                cmd[cmdIndex++] = String.valueOf(hasTarget);
                cmd[cmdIndex++] = returnType;
                cmd[cmdIndex++] = String.valueOf(returnLength);
                cmd[cmdIndex++] = String.valueOf(numContainerCallParams);
                break;
            }
            case CET_BINARY: {
                cmd[cmdIndex++] = this.internalBinary;
            }
        }
        for (int i = 0; i < containerCallParams.size(); ++i) {
            cmd[cmdIndex++] = (String)containerCallParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[CONTAINER INVOKER] Begin binary call to container execution");
            outLog.println("[CONTAINER INVOKER] Engine: " + this.container.getEngine().toString());
            outLog.println("[CONTAINER INVOKER] Image: " + this.container.getImage());
            outLog.println("[CONTAINER INVOKER] Internal Type: " + (Object)((Object)this.internalExecutionType));
            outLog.println("[CONTAINER INVOKER] Internal Binary: " + this.internalBinary);
            outLog.println("[CONTAINER INVOKER] Internal Function: " + this.internalFunction);
            outLog.println("[CONTAINER INVOKER] On WorkingDir : " + workingDir);
            outLog.print("[CONTAINER INVOKER] BINARY CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[CONTAINER INVOKER] Binary STDIN: " + streamValues.getStdIn());
            outLog.println("[CONTAINER INVOKER] Binary STDOUT: " + streamValues.getStdOut());
            outLog.println("[CONTAINER INVOKER] Binary STDERR: " + streamValues.getStdErr());
        }
        String completePythonpath = pythonPath + ":" + pyCompssDir;
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream(), completePythonpath, this.failByEV);
    }

    private void addParamInfo(List<String> paramsList, InvocationParam p) {
        paramsList.add(String.valueOf(p.getType().ordinal()));
        paramsList.add(String.valueOf(p.getStdIOStream().ordinal()));
        paramsList.add(p.getPrefix());
        paramsList.add(p.getName());
        paramsList.add("null");
        String value = String.valueOf(p.getValue());
        if (p.getType().equals((Object)DataType.STRING_T)) {
            paramsList.add("1");
            byte[] sharpedValue = ("#" + value).getBytes();
            String encodedValue = Base64.getEncoder().encodeToString(sharpedValue);
            paramsList.add(encodedValue);
        } else {
            paramsList.add(value);
        }
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling binary process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

