/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MPIImplementation;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;

public class MPIDefinition
extends ImplementationDefinition<MethodResourceDescription> {
    private final String binary;
    private final String workingDir;
    private final String mpiRunner;
    private final String mpiFlags;
    private final boolean scaleByCU;
    private final boolean failByEV;

    protected MPIDefinition(String signature, String binary, String workingDir, String mpiRunner, String mpiFlags, boolean scaleByCU, boolean failByEV, MethodResourceDescription implConstraints) {
        super(signature, implConstraints);
        this.binary = binary;
        this.workingDir = workingDir;
        this.mpiRunner = mpiRunner;
        this.mpiFlags = mpiFlags;
        this.scaleByCU = scaleByCU;
        this.failByEV = failByEV;
    }

    @Override
    public Implementation getImpl(int coreId, int implId) {
        return new MPIImplementation(this.binary, this.workingDir, this.mpiRunner, this.mpiFlags, this.scaleByCU, this.failByEV, coreId, implId, this.getSignature(), (MethodResourceDescription)this.getConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MPI Implementation \n");
        sb.append("\t Signature: ").append(this.getSignature()).append("\n");
        sb.append("\t Binary: ").append(this.binary).append("\n");
        sb.append("\t IO: ").append(!((MethodResourceDescription)this.getConstraints()).usesCPUs()).append("\n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t MPI flags: ").append(this.mpiFlags).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Scale by Computing Units: ").append(this.scaleByCU).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Constraints: ").append(this.getConstraints());
        return sb.toString();
    }
}

