/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.worker.implementations;

import es.bsc.compss.gat.worker.ImplementationDefinition;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MPIImplementation;
import es.bsc.compss.types.implementations.MethodType;

public class MPIDefinition
extends ImplementationDefinition {
    private final String mpiRunner;
    private final String mpiFlags;
    private final String mpiBinary;
    private final String workingDir;
    private final boolean scaleByCU;
    private final boolean failByEV;
    private final MPIImplementation impl;

    public MPIDefinition(boolean debug, String[] args, int execArgsIdx) {
        super(debug, args, execArgsIdx + 6);
        this.mpiRunner = args[execArgsIdx++];
        this.mpiFlags = args[execArgsIdx++];
        this.mpiBinary = args[execArgsIdx++];
        String wDir = args[execArgsIdx++];
        this.workingDir = wDir == null || wDir.isEmpty() || wDir.equals("[unassigned]") ? null : wDir;
        this.scaleByCU = Boolean.parseBoolean(args[execArgsIdx++]);
        this.failByEV = Boolean.parseBoolean(args[execArgsIdx++]);
        this.impl = new MPIImplementation(this.mpiBinary, this.workingDir, this.mpiRunner, this.mpiFlags, this.scaleByCU, this.failByEV, null, null, "", null);
    }

    @Override
    public AbstractMethodImplementation getMethodImplementation() {
        return this.impl;
    }

    @Override
    public MethodType getType() {
        return MethodType.MPI;
    }

    @Override
    public String toLogString() {
        return this.impl.getMethodDefinition();
    }
}

