/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.CollectionLayout;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PythonMPIImplementation
extends AbstractMethodImplementation
implements Externalizable {
    public static final int NUM_PARAMS = 8;
    private String declaringClass;
    private String alternativeMethod;
    private String mpiRunner;
    private String workingDir;
    private String mpiFlags;
    private boolean scaleByCU;
    private boolean failByEV;
    private CollectionLayout[] cls;

    public PythonMPIImplementation() {
    }

    public PythonMPIImplementation(String methodClass, String altMethodName, String workingDir, String mpiRunner, String mpiFlags, boolean scaleByCU, boolean failByEV, CollectionLayout[] cls, Integer coreId, Integer implementationId, String signature, MethodResourceDescription requirements) {
        super(coreId, implementationId, signature, requirements);
        this.declaringClass = methodClass;
        this.alternativeMethod = altMethodName;
        this.mpiRunner = mpiRunner;
        this.workingDir = workingDir;
        this.mpiFlags = mpiFlags;
        this.scaleByCU = scaleByCU;
        this.failByEV = failByEV;
        this.cls = cls;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getAlternativeMethodName() {
        return this.alternativeMethod;
    }

    public void setAlternativeMethodName(String alternativeMethod) {
        this.alternativeMethod = alternativeMethod;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    public String getMpiFlags() {
        return this.mpiFlags;
    }

    public boolean getScaleByCU() {
        return this.scaleByCU;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    public CollectionLayout[] getCollectionLayouts() {
        return this.cls;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.PYTHON_MPI;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DECLARING CLASS=").append(this.declaringClass);
        sb.append(", METHOD NAME=").append(this.alternativeMethod);
        sb.append(", MPI RUNNER=").append(this.mpiRunner);
        sb.append(", MPI FLAGS=").append(this.mpiFlags);
        sb.append(", SCALE_BY_CU=").append(this.scaleByCU);
        sb.append(", FAIL_BY_EV=").append(this.failByEV);
        sb.append(", Collection Layouts= ").append(this.cls.length);
        return sb.toString();
    }

    @Override
    public ImplementationDefinition<?> getDefinition() {
        return new PythonMPIDefinition(this.getSignature(), this.declaringClass, this.alternativeMethod, this.workingDir, this.mpiRunner, this.mpiFlags, this.scaleByCU, this.failByEV, this.cls, this.getRequirements());
    }

    @Override
    public String toString() {
        return super.toString() + " Python MPI Method declared in class " + this.declaringClass + "." + this.alternativeMethod + " with MPIrunner " + this.mpiRunner;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.declaringClass = (String)in.readObject();
        this.alternativeMethod = (String)in.readObject();
        this.mpiRunner = (String)in.readObject();
        this.mpiFlags = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.scaleByCU = in.readBoolean();
        this.failByEV = in.readBoolean();
        this.cls = (CollectionLayout[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.declaringClass);
        out.writeObject(this.alternativeMethod);
        out.writeObject(this.mpiRunner);
        out.writeObject(this.mpiFlags);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.scaleByCU);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.cls);
    }
}

