/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.execution;

import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.util.FileOperations;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionSandbox {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private final File folder;
    private final String folderAbsolutePath;
    private final boolean isSpecific;

    public ExecutionSandbox(File folder, boolean isSpecific) {
        this.folder = folder;
        this.folderAbsolutePath = folder.getAbsolutePath() + File.separator;
        this.isSpecific = isSpecific;
    }

    public File getFolder() {
        return this.folder;
    }

    public void create() throws IOException {
        if (!this.isSpecific && this.folder.exists()) {
            LOGGER.debug("Deleting folder " + this.folder.toString());
            if (!this.folder.delete()) {
                LOGGER.warn("Cannot delete working dir folder: " + this.folder.toString());
            }
        }
        Files.createDirectories(this.folder.toPath(), new FileAttribute[0]);
    }

    public String addFile(String dataId, File externalFile, String internalName) throws IOException {
        String internalPath = this.folderAbsolutePath + internalName;
        File internalFile = new File(internalPath);
        if (externalFile.exists()) {
            Path internalP = internalFile.toPath();
            if (internalFile.exists()) {
                if (Files.isSymbolicLink(internalP)) {
                    internalPath = this.manageOverlapInSymlink(dataId, internalName, internalP, externalFile);
                } else {
                    LOGGER.warn("WARNING: Strange case for param " + dataId + " where renamed and in sandbox already exists and it is not linked with a Symlink");
                }
            } else {
                Path externalP = externalFile.toPath();
                LOGGER.debug("Creating symlink " + internalP + " pointing to " + externalP);
                Files.createSymbolicLink(internalP, externalP, new FileAttribute[0]);
            }
        } else if (internalFile.exists()) {
            internalPath = this.folderAbsolutePath + dataId + "_" + internalName;
        }
        return internalPath;
    }

    private String manageOverlapInSymlink(String dataId, String internalName, Path existingLink, File external) throws IOException {
        String resultLink = null;
        Path oExternalP = Files.readSymbolicLink(existingLink);
        String oRename = oExternalP.getFileName().toString();
        String nRename = external.getName();
        LOGGER.debug("Checking if " + nRename + " is equal to " + oRename);
        switch (this.checkDataVersion(nRename, oRename)) {
            case SAME_DATA_VERSION: 
            case SAME_DATA_MINOR_VERSION: {
                resultLink = existingLink.toString();
                break;
            }
            case SAME_DATA_MAJOR_VERSION: {
                Path nExternalP = external.toPath();
                LOGGER.debug("Updating Symbolic link " + existingLink + "->" + nExternalP.toString());
                Files.delete(existingLink);
                Files.createSymbolicLink(existingLink, nExternalP, new FileAttribute[0]);
                resultLink = existingLink.toString();
                break;
            }
            case DIFF_DATA: {
                Path nExternalP = external.toPath();
                String newInternalName = this.folderAbsolutePath + dataId + "_" + internalName;
                File newSandboxFile = new File(newInternalName);
                Path nInternalP = newSandboxFile.toPath();
                LOGGER.debug("Creating Symbolic link " + nInternalP.toString() + "->" + nExternalP.toString());
                Files.createSymbolicLink(newSandboxFile.toPath(), nExternalP, new FileAttribute[0]);
                resultLink = newInternalName;
                break;
            }
            case ERROR: {
                LOGGER.warn("ERROR: There was an error extracting data versions for " + oRename + " and " + nRename);
            }
        }
        return resultLink;
    }

    private DataComparison checkDataVersion(String file1, String file2) {
        String[] version1array = file1.split("_")[0].split("v");
        String[] version2array = file2.split("_")[0].split("v");
        if (version1array.length < 2 || version2array.length < 2) {
            return DataComparison.ERROR;
        }
        if (version1array[1].compareTo(version2array[1]) == 0) {
            try {
                int version1int = Integer.parseInt(version1array[1]);
                int version2int = Integer.parseInt(version2array[1]);
                if (version1int > version2int) {
                    return DataComparison.SAME_DATA_MAJOR_VERSION;
                }
                if (version1int == version2int) {
                    return DataComparison.SAME_DATA_VERSION;
                }
                return DataComparison.SAME_DATA_MINOR_VERSION;
            }
            catch (NumberFormatException e) {
                return DataComparison.ERROR;
            }
        }
        return DataComparison.DIFF_DATA;
    }

    public void removeFile(String internalPath, String externalPath) throws IOException, JobExecutionException {
        File internalFile = new File(internalPath);
        File externalFile = new File(externalPath);
        Path iPath = internalFile.toPath();
        if (externalFile.exists()) {
            if (Files.isSymbolicLink(iPath)) {
                LOGGER.debug("Deleting symlink " + iPath);
                FileOperations.deleteFile(internalFile, LOGGER);
            } else {
                LOGGER.debug("Moving from " + internalFile + " to " + externalFile);
                FileOperations.deleteFile(externalFile, LOGGER);
                FileOperations.moveFile(internalFile, externalFile, LOGGER);
            }
        } else {
            if (Files.isSymbolicLink(iPath)) {
                String msg = "ERROR: Unexpected case. A Problem occurred with File " + internalFile + ". Either this file or the original name " + externalPath + " does not exist.";
                LOGGER.error(msg);
                throw new JobExecutionException(msg);
            }
            FileOperations.moveFile(internalFile, externalFile, LOGGER);
        }
    }

    public void clean() {
        if (!this.isSpecific && this.folder != null && this.folder.exists() && this.folder.isDirectory()) {
            try {
                LOGGER.debug("Deleting sandbox " + this.folder.toPath());
                FileOperations.deleteFile(this.folder, LOGGER);
            }
            catch (IOException e) {
                LOGGER.warn("Error deleting sandbox " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static enum DataComparison {
        SAME_DATA_VERSION,
        SAME_DATA_MAJOR_VERSION,
        SAME_DATA_MINOR_VERSION,
        DIFF_DATA,
        ERROR;

    }
}

