/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.executor.external.piped.ControlPipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.invokers.types.RParams;
import es.bsc.compss.types.execution.InvocationContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class RMirror
extends PipedMirror {
    private static final String BINDINGS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "bindings-common" + File.separator + "lib";
    private static final String R_PIPER = "r_piper.sh";
    private static final String LIBRARY_PATH_ENV = "LD_LIBRARY_PATH";
    private static final String R_LIB_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "r" + File.separator + "lib";
    private static final String R_LIBS_PATH_ENV = "R_LIBS";

    public RMirror(InvocationContext context, int size) {
        super(context, size);
        this.init(context);
    }

    @Override
    public String getMirrorName() {
        return "R";
    }

    @Override
    public String getPipeBuilderContext() {
        StringBuilder cmd = new StringBuilder();
        return cmd.toString();
    }

    @Override
    public String getLaunchWorkerCommand(InvocationContext context, ControlPipePair pipe) {
        int i;
        StringBuilder cmd = new StringBuilder();
        String installDir = context.getInstallDir();
        cmd.append(installDir).append(PIPER_SCRIPT_RELATIVE_PATH).append(R_PIPER).append(" ");
        String executorPipes = this.basePipePath + "executor";
        cmd.append(this.size).append(" ");
        for (i = 0; i < this.size; ++i) {
            cmd.append(executorPipes).append(i).append(".outbound").append(" ");
        }
        cmd.append(this.size).append(" ");
        for (i = 0; i < this.size; ++i) {
            cmd.append(executorPipes).append(i).append(".inbound").append(" ");
        }
        cmd.append(pipe.getOutboundPipe()).append(" ");
        cmd.append(pipe.getInboundPipe());
        return cmd.toString();
    }

    @Override
    public Map<String, String> getEnvironment(InvocationContext context) {
        String ldLibraryPath = System.getenv(LIBRARY_PATH_ENV);
        String rlibs = System.getenv(R_LIBS_PATH_ENV);
        RParams rParams = (RParams)context.getLanguageParams(COMPSsConstants.Lang.R);
        rlibs = rlibs == null ? rParams.getRPath() : rlibs.concat(":" + rParams.getRPath());
        ldLibraryPath = ldLibraryPath == null ? context.getInstallDir() + R_LIB_RELATIVE_PATH : ldLibraryPath.concat(":" + context.getInstallDir() + R_LIB_RELATIVE_PATH);
        ldLibraryPath = ldLibraryPath.concat(":" + context.getInstallDir() + BINDINGS_RELATIVE_PATH);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(LIBRARY_PATH_ENV, ldLibraryPath);
        env.put(R_LIBS_PATH_ENV, rlibs);
        return env;
    }
}

