/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDescription;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class ContainerDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 9;
    public static final String SIGNATURE = "container.CONTAINER";
    private ContainerDescription container;
    private ContainerExecutionType internalExecutionType;
    private String internalBinary;
    private String internalParams;
    private String internalFunc;
    private String workingDir;
    private boolean failByEV;

    public ContainerDefinition() {
    }

    public ContainerDefinition(ContainerExecutionType internalExecutionType, String internalFunc, String internalBinary, String internalParams, String workingDir, boolean failByEV, ContainerDescription container) {
        this.internalExecutionType = internalExecutionType;
        this.internalBinary = internalBinary;
        this.internalParams = internalParams;
        this.internalFunc = internalFunc;
        this.workingDir = workingDir;
        this.failByEV = failByEV;
        this.container = container;
    }

    public ContainerDefinition(String[] implTypeArgs, int offset) {
        String engineStr = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        engineStr = engineStr.toUpperCase();
        ContainerDescription.ContainerEngine engine = ContainerDescription.ContainerEngine.valueOf(engineStr);
        String image = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        String options = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.container = new ContainerDescription(engine, image, options);
        String internalTypeContainerStr = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        internalTypeContainerStr = internalTypeContainerStr.toUpperCase();
        this.internalExecutionType = ContainerExecutionType.valueOf(internalTypeContainerStr);
        this.internalBinary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 4]);
        this.internalParams = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 5]);
        this.internalFunc = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 6]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 7]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 8]);
        switch (this.internalExecutionType) {
            case CET_BINARY: {
                if (this.internalBinary != null && !this.internalBinary.isEmpty() && !this.internalBinary.equals("[unassigned]")) break;
                throw new IllegalArgumentException("Empty binary annotation for CONTAINER method");
            }
            case CET_PYTHON: {
                if (this.internalFunc != null && !this.internalFunc.isEmpty() && !this.internalFunc.equals("[unassigned]")) break;
                throw new IllegalArgumentException("Empty python function annotation for CONTAINER method");
            }
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.container.getEngine().toString());
        lArgs.add(this.container.getImage());
        lArgs.add(this.container.getOptions());
        lArgs.add(this.internalExecutionType.toString());
        lArgs.add(this.internalBinary);
        lArgs.add(this.internalParams);
        lArgs.add(this.internalFunc);
        lArgs.add(this.workingDir);
        lArgs.add(Boolean.toString(this.failByEV));
    }

    public ContainerExecutionType getInternalExecutionType() {
        return this.internalExecutionType;
    }

    public String getInternalBinary() {
        return this.internalBinary;
    }

    public String getInternalParams() {
        return this.internalParams;
    }

    public String getInternalFunction() {
        return this.internalFunc;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    public ContainerDescription getContainer() {
        return this.container;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.CONTAINER;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder("{\"type\":\"CONTAINER\",");
        sb.append("\"container\":").append(this.container == null ? null : this.container.toJSON());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return "ContainerImplementation [container=" + this.container + ", internalExecutionType=" + (Object)((Object)this.internalExecutionType) + ", binary=" + this.internalBinary + ", pyFunc=" + this.internalFunc + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.internalExecutionType = (ContainerExecutionType)((Object)in.readObject());
        this.internalFunc = (String)in.readObject();
        this.internalBinary = (String)in.readObject();
        this.internalParams = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.failByEV = in.readBoolean();
        this.container = (ContainerDescription)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.internalExecutionType);
        out.writeObject(this.internalFunc);
        out.writeObject(this.internalBinary);
        out.writeObject(this.internalParams);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.container);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Container Implementation \n");
        sb.append("\t Container: ").append(this.container).append("\n");
        sb.append("\t InternalExecutionType: ").append((Object)this.internalExecutionType).append("\n");
        sb.append("\t InternalBinary: ").append(this.internalBinary).append("\n");
        sb.append("\t InternalParams: ").append(this.internalParams).append("\n");
        sb.append("\t InternalFunction: ").append(this.internalFunc).append("\n");
        return sb.toString();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    public static enum ContainerExecutionType {
        CET_PYTHON,
        CET_BINARY;

    }
}

