/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.worker;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.gat.executor.types.ExecutionEnd;
import es.bsc.compss.gat.worker.GATInvocation;
import es.bsc.compss.gat.worker.GATLog;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationExecutionRequest;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.NonExistentDataException;
import es.bsc.compss.types.execution.exceptions.UnloadableValueException;
import es.bsc.compss.types.execution.exceptions.UnwritableValueException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.util.serializers.Serializer;
import es.bsc.compss.utils.execution.ExecutionManager;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.exceptions.DistroStreamClientInitException;
import es.bsc.distrostreamlib.requests.StopRequest;
import es.bsc.distrostreamlib.server.types.StreamBackend;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Semaphore;
import storage.StorageException;
import storage.StorageItf;

public class GATWorker
implements InvocationContext {
    private static final String ERROR_STREAMING_INIT = "ERROR: Cannot load Streaming Client";
    private static final String ERROR_STREAMING_FINISH = "ERROR: Cannot stop Streaming Client";
    private static final String ERROR_STORAGE_CONF_INIT = "ERROR: Cannot load storage configuration file: ";
    private static final String ERROR_STORAGE_CONF_FINISH = "ERROR: Cannot stop StorageItf";
    private static final String EXECUTION_MANAGER_ERR = "Error starting ExecutionManager";
    private static final String WARN_UNSUPPORTED_METHOD_TYPE = "WARNING: Unsupported method type";
    private static final int DEFAULT_FLAGS_SIZE = 9;
    private static final int WORKER_NAME_IDX = 0;
    private static final int WORKING_DIR_IDX = 1;
    private static final int DEBUG_IDX = 2;
    private static final int INSTALL_DIR_IDX = 3;
    private static final int APP_DIR_IDX = 4;
    private static final int STORAGE_CONF_IDX = 5;
    private static final int STREAMING_IDX = 6;
    private static final int STREAMING_MASTER_IDX = 7;
    private static final int STREAMING_PORT_IDX = 8;
    private final String hostName;
    private final boolean debug;
    private final String appDir;
    private final String installDir;
    private final String workingDir;
    private final String storageConf;
    private final StreamBackend streamBackend;
    private final String streamMasterName;
    private final int streamMasterPort;
    private final ExecutionManager executionManager;

    public static void main(String[] args) throws Exception {
        String storageConfArg;
        String workerName = args[0];
        String workingDir = args[1];
        boolean debug = Boolean.valueOf(args[2]);
        String installDir = args[3];
        String appDir = args[4];
        GATLog.init(debug);
        String streamingArg = args[6];
        String streaming = streamingArg == null || streamingArg.isEmpty() || streamingArg.equals("null") ? "NONE" : streamingArg.toUpperCase();
        StreamBackend streamBackend = StreamBackend.valueOf(streaming);
        String streamMasterName = args[7];
        int streamMasterPort = Integer.parseInt(args[8]);
        if (!streamBackend.equals((Object)StreamBackend.NONE)) {
            try {
                DistroStreamClient.initAndStart(streamMasterName, streamMasterPort);
            }
            catch (DistroStreamClientInitException dscie) {
                ErrorManager.fatal(ERROR_STREAMING_INIT, dscie);
            }
        }
        String storageConf = (storageConfArg = args[5]) == null || storageConfArg.isEmpty() || storageConfArg.equals("null") ? "" : storageConfArg;
        System.setProperty("compss.storage.conf", storageConf);
        if (!storageConf.isEmpty()) {
            try {
                StorageItf.init(storageConf);
            }
            catch (StorageException se) {
                ErrorManager.fatal(ERROR_STORAGE_CONF_INIT + storageConf, se);
            }
        }
        GATInvocation implDef = GATWorker.parseArguments(args);
        GATWorker worker = new GATWorker(workerName, workingDir, debug, installDir, appDir, storageConf, streamBackend, streamMasterName, streamMasterPort, implDef.getComputingUnits());
        boolean success = worker.runTask(implDef);
        if (!streamBackend.equals((Object)StreamBackend.NONE)) {
            StopRequest stopRequest = new StopRequest();
            DistroStreamClient.request(stopRequest);
            stopRequest.waitProcessed();
            int errorCode = stopRequest.getErrorCode();
            if (errorCode != 0) {
                System.err.println(ERROR_STREAMING_FINISH);
                System.err.println("Error Code: " + errorCode);
                System.err.println("Error Message: " + stopRequest.getErrorMessage());
            }
        }
        if (!storageConf.isEmpty()) {
            try {
                StorageItf.finish();
            }
            catch (StorageException se) {
                System.err.println(ERROR_STORAGE_CONF_FINISH);
                se.printStackTrace();
            }
        }
        if (!success) {
            System.exit(7);
        }
    }

    public GATWorker(String workerName, String workingDir, boolean debug, String installDir, String appDir, String storageConf, StreamBackend streamBackend, String streamMasterName, int streamMasterPort, int computingUnitsCPU) {
        this.hostName = workerName;
        this.debug = debug;
        this.appDir = appDir;
        this.installDir = installDir;
        this.workingDir = workingDir;
        this.storageConf = storageConf;
        this.streamBackend = streamBackend;
        this.streamMasterName = streamMasterName;
        this.streamMasterPort = streamMasterPort;
        this.executionManager = new ExecutionManager(this, computingUnitsCPU, "disabled", false, 0, "disabled", 0, "disabled", 0, 1);
        if (this.debug) {
            System.out.println("Initializing ExecutionManager");
        }
        try {
            this.executionManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(EXECUTION_MANAGER_ERR, ie);
        }
    }

    private static GATInvocation parseArguments(String[] args) {
        int argPosition = 9;
        boolean debug = Boolean.valueOf(args[2]);
        MethodType methodType = MethodType.valueOf(args[argPosition++]);
        switch (methodType) {
            case METHOD: {
                return GATWorker.genImplemenationDefinition(new MethodDefinition(args, argPosition), debug, args, argPosition + 2);
            }
            case BINARY: {
                return GATWorker.genImplemenationDefinition(new BinaryDefinition(args, argPosition, null), debug, args, argPosition + 4);
            }
            case MPI: {
                String[] container = new String[3];
                return GATWorker.genImplemenationDefinition(new MPIDefinition(args, argPosition, container), debug, args, argPosition + 8);
            }
            case COMPSs: {
                return GATWorker.genImplemenationDefinition(new COMPSsDefinition(args, argPosition), debug, args, argPosition + 7);
            }
            case DECAF: {
                return GATWorker.genImplemenationDefinition(new DecafDefinition(args, argPosition), debug, args, argPosition + 6);
            }
            case MULTI_NODE: {
                return GATWorker.genImplemenationDefinition(new MultiNodeDefinition(args, argPosition), debug, args, argPosition + 3);
            }
            case OMPSS: {
                return GATWorker.genImplemenationDefinition(new OmpSsDefinition(args, argPosition), debug, args, argPosition + 3);
            }
            case OPENCL: {
                return GATWorker.genImplemenationDefinition(new OpenCLDefinition(args, argPosition), debug, args, argPosition + 2);
            }
            case PYTHON_MPI: {
                PythonMPIDefinition pyMPIDef = new PythonMPIDefinition(args, argPosition);
                return GATWorker.genImplemenationDefinition(pyMPIDef, debug, args, argPosition + 10 + pyMPIDef.getCollectionLayouts().length * 4);
            }
            case CONTAINER: {
                return GATWorker.genImplemenationDefinition(new ContainerDefinition(args, argPosition), debug, args, argPosition + 9);
            }
        }
        ErrorManager.error(WARN_UNSUPPORTED_METHOD_TYPE + (Object)((Object)methodType));
        return null;
    }

    private static GATInvocation genImplemenationDefinition(AbstractMethodImplementationDefinition implDef, boolean debug, String[] args, int argPosition) {
        ImplementationDescription<Object, AbstractMethodImplementationDefinition> implDesc = new ImplementationDescription<Object, AbstractMethodImplementationDefinition>(implDef, "", false, null, null, null);
        AbstractMethodImplementation impl = new AbstractMethodImplementation((Integer)0, (Integer)0, (ImplementationDescription<MethodResourceDescription, AbstractMethodImplementationDefinition>)implDesc);
        return new GATInvocation(debug, impl, args, argPosition);
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public long getTracingHostID() {
        return 0L;
    }

    @Override
    public String getAppDir() {
        return this.appDir;
    }

    @Override
    public String getInstallDir() {
        return this.installDir;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public String getLogDir() {
        return this.workingDir;
    }

    @Override
    public String getAnalysisDir() {
        return this.workingDir + "analysis/";
    }

    @Override
    public PrintStream getThreadOutStream() {
        return System.out;
    }

    @Override
    public PrintStream getThreadErrStream() {
        return System.err;
    }

    @Override
    public COMPSsConstants.TaskExecution getExecutionType() {
        return COMPSsConstants.TaskExecution.COMPSS;
    }

    @Override
    public boolean isPersistentCEnabled() {
        return false;
    }

    @Override
    public LanguageParams getLanguageParams(COMPSsConstants.Lang language) {
        return null;
    }

    @Override
    public void registerOutputs(String outputsBasename) {
    }

    @Override
    public void unregisterOutputs() {
    }

    @Override
    public String getStandardStreamsPath(Invocation invocation) {
        return null;
    }

    @Override
    public String getStorageConf() {
        return this.storageConf;
    }

    @Override
    public StreamBackend getStreamingBackend() {
        return this.streamBackend;
    }

    @Override
    public String getStreamingMasterName() {
        return this.streamMasterName;
    }

    @Override
    public int getStreamingMasterPort() {
        return this.streamMasterPort;
    }

    @Override
    public void loadParam(InvocationParam np) throws UnloadableValueException {
        switch (np.getType()) {
            case OBJECT_T: 
            case STREAM_T: {
                String fileLocation = (String)np.getValue();
                np.setOriginalName(fileLocation);
                try {
                    Object o = Serializer.deserialize(fileLocation);
                    np.setValue(o);
                    break;
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new UnloadableValueException(e);
                }
            }
            case PSCO_T: {
                String pscoId = (String)np.getValue();
                try {
                    StorageItf.getByID(pscoId);
                    break;
                }
                catch (StorageException se) {
                    throw new UnloadableValueException(se);
                }
            }
            case FILE_T: 
            case EXTERNAL_STREAM_T: 
            case BINDING_OBJECT_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    @Override
    public void storeParam(InvocationParam np, boolean createifNonExistent) throws UnwritableValueException, NonExistentDataException {
        switch (np.getType()) {
            case FILE_T: {
                String filepath = (String)np.getValue();
                if (Tracer.isActivated()) {
                    Tracer.emitEvent(TraceEvent.CHECK_OUT_PARAM);
                }
                File f = new File(filepath);
                boolean fExists = f.exists();
                if (Tracer.isActivated()) {
                    Tracer.emitEventEnd(TraceEvent.CHECK_OUT_PARAM);
                }
                if (fExists) break;
                if (createifNonExistent) {
                    System.out.println("Creating new blank file at " + filepath);
                    try {
                        f.createNewFile();
                    }
                    catch (IOException e) {
                        if (this.debug) {
                            System.err.println("ERROR creating new blank file at " + filepath);
                        }
                        throw new UnwritableValueException(e);
                    }
                }
                throw new NonExistentDataException(filepath);
            }
            case OBJECT_T: 
            case STREAM_T: {
                String fileLocation = np.getOriginalName();
                System.out.println("Storing parameter " + np.getName() + " in " + fileLocation);
                try {
                    Serializer.serialize(np.getValue(), fileLocation);
                    break;
                }
                catch (IOException ioe) {
                    throw new UnwritableValueException(ioe);
                }
            }
            case PSCO_T: {
                throw new UnsupportedOperationException("Output PSCOs are not suported with the GAT adaptor");
            }
            case EXTERNAL_STREAM_T: 
            case BINDING_OBJECT_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    private boolean runTask(GATInvocation task) {
        final ExecutionEnd status = new ExecutionEnd();
        final Semaphore sem = new Semaphore(0);
        InvocationExecutionRequest.Listener listener = new InvocationExecutionRequest.Listener(){

            @Override
            public void onResultAvailable(InvocationParam param) {
            }

            @Override
            public void notifyEnd(Invocation invocation, boolean success, COMPSsException e) {
                status.setSuccess(success);
                sem.release();
            }
        };
        InvocationExecutionRequest e = new InvocationExecutionRequest(task, listener);
        this.executionManager.enqueue(e);
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.executionManager.stop();
        return status.getSuccess();
    }

    @Override
    public COMPSsRuntime getRuntimeAPI() {
        return null;
    }

    @Override
    public LoaderAPI getLoaderAPI() {
        return null;
    }

    @Override
    public void idleReservedResourcesDetected(ResourceDescription resources) {
    }

    @Override
    public void reactivatedReservedResourcesDetected(ResourceDescription resources) {
    }

    @Override
    public String getEnvironmentScript() {
        return null;
    }

    @Override
    public boolean getEar() {
        return false;
    }
}

