/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.types;

import es.bsc.compss.executor.types.ParameterResult;
import es.bsc.compss.types.annotations.parameter.DataType;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalTaskStatus {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final String CANNOT_PARSE_ERROR = "Could not parse Collection results";
    private final Integer exitValue;
    private final List<ParameterResult> results;

    public ExternalTaskStatus(Integer exitValue) {
        this.exitValue = exitValue;
        this.results = new LinkedList<ParameterResult>();
    }

    public ExternalTaskStatus(String[] line) {
        this.results = new LinkedList<ParameterResult>();
        this.exitValue = Integer.parseInt(line[2]);
        if (line.length > 3) {
            int numParams = Integer.parseInt(line[3]);
            if (4 + 2 * numParams != line.length) {
                LOGGER.warn("WARN: Skipping endTask parameters because of malformation.");
                numParams = (line.length - 4) / 2;
            }
            for (int i = 0; i < numParams; ++i) {
                int paramTypeOrdinalIndex = 0;
                try {
                    paramTypeOrdinalIndex = Integer.parseInt(line[4 + 2 * i]);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("WARN: Number format exception on " + line[4 + 2 * i] + ". Setting type 0", (Throwable)nfe);
                }
                DataType paramType = DataType.values()[paramTypeOrdinalIndex];
                String paramValue = line[5 + 2 * i];
                if (paramValue.equalsIgnoreCase("null")) {
                    paramValue = null;
                }
                this.results.add(this.createResult(paramType, paramValue));
            }
        } else {
            LOGGER.warn("WARN: endTask message does not have task result parameters");
        }
    }

    private ParameterResult createResult(DataType type, String value) {
        if (type == DataType.COLLECTION_T) {
            return new ParameterResult.CollectiveResult(type, this.createCollectionResultValue(value));
        }
        return new ParameterResult.SingleResult(type, value);
    }

    private List<ParameterResult> createCollectionResultValue(String value) {
        if (value == null || value.isEmpty()) {
            return new LinkedList<ParameterResult>();
        }
        List<ParameterResult> result = null;
        StringCharacterIterator it = new StringCharacterIterator(value);
        char c = it.current();
        while (c != '\uffff') {
            if (c == '[') {
                try {
                    result = this.parseCollection(it);
                }
                catch (Exception e) {
                    LOGGER.warn(CANNOT_PARSE_ERROR + value);
                    return null;
                }
                c = it.next();
                continue;
            }
            LOGGER.warn(CANNOT_PARSE_ERROR + value);
            return null;
        }
        return result;
    }

    private List<ParameterResult> parseCollection(CharacterIterator it) throws Exception {
        LinkedList<ParameterResult> result = new LinkedList<ParameterResult>();
        char c = it.next();
        block10: while (c != '\uffff') {
            switch (c) {
                case ']': {
                    it.next();
                    return result;
                }
                case '[': {
                    try {
                        List<ParameterResult> subCollection = this.parseCollection(it);
                        result.add(new ParameterResult.CollectiveResult(DataType.COLLECTION_T, subCollection));
                        c = it.current();
                        continue block10;
                    }
                    catch (Exception e) {
                        throw new Exception("CANNOT_PARSE_ERROR");
                    }
                }
                case '(': {
                    try {
                        ParameterResult.SingleResult element = this.parseElement(it);
                        result.add(element);
                        c = it.next();
                        continue block10;
                    }
                    catch (Exception e) {
                        throw new Exception("CANNOT_PARSE_ERROR");
                    }
                }
                case ',': {
                    c = it.next();
                    continue block10;
                }
            }
            throw new Exception("CANNOT_PARSE_ERROR");
        }
        return result;
    }

    private ParameterResult.SingleResult parseElement(CharacterIterator it) throws Exception {
        char c;
        StringBuilder typeSB = new StringBuilder();
        StringBuilder valueSB = new StringBuilder();
        StringBuilder appender = typeSB;
        block4: while ((c = it.next()) != '\uffff') {
            switch (c) {
                case ')': {
                    DataType type = DataType.values()[Integer.parseInt(typeSB.toString())];
                    String value = valueSB.toString();
                    if (value.equalsIgnoreCase("null")) {
                        value = null;
                    }
                    return new ParameterResult.SingleResult(type, value);
                }
                case ',': {
                    appender = valueSB;
                    continue block4;
                }
            }
            appender.append(c);
        }
        throw new Exception("CANNOT_PARSE_ERROR");
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public List<ParameterResult> getResults() {
        return this.results;
    }

    public int getNumParameters() {
        return this.results.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalTaskStatus [ ");
        sb.append("ExitValue = ").append(this.exitValue).append(", ");
        sb.append("NumParameters = ").append(this.getNumParameters()).append(", ");
        sb.append("Parameter = [");
        for (ParameterResult r : this.results) {
            sb.append(r.toString()).append(" ");
        }
        sb.append("]");
        sb.append(" ]");
        return sb.toString();
    }
}

