/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.types.implementations.definition.CommonMPIDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class DecafDefinition
extends CommonMPIDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 6;
    public static final String SIGNATURE = "decaf.DECAF";
    private static final String ERROR_DECAF_BINARY = "ERROR: Invalid wfScript";
    public static final String SCRIPT_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "decaf" + File.separator + "run_decaf.sh";
    private String dfScript;
    private String dfExecutor;
    private String dfLib;

    public DecafDefinition() {
    }

    public DecafDefinition(String dfScript, String dfExecutor, String dfLib, String workingDir, String mpiRunner, boolean failByEV) {
        super(workingDir, mpiRunner, 1, "", true, failByEV);
        this.dfScript = dfScript;
        this.dfExecutor = dfExecutor;
        this.dfLib = dfLib;
    }

    public DecafDefinition(String[] implTypeArgs, int offset) {
        this.dfScript = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.dfExecutor = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.dfLib = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        this.mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 4]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 5]);
        if (this.mpiRunner == null || this.mpiRunner.isEmpty()) {
            throw new IllegalArgumentException("Empty mpiRunner annotation for DECAF method ");
        }
        if (this.dfScript == null || this.dfScript.isEmpty()) {
            throw new IllegalArgumentException("Empty dfScript annotation for DECAF method ");
        }
        this.scaleByCU = true;
        this.mpiFlags = "";
        this.ppn = 1;
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        String script = this.dfScript;
        if (!script.startsWith(File.separator)) {
            script = auxParam + File.separator + script;
        }
        lArgs.add(script);
        String executor = this.dfExecutor;
        if (executor == null || executor.isEmpty() || executor.equals("[unassigned]")) {
            executor = "executor.sh";
        }
        if (!executor.startsWith(File.separator) && !executor.startsWith("./")) {
            executor = "./" + executor;
        }
        lArgs.add(executor);
        String lib = this.dfLib;
        if (lib == null || lib.isEmpty()) {
            lib = "[unassigned]";
        }
        lArgs.add(lib);
        lArgs.add(this.workingDir);
        lArgs.add(this.mpiRunner);
        lArgs.add(Boolean.toString(this.failByEV));
    }

    public String getDfScript() {
        return this.dfScript;
    }

    public String getDfExecutor() {
        return this.dfExecutor;
    }

    public String getDfLib() {
        return this.dfLib;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.DECAF;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder("{\"type\":\"DECAF\",");
        sb.append("\"mpi_runner\":\"").append(this.mpiRunner).append("\",");
        sb.append("\"df_script\":\"").append(this.dfScript).append("\",");
        sb.append("\"df_executor\":\"").append(this.dfExecutor).append("\",");
        sb.append("\"df_library\":\"").append(this.dfLib).append("\"");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return super.toString() + " Decaf Method with script " + this.dfScript + ", executor " + this.dfScript + ", library " + this.dfLib + " and MPIrunner " + this.mpiRunner;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DECAF Implementation \n");
        sb.append("\t Decaf script: ").append(this.dfScript).append("\n");
        sb.append("\t Decaf executor: ").append(this.dfExecutor).append("\n");
        sb.append("\t Decaf lib: ").append(this.dfLib).append("\n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mpiRunner = (String)in.readObject();
        this.dfScript = (String)in.readObject();
        this.dfExecutor = (String)in.readObject();
        this.dfLib = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.failByEV = in.readBoolean();
        this.scaleByCU = true;
        this.mpiFlags = "";
        this.ppn = 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.mpiRunner);
        out.writeObject(this.dfScript);
        out.writeObject(this.dfExecutor);
        out.writeObject(this.dfLib);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.failByEV);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    @Override
    public void checkArguments() {
        if (this.dfScript == null || this.dfScript.isEmpty()) {
            throw new IllegalArgumentException(ERROR_DECAF_BINARY);
        }
        if (this.dfExecutor == null || this.dfExecutor.isEmpty() || this.dfExecutor.equals("[unassigned]")) {
            this.dfExecutor = "executor.sh";
        }
        if (!this.dfExecutor.startsWith(File.separator) && !this.dfExecutor.startsWith("./")) {
            this.dfExecutor = "./" + this.dfExecutor;
        }
        if (this.dfLib == null || this.dfLib.isEmpty()) {
            this.dfLib = "null";
        }
    }

    public void setDfScript(String dfScript) {
        this.dfScript = dfScript;
    }
}

